/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.provisioner.cli.CliArgumentException;
import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.cli.InternalDbCommand;
import com.pingidentity.provisioner.directory.spring.SpringLdapGuidFormatter;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.store.ProvisionableResourceMeta;
import com.pingidentity.provisioner.store.groups.GroupMembershipStore;
import com.pingidentity.provisioner.store.groups.GroupStore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.sourceid.saml20.domain.LdapDataSource;

public class ShowGroupCommand
extends InternalDbCommand {
    @Override
    protected Option createOption() {
        return new Option(null, "show-group", false, "Show internal DB group details [c,u|g]");
    }

    @Override
    public void execute(CommandLine cli, Options options) throws CliException {
        ProvisionableResourceMeta groupMeta;
        int channelId = this.getChannelId(cli);
        GroupStore groupStore = this.getGroupStore(channelId);
        GroupMembershipStore groupMembershipStore = this.getGroupMembershipStore(channelId);
        String directoryServerGuid = null;
        if (cli.hasOption(this._saasUsernameOption.getOpt())) {
            groupMeta = groupStore.getMetaBySaasName(this.getSaasUsername(cli));
        } else if (cli.hasOption(this._ldapGuidOption.getOpt())) {
            directoryServerGuid = this.getLdapGuid(cli);
            groupMeta = groupStore.getMetaByDirectoryGuid(directoryServerGuid);
        } else {
            throw new CliArgumentException("Missing argument, provide one of: " + this._saasUsernameOption.getArgName() + " or " + this._ldapGuidOption.getArgName());
        }
        if (groupMeta != null) {
            directoryServerGuid = groupMeta.getDirectoryServerGuid();
            ArrayList<Vector<String>> dbTable = new ArrayList<Vector<String>>();
            this.addRow(dbTable, "SaaS Group Name", groupMeta.getSaasUsername());
            this.addRow(dbTable, "SaaS GUID", groupMeta.getSaasGuid());
            this.addRow(dbTable, "LDAP GUID", groupMeta.getDirectoryServerGuid());
            if (this.isActiveDirectory(channelId)) {
                this.addRow(dbTable, "  ActiveDirectory String", "{" + SpringLdapGuidFormatter.hexToAdString(groupMeta.getDirectoryServerGuid()) + "}");
            }
            this.addRow(dbTable, "In Group", groupMeta.isInGroup());
            this.addRow(dbTable, "Dirty", groupMeta.isDirty());
            this.addRow(dbTable, "Created", groupMeta.getCreated().toString());
            this.addRow(dbTable, "Modified", groupMeta.getModified().toString());
            SaasGroup group = (SaasGroup)groupMeta.getSaasProvisionableResource();
            Iterator<SaasGroup> parentGroups = groupMembershipStore.getGroupsForSubGroup(groupMeta.getDirectoryServerGuid());
            boolean firstParentGroup = true;
            while (parentGroups.hasNext()) {
                SaasGroup parentGroup = parentGroups.next();
                String header = "";
                if (firstParentGroup) {
                    header = "Member Of";
                    firstParentGroup = false;
                }
                this.addRow(dbTable, header, parentGroup.getName() + " (" + parentGroup.getInternalGuid() + ")");
            }
            Iterator<SaasIdentity> members = groupMembershipStore.getUserMembers(groupMeta.getDirectoryServerGuid(), null);
            boolean firstMember = true;
            while (members.hasNext()) {
                SaasIdentity member = members.next();
                String header = "";
                if (firstMember) {
                    header = "User Members";
                    firstMember = false;
                }
                this.addRow(dbTable, header, member.getName() + " (" + member.getInternalGuid() + ")");
            }
            Iterator<SaasGroup> subGroups = groupMembershipStore.getSubGroupMembers(groupMeta.getDirectoryServerGuid());
            boolean firstSubGroup = true;
            while (subGroups.hasNext()) {
                SaasGroup subGroup = subGroups.next();
                String header = "";
                if (firstSubGroup) {
                    header = "Sub Group Members";
                    firstSubGroup = false;
                }
                this.addRow(dbTable, header, subGroup.getName() + " (" + subGroup.getInternalGuid() + ")");
            }
            this.printNameValueTable(null, dbTable);
            if (groupMeta.isDirty() && !group.getNames().isEmpty()) {
                this.printMappedFields(group);
            }
        } else {
            this._out.println("Group not found in internal database.");
        }
    }

    private boolean isActiveDirectory(int channelId) throws CliArgumentException {
        ChannelSource source = this.getDomainSource(channelId);
        LdapDataSource ldapDataSource = this.getDomainLdapDataSource(source);
        return "ActiveDirectory".equalsIgnoreCase(ldapDataSource.getLdapType().name());
    }
}

