/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cluster;

import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.NoopProvisionerClusterManager;
import com.pingidentity.provisioner.cluster.ProvisionerClusterManager;
import com.pingidentity.provisioner.cluster.TableProvisionerClusterManager;
import com.pingidentity.provisioner.store.jdbc.ProvisionerNodeStateDataManager;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.saml20.service.util.NodeIndex;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class ProvisionerClusterManagerFactory {
    public static final String PROVISIONER_NODE_ID_PROPERTY = "provisioner.node.id";
    public static final String PROVISIONER_MODE_PROPERTY = "pf.provisioner.mode";
    public static final String PROVISIONER_MODE_OFF = "off";
    public static final String PROVISIONER_MODE_STANDALONE = "standalone";
    public static final String PROVISIONER_MODE_FAILOVER = "failover";
    public static final String PROVISIONER_FAILOVER_GRACE_PERIOD_PROPERTY = "provisioner.failover.grace.period";
    private ProvisionerNodeStateDataManager _dataAccessManager;
    private PlatformTransactionManager _transactionManager;
    private int _syncIntervalSecs;
    private static final Logger _logger = LogManager.getLogger(ProvisionerClusterManagerFactory.class);

    public void setDataAccessManager(ProvisionerNodeStateDataManager dataAccessManager) {
        this._dataAccessManager = dataAccessManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this._transactionManager = transactionManager;
    }

    public void setSyncInterval(int syncIntervalSecs) {
        this._syncIntervalSecs = syncIntervalSecs;
    }

    public ProvisionerClusterManager createFromSystemProperties() throws ClusteringException {
        int nodeId;
        boolean failoverMode = PROVISIONER_MODE_FAILOVER.equalsIgnoreCase(System.getProperty(PROVISIONER_MODE_PROPERTY, "").trim());
        if (!failoverMode) {
            return new NoopProvisionerClusterManager();
        }
        String myNodeIdStr = System.getProperty(PROVISIONER_NODE_ID_PROPERTY);
        if (StringUtils.isNotBlank((String)myNodeIdStr)) {
            nodeId = Integer.parseInt(myNodeIdStr);
            _logger.info("Setting provisioner node id to " + nodeId);
        } else {
            nodeId = NodeIndex.getIndex();
            _logger.info("provisioner.node.id was not specified. Using the cluster node index of " + nodeId + " as the provisioner node id.");
        }
        String gracePeriodStr = System.getProperty(PROVISIONER_FAILOVER_GRACE_PERIOD_PROPERTY);
        if (gracePeriodStr == null) {
            throw new ClusteringException("provisioner.failover.grace.period is not defined");
        }
        int gracePeriodSecs = Integer.parseInt(gracePeriodStr);
        if (gracePeriodSecs < this._syncIntervalSecs) {
            throw new ClusteringException("Fail over grace period smaller than sync interval! " + gracePeriodSecs + " < " + this._syncIntervalSecs);
        }
        TableProvisionerClusterManager clusterManager = new TableProvisionerClusterManager(nodeId, gracePeriodSecs * 1000);
        clusterManager.setDataAccessManager(this._dataAccessManager);
        clusterManager.setTransactionTemplate(new TransactionTemplate(this._transactionManager));
        return clusterManager;
    }
}

