/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.directory;

import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.DirectoryResourceCallback;
import com.pingidentity.provisioner.directory.GuidFormatter;
import com.pingidentity.provisioner.mapping.AttributesMapper;
import com.pingidentity.provisioner.resources.DirectoryResource;
import java.util.HashSet;
import java.util.Set;

public abstract class DirectoryResourceGuidCallback
implements DirectoryResourceCallback {
    private final GuidFormatter guidFormatter;
    private final Set<String> guidAttributeName;

    public abstract void process(String var1, String var2) throws DirectoryException, ClusteringException;

    public DirectoryResourceGuidCallback(GuidFormatter guidFormatter) {
        this.guidFormatter = guidFormatter;
        this.guidAttributeName = new HashSet<String>();
        this.guidAttributeName.add(guidFormatter.getGuidAttributeName());
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.guidAttributeName;
    }

    @Override
    public void process(String dn, DirectoryResource resource) throws DirectoryException, ClusteringException {
        this.process(dn, resource.getGuid());
    }

    @Override
    public AttributesMapper getAttributeMapper() {
        return attrs -> new DirectoryResource(this.guidFormatter.format(attrs));
    }
}

