/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.directory.spring;

import com.pingidentity.provisioner.directory.GuidFormatter;
import com.pingidentity.provisioner.mapping.AttributesMapper;
import com.pingidentity.provisioner.resources.DirectoryResource;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class DirectoryResourceAttributesMapper
implements AttributesMapper {
    private GuidFormatter _guidFormatter;

    public void setGuidFormatter(GuidFormatter guidFormatter) {
        this._guidFormatter = guidFormatter;
    }

    @Override
    public Object mapFromAttributes(Attributes attributes) throws NamingException {
        String guid = this._guidFormatter.format(attributes);
        String guidAttributeName = this._guidFormatter.getGuidAttributeName();
        DirectoryResource directoryResource = this.createResource(guid);
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMore()) {
            Attribute attribute = namingEnumeration.next();
            String name = attribute.getID();
            if (guidAttributeName.equals(name)) {
                directoryResource.putValues(name, guid, new String[0]);
                continue;
            }
            directoryResource.putValues(name, this.collectValues(attribute));
        }
        return directoryResource;
    }

    protected DirectoryResource createResource(String guid) {
        return new DirectoryResource(guid);
    }

    private List<String> collectValues(Attribute attribute) throws NamingException {
        ArrayList<String> values = new ArrayList<String>(attribute.size());
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMore()) {
            values.add((String)namingEnumeration.next());
        }
        return values;
    }
}

