/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.directory.spring;

import com.pingidentity.provisioner.directory.spring.AttributeValueProcessor;
import com.pingidentity.provisioner.directory.spring.RangeOption;
import com.pingidentity.provisioner.mapping.AttributesMapper;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class IncrementalAttributeMapper
implements AttributesMapper {
    private String _attributeName;
    private boolean _more = true;
    private int _pageSize = -1;
    private RangeOption _requestRange = new RangeOption(0, this._pageSize);
    private AttributeValueProcessor _valueProcessor;
    private boolean _omitFullRange = true;

    public IncrementalAttributeMapper(String attributeName, AttributeValueProcessor valueProcessor) {
        this._attributeName = attributeName;
        this._valueProcessor = valueProcessor;
    }

    public IncrementalAttributeMapper(String attributeName, AttributeValueProcessor valueProcessor, int pageSize) {
        this._attributeName = attributeName;
        this._pageSize = pageSize;
        this._requestRange = new RangeOption(0, pageSize);
        this._valueProcessor = valueProcessor;
    }

    public boolean isOmitFullRange() {
        return this._omitFullRange;
    }

    public void setOmitFullRange(boolean omitFullRange) {
        this._omitFullRange = omitFullRange;
    }

    @Override
    public Object mapFromAttributes(Attributes attributes) throws NamingException {
        if (!this._more) {
            throw new IllegalStateException("No more attributes!");
        }
        this._more = false;
        NamingEnumeration<String> attributeNameEnum = attributes.getIDs();
        while (attributeNameEnum.hasMore()) {
            String attributeName = attributeNameEnum.next();
            if (attributeName.equals(this._attributeName)) {
                this.processValues(attributes, this._attributeName);
                continue;
            }
            if (!attributeName.startsWith(this._attributeName + ";")) continue;
            for (String option : attributeName.split(";")) {
                RangeOption responseRange = RangeOption.parse(option);
                if (responseRange == null) continue;
                boolean bl = this._more = this._requestRange.compareTo(responseRange) > 0;
                if (this._more) {
                    this._requestRange = responseRange.nextRange(this._pageSize);
                }
                this.processValues(attributes, attributeName);
            }
        }
        return this;
    }

    private void processValues(Attributes attributes, String attributeName) throws NamingException {
        Attribute attribute = attributes.get(attributeName);
        NamingEnumeration<?> valueEnum = attribute.getAll();
        while (valueEnum.hasMore()) {
            this._valueProcessor.process(valueEnum.next());
        }
    }

    public boolean hasMore() {
        return this._more;
    }

    public String[] getAttributesArray() {
        StringBuilder attributeBuilder = new StringBuilder(this._attributeName);
        if (!this._omitFullRange || !this._requestRange.isFullRange()) {
            attributeBuilder.append(';');
            this._requestRange.toString(attributeBuilder);
        }
        return new String[]{attributeBuilder.toString()};
    }
}

