/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.directory.spring;

import com.google.common.collect.Sets;
import com.pingidentity.common.util.ServiceInformation;
import com.pingidentity.common.util.ldap.LDAPCrudHelper;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.LDAPUtilOptions;
import com.pingidentity.common.util.ldap.SimplePaginationState;
import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.RuntimeClusteringException;
import com.pingidentity.provisioner.directory.DirectoryDriver;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.DirectoryResourceCallback;
import com.pingidentity.provisioner.directory.GuidFormatter;
import com.pingidentity.provisioner.directory.ResourceCallbackCriteria;
import com.pingidentity.provisioner.directory.spring.AttributeValueProcessor;
import com.pingidentity.provisioner.directory.spring.ChangedUsersAlgorithm;
import com.pingidentity.provisioner.directory.spring.DirectoryGroupAttributesMapper;
import com.pingidentity.provisioner.directory.spring.DirectoryIdentityAttributesMapper;
import com.pingidentity.provisioner.directory.spring.DirectoryResourceAttributesMapper;
import com.pingidentity.provisioner.directory.spring.IncrementalAttributeMapper;
import com.pingidentity.provisioner.directory.spring.RuntimeDirectoryException;
import com.pingidentity.provisioner.handler.BaseProvisioningAttributeHandler;
import com.pingidentity.provisioner.handler.ResourceProvisionAttributeHandler;
import com.pingidentity.provisioner.identity.DirectoryIdentity;
import com.pingidentity.provisioner.mapping.AttributesMapper;
import com.pingidentity.provisioner.monitor.ProvisioningEventTimer;
import com.pingidentity.provisioner.resources.DirectoryResource;
import com.pingidentity.provisioner.store.Variable;
import com.pingidentity.provisioner.util.LDAPTimestamp;
import com.pingidentity.provisioner.util.UnboundIdProvisioningUtil;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.FullLDAPInterface;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;

public class SpringLdapDirectoryDriver
implements DirectoryDriver,
ServiceInformation {
    private static final Logger _logger = LogManager.getLogger(SpringLdapDirectoryDriver.class);
    private String _timestampAttributeName;
    private DirectoryIdentityAttributesMapper _directoryIdentityAttributesMapper;
    private String _memberOfGroupAttributeName = "";
    private String _groupMemberAttributeName = "";
    private GuidFormatter _guidFormatter;
    private String _usersBaseDn;
    private ChangedUsersAlgorithm _changedUsersAlgorithm;
    private DirectoryGroupAttributesMapper _directoryGroupAttributesMapper;
    private String _userObjectClass;
    private String _groupObjectClass;
    private String _nestedMemberOfGroupAttributeName = "";
    private String datasourceId;
    private static final ConfigStore configStore = ConfigStoreFarm.getConfig(LDAPUtil.class);
    private static final int maxResultSetSize = configStore.getIntValue("ResultSetSize", 1000);
    private static final boolean includeServerSort = configStore.getBooleanValue("ProvisionWithServerSort", true);

    public SpringLdapDirectoryDriver(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public LdapDataSource getDataSource() {
        return MgmtFactory.getDataSourceManager().getLdapDataSource(this.datasourceId);
    }

    public void setTimestampAttributeName(String timestampAttributeName) {
        this._timestampAttributeName = timestampAttributeName;
    }

    public void setDirectoryIdentityAttributesMapper(DirectoryIdentityAttributesMapper directoryIdentityAttributesMapper) {
        this._directoryIdentityAttributesMapper = directoryIdentityAttributesMapper;
    }

    public void setMemberOfGroupAttributeName(String memberOfGroupAttributeName) {
        this._memberOfGroupAttributeName = memberOfGroupAttributeName == null ? "" : memberOfGroupAttributeName.trim();
    }

    public void setGroupMemberAttributeName(String groupMemberAttributeName) {
        this._groupMemberAttributeName = groupMemberAttributeName == null ? "" : groupMemberAttributeName.trim();
    }

    public void setGuidFormatter(GuidFormatter guidFormatter) {
        this._guidFormatter = guidFormatter;
    }

    public void setUsersBaseDn(String usersBaseDn) {
        this._usersBaseDn = usersBaseDn;
    }

    public void setChangedUsersAlgorithm(ChangedUsersAlgorithm changedUsersAlgorithm) {
        this._changedUsersAlgorithm = changedUsersAlgorithm;
    }

    public String getServiceName() {
        return "directory-driver";
    }

    @Override
    public Date getGroupModifyTime(String group, boolean nestedSearch) throws DirectoryException {
        _logger.info("Getting group modify time for: " + group + "; using attribute: " + this._timestampAttributeName + "; nested search: " + nestedSearch);
        ArrayList<Date> timeStamps = new ArrayList<Date>();
        AttributesMapper mapper = new AttributesMapper(){

            @Override
            public Object mapFromAttributes(Attributes attributes) throws NamingException, DirectoryException {
                Attribute attribute = attributes.get(SpringLdapDirectoryDriver.this._timestampAttributeName);
                if (attribute == null) {
                    throw new DirectoryException("Unable to find the '" + SpringLdapDirectoryDriver.this._timestampAttributeName + "' attribute. Ensure that the provided case-sensitive attribute name exists.");
                }
                return LDAPTimestamp.toDate((String)attribute.get());
            }
        };
        Date groupTimeStamp = null;
        try {
            AttributeMap groupTimeStampAttributeMap = this.getAttributeMap(group, Sets.newHashSet((Object[])new String[]{this._timestampAttributeName}), 0);
            if (groupTimeStampAttributeMap == null) {
                throw new DirectoryException("Unable to find the Group DN '" + group + "'. Please ensure that it exists.");
            }
            Attributes groupTimeStampAttribute = UnboundIdProvisioningUtil.loadAttrs(groupTimeStampAttributeMap);
            groupTimeStamp = (Date)mapper.mapFromAttributes(groupTimeStampAttribute);
            if (nestedSearch) {
                Filter groupFilter = Filter.createEqualityFilter((String)"objectClass", (String)this.getGroupObjectClass());
                Filter nestedMemberOf = Filter.createEqualityFilter((String)this._nestedMemberOfGroupAttributeName, (String)group);
                Filter nestedFilter = Filter.createANDFilter((Filter[])new Filter[]{groupFilter, nestedMemberOf});
                LDAPUtilOptions ldapOptionsSubTreeScope = new LDAPUtilOptions(this._usersBaseDn, nestedFilter.toString(), 2);
                String[] attrNames = new String[]{this._timestampAttributeName};
                ldapOptionsSubTreeScope.setAttributes(attrNames);
                List timeStampMaps = this.getLdapUtil().getAttributesOfMatchingObjects(ldapOptionsSubTreeScope);
                for (AttributeMap attributeMap : timeStampMaps) {
                    Attributes timeAttributes = UnboundIdProvisioningUtil.loadAttrs(attributeMap);
                    Date subGroupTimeStamp = (Date)mapper.mapFromAttributes(timeAttributes);
                    timeStamps.add(subGroupTimeStamp);
                }
                if (groupTimeStamp != null) {
                    timeStamps.add(groupTimeStamp);
                }
                if (!timeStamps.isEmpty()) {
                    timeStamps.sort(Collections.reverseOrder());
                    return (Date)timeStamps.get(0);
                }
                return null;
            }
        }
        catch (NamingException e) {
            throw new DirectoryException(e);
        }
        return groupTimeStamp;
    }

    @Override
    public void processResourcesInGroup(String groupDn, DirectoryResourceCallback callback) throws DirectoryException {
        this.processResourcesInGroup(groupDn, null, callback);
    }

    @Override
    public void processResourcesInGroup(String groupDn, ResourceCallbackCriteria callbackCriteria, DirectoryResourceCallback callback) throws DirectoryException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Processing resources in group by group entry: " + groupDn + " and criteria: " + callbackCriteria);
        }
        if (this._memberOfGroupAttributeName.length() > 0) {
            this.processResourcesInGroupByUserAttribute(groupDn, callbackCriteria, callback);
        } else if (this._groupMemberAttributeName.length() > 0) {
            this.processResourcesInGroupByGroupEntry(groupDn, callbackCriteria, callback);
        } else {
            throw new DirectoryException("Cannot process users in group. memberOfGroup or groupMember attribute names are not provided.");
        }
    }

    private void processResourcesInGroupByUserAttribute(String groupDn, ResourceCallbackCriteria callbackCriteria, DirectoryResourceCallback callback) throws DirectoryException {
        Filter filter = Filter.createEqualityFilter((String)this._memberOfGroupAttributeName, (String)groupDn);
        if (callbackCriteria != null) {
            String secondGroupDn = callbackCriteria.getGroupCriterion();
            String objectClass = callbackCriteria.getObjectClassCriterion();
            Filter additionalFilter = callbackCriteria.getFilterCriterion();
            if (secondGroupDn != null) {
                filter = Filter.createANDFilter((Filter[])new Filter[]{filter, Filter.createEqualityFilter((String)this._memberOfGroupAttributeName, (String)secondGroupDn)});
            }
            if (objectClass != null) {
                filter = Filter.createANDFilter((Filter[])new Filter[]{filter, Filter.createEqualityFilter((String)"objectClass", (String)objectClass)});
            }
            if (additionalFilter != null) {
                filter = Filter.createANDFilter((Filter[])new Filter[]{filter, additionalFilter});
            }
        }
        this.pagedResourceSearch(filter, new ResourceProvisionAttributeHandler(callback, this._guidFormatter));
    }

    private void processResourcesInGroupByGroupEntry(final String groupDn, final ResourceCallbackCriteria callbackCriteria, final DirectoryResourceCallback callback) throws DirectoryException {
        AttributeValueProcessor processor = new AttributeValueProcessor(){

            @Override
            public void process(Object value) {
                boolean isDN = true;
                try {
                    new LdapName((String)value);
                }
                catch (InvalidNameException e) {
                    isDN = false;
                }
                String dn = null;
                Filter objectUidFilter = null;
                if (isDN) {
                    dn = (String)value;
                } else if (value != null && StringUtils.isNotEmpty((String)SpringLdapDirectoryDriver.this._guidFormatter.getGuidAttributeName())) {
                    String guidAttributeName = SpringLdapDirectoryDriver.this._guidFormatter.getGuidAttributeName();
                    objectUidFilter = SpringLdapDirectoryDriver.this._guidFormatter.isGuidIsBinary() ? Filter.createEqualityFilter((String)guidAttributeName, (byte[])((byte[])value)) : Filter.createEqualityFilter((String)guidAttributeName, (String)((String)value));
                }
                try {
                    if (callbackCriteria != null) {
                        String secondGroupDn = callbackCriteria.getGroupCriterion();
                        String objectClass = callbackCriteria.getObjectClassCriterion();
                        Filter additionalFilter = callbackCriteria.getFilterCriterion();
                        boolean matchesCriteria = true;
                        if (secondGroupDn != null && !groupDn.equals(secondGroupDn)) {
                            Filter memberFilter = Filter.createEqualityFilter((String)SpringLdapDirectoryDriver.this._groupMemberAttributeName, (String)dn);
                            matchesCriteria = SpringLdapDirectoryDriver.this.resourceMatchesFilter(secondGroupDn, memberFilter);
                        }
                        if (matchesCriteria && (objectClass != null || additionalFilter != null || objectUidFilter != null)) {
                            Filter filter = objectUidFilter;
                            if (objectClass != null) {
                                Filter objectClassFilter = Filter.createEqualityFilter((String)"objectClass", (String)objectClass);
                                filter = this.addAndFilter(filter, objectClassFilter);
                            }
                            filter = this.addAndFilter(filter, additionalFilter);
                            if (isDN) {
                                matchesCriteria = SpringLdapDirectoryDriver.this.resourceMatchesFilter(dn, filter);
                            } else if (objectUidFilter != null && (dn = SpringLdapDirectoryDriver.this.getDNForFilter(SpringLdapDirectoryDriver.this._usersBaseDn, SearchScope.SUB, filter, "Subject DN")) == null) {
                                throw new DirectoryException("No entries detected for filter: " + filter.toString());
                            }
                        }
                        if (matchesCriteria) {
                            this.doCallback(dn, callback);
                        }
                    } else {
                        this.doCallback(dn, callback);
                    }
                }
                catch (DirectoryException e) {
                    throw new RuntimeDirectoryException(e);
                }
                catch (ClusteringException e) {
                    throw new RuntimeClusteringException(e);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Cannot load resource entry from DN: " + dn, e);
                }
            }

            private Filter addAndFilter(Filter existingFilter, Filter newFilter) {
                Filter addedFilter = existingFilter;
                if (addedFilter == null) {
                    addedFilter = newFilter;
                } else if (newFilter != null) {
                    addedFilter = Filter.createANDFilter((Filter[])new Filter[]{existingFilter, newFilter});
                }
                return addedFilter;
            }

            private void doCallback(String dn, DirectoryResourceCallback callback2) throws ClusteringException, DirectoryException {
                AttributesMapper attributesMapper = callback2.getAttributeMapper();
                Set<String> attributeNames = callback2.getAttributeNames();
                if (attributesMapper == null) {
                    DirectoryResourceAttributesMapper resourceMapper = new DirectoryResourceAttributesMapper();
                    resourceMapper.setGuidFormatter(SpringLdapDirectoryDriver.this._guidFormatter);
                    attributesMapper = resourceMapper;
                }
                try {
                    Attributes attributes = SpringLdapDirectoryDriver.this.getAttributes(dn, attributeNames, 0);
                    DirectoryResource resource = (DirectoryResource)attributesMapper.mapFromAttributes(attributes);
                    callback2.process(dn, resource);
                }
                catch (NamingException e) {
                    throw new DirectoryException("Invalid user DN: " + dn);
                }
            }
        };
        try {
            IncrementalAttributeMapper incrementalAttributeMapper = new IncrementalAttributeMapper(this._groupMemberAttributeName, processor);
            while (incrementalAttributeMapper.hasMore()) {
                LDAPUtilOptions ldapOptions = new LDAPUtilOptions(groupDn, null, 0);
                ldapOptions.setAttributes(incrementalAttributeMapper.getAttributesArray());
                AttributeMap attribute = this.getLdapUtil().getAttributesOfMatchingObject(ldapOptions);
                Attributes attributes = UnboundIdProvisioningUtil.loadAttrs(attribute);
                incrementalAttributeMapper.mapFromAttributes(attributes);
            }
        }
        catch (RuntimeClusteringException | RuntimeDirectoryException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DirectoryException("Cannot process group: " + groupDn, e);
        }
    }

    @Override
    public void processResourcesByFilter(Filter filter, DirectoryResourceCallback callback) throws DirectoryException {
        this.processResourcesByFilter(filter, null, callback);
    }

    @Override
    public void processResourcesByFilter(Filter filter, ResourceCallbackCriteria criteria, DirectoryResourceCallback callback) throws DirectoryException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Processing resources by filter by resource attribute: " + filter + " and criteria: " + criteria);
        }
        Filter andFilter = filter;
        if (criteria != null) {
            String groupDn = criteria.getGroupCriterion();
            String objectClass = criteria.getObjectClassCriterion();
            Filter criteriaFilter = criteria.getFilterCriterion();
            if (criteriaFilter != null) {
                andFilter = Filter.createANDFilter((Filter[])new Filter[]{andFilter, criteriaFilter});
            }
            if (groupDn != null) {
                ResourceCallbackCriteria otherCriteria = new ResourceCallbackCriteria();
                otherCriteria.setFilterCriterion(andFilter);
                otherCriteria.setObjectClassCriterion(objectClass);
                this.processResourcesInGroup(groupDn, otherCriteria, callback);
            } else {
                if (objectClass != null) {
                    andFilter = Filter.createANDFilter((Filter[])new Filter[]{andFilter, Filter.createEqualityFilter((String)"objectClass", (String)objectClass)});
                }
                this.pagedResourceSearch(andFilter, new ResourceProvisionAttributeHandler(callback, this._guidFormatter));
            }
        } else {
            this.pagedResourceSearch(filter, new ResourceProvisionAttributeHandler(callback, this._guidFormatter));
        }
    }

    @Override
    public DirectoryIdentity loadUserByDn(Set<String> attributeNames, String dn) throws DirectoryException {
        try {
            if (!dn.toLowerCase().endsWith(this._usersBaseDn.toLowerCase())) {
                throw new DirectoryException("Unable to find user with DN '" + dn + "'  under base DN: '" + this._usersBaseDn + "'");
            }
            Attributes attributes = this.getAttributes(dn, attributeNames, 0);
            return (DirectoryIdentity)this._directoryIdentityAttributesMapper.mapFromAttributes(attributes);
        }
        catch (NamingException e) {
            throw new DirectoryException("Invalid user DN: " + dn);
        }
    }

    private Attributes getAttributes(String dn, Set<String> attributeNames, int searchControl) throws NamingException {
        AttributeMap attributesOfMatchingObject = this.getAttributeMap(dn, attributeNames, searchControl);
        return UnboundIdProvisioningUtil.loadAttrs(attributesOfMatchingObject);
    }

    private AttributeMap getAttributeMap(String dn, Set<String> attributeNames, int searchControl) throws NamingException {
        LDAPUtilOptions ldapOptions = new LDAPUtilOptions(dn, null, searchControl);
        if (attributeNames != null) {
            String[] attrNames = attributeNames.toArray(new String[0]);
            ldapOptions.setAttributes(attrNames);
        }
        return this.getLdapUtil().getAttributesOfMatchingObject(ldapOptions);
    }

    @Override
    public DirectoryIdentity loadUserByGuid(Set<String> attributeNames, String guid) throws DirectoryException {
        Filter guidFilter = Filter.createEqualityFilter((String)this._guidFormatter.getGuidAttributeName(), (String)this._guidFormatter.escape(guid));
        try {
            LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this._usersBaseDn, guidFilter.toString(), 2);
            ldapOptions.setAttributes(attributeNames.toArray(new String[attributeNames.size()]));
            List attributesOfMatchingObject = this.getLdapUtil().getAttributesOfMatchingObjects(ldapOptions);
            if (attributesOfMatchingObject == null || attributesOfMatchingObject.size() == 0) {
                return null;
            }
            if (attributesOfMatchingObject.size() > 1) {
                throw new DirectoryException("Multiple users with GUID: " + guid);
            }
            Attributes attributes = UnboundIdProvisioningUtil.loadAttrs((AttributeMap)attributesOfMatchingObject.get(0));
            DirectoryIdentity identity = (DirectoryIdentity)this._directoryIdentityAttributesMapper.mapFromAttributes(attributes);
            return identity;
        }
        catch (NamingException e) {
            throw new DirectoryException("Unable to load user from base DN '" + this._usersBaseDn + "' by guid.");
        }
    }

    @Override
    public Filter getChangedResourceFilter(Variable checkpoint) {
        return this._changedUsersAlgorithm.getChangedResourceFilter(checkpoint);
    }

    @Override
    public boolean hasGroupMembershipChanged(Variable checkpoint) throws DirectoryException {
        try {
            return this._changedUsersAlgorithm.hasGroupMembershipChanged(checkpoint);
        }
        catch (LDAPException e) {
            throw new DirectoryException(e);
        }
    }

    private List<String> getBinaryAttributes() {
        ArrayList<String> binaryAttributes = new ArrayList<String>();
        if (this._guidFormatter != null && this._guidFormatter.isGuidIsBinary()) {
            binaryAttributes.add(this._guidFormatter.getGuidAttributeName());
        }
        return binaryAttributes;
    }

    private void pagedResourceSearch(Filter filter, ResourceProvisionAttributeHandler attributeHandler) throws DirectoryException {
        LDAPUtilOptions ldapOptions = new LDAPUtilOptions(this._usersBaseDn, filter.toString(), 2);
        this.pagedSearchInternal(ldapOptions, attributeHandler);
    }

    public void pagedSearch(String baseDn, Filter filter, SearchControls controls, BaseProvisioningAttributeHandler callbackHandler) throws DirectoryException {
        LDAPUtilOptions ldapOptions = new LDAPUtilOptions(baseDn, filter.toString(), controls.getSearchScope());
        this.pagedSearchInternal(ldapOptions, callbackHandler);
    }

    private void pagedSearchInternal(LDAPUtilOptions ldapOptions, BaseProvisioningAttributeHandler callbackHandler) throws DirectoryException {
        ldapOptions.setRetrieveLastElement(false);
        ldapOptions.setResultsPerPage(maxResultSetSize);
        ldapOptions.setEnableServerSort(includeServerSort);
        SimplePaginationState simplePaginationState = new SimplePaginationState();
        ldapOptions.setPaginationState(simplePaginationState);
        ldapOptions.setAttributes(callbackHandler.getAttributeNames().toArray(new String[0]));
        ldapOptions.addAttributes(new String[]{"modifyTimestamp", "createTimestamp"});
        LDAPUtil ldapUtil = null;
        try {
            ldapUtil = this.getLdapUtil();
            do {
                List attributeMapList;
                try (ProvisioningEventTimer ignored = ProvisioningEventTimer.getLDAPPagedSearchEventTimer(ldapOptions);){
                    attributeMapList = ldapUtil.getAttributesOfMatchingObjects(ldapOptions, this.getBinaryAttributes());
                }
                if (attributeMapList.isEmpty()) continue;
                callbackHandler.handle(attributeMapList);
            } while (simplePaginationState.getResumeCookie() != null);
        }
        catch (NamingException e) {
            throw new DirectoryException(e.getMessage());
        }
        finally {
            SimplePaginationState state = ldapOptions.getPaginationState();
            if (ldapUtil != null && state != null && state.getConnection() != null) {
                FullLDAPInterface conn = state.getConnection();
                ldapUtil.releaseConnectionToPool(conn);
            }
            ldapOptions.setPaginationState(null);
            ldapOptions.setEnableServerSort(true);
        }
    }

    private boolean resourceMatchesFilter(String dn, Filter filter) throws NamingException {
        LDAPCrudHelper.SearchCriteria sc = new LDAPCrudHelper.SearchCriteria(dn, SearchScope.BASE, filter, new String[]{"1.1"});
        List<SearchResultEntry> searchResult = this.searchResultEntries(sc);
        return searchResult != null && searchResult.size() == 1;
    }

    private String getDNForFilter(String searchDN, SearchScope searchScope, Filter filter, String ... attributes) throws NamingException {
        String dn = null;
        LDAPCrudHelper.SearchCriteria sc = new LDAPCrudHelper.SearchCriteria(searchDN, searchScope, filter, attributes);
        List<SearchResultEntry> searchResultEntries = this.searchResultEntries(sc);
        if (searchResultEntries != null && !searchResultEntries.isEmpty()) {
            dn = searchResultEntries.get(0).getDN();
        }
        return dn;
    }

    private List<SearchResultEntry> searchResultEntries(LDAPCrudHelper.SearchCriteria sc) throws NamingException {
        LDAPCrudHelper lch = new LDAPCrudHelper(this.getLdapUtil());
        return lch.search(sc);
    }

    @Override
    public GuidFormatter getGuidFormatter() {
        return this._guidFormatter;
    }

    @Override
    public DirectoryIdentityAttributesMapper getDirectoryIdentityAttributesMapper() {
        return this._directoryIdentityAttributesMapper;
    }

    @Override
    public DirectoryGroupAttributesMapper getDirectoryGroupAttributesMapper() {
        return this._directoryGroupAttributesMapper;
    }

    public void setDirectoryGroupAttributesMapper(DirectoryGroupAttributesMapper groupMapper) {
        this._directoryGroupAttributesMapper = groupMapper;
    }

    @Override
    public String getChangedResourceAttribute() {
        return this._changedUsersAlgorithm.getChangeResourceAttribute();
    }

    @Override
    public void processChangedResource(DirectoryResource resource) {
        this._changedUsersAlgorithm.processResource(resource);
    }

    @Override
    public boolean verifyChangedResource(DirectoryResource resource) {
        return this._changedUsersAlgorithm.verifyResource(resource);
    }

    @Override
    public void saveChangedResourceCheckpoint(Variable checkpoint) {
        this._changedUsersAlgorithm.saveCheckpoint(checkpoint);
    }

    @Override
    public String getUserObjectClass() {
        return this._userObjectClass;
    }

    public void setUserObjectClass(String objectClass) {
        this._userObjectClass = objectClass;
    }

    @Override
    public String getGroupObjectClass() {
        return this._groupObjectClass;
    }

    public void setGroupObjectClass(String objectClass) {
        this._groupObjectClass = objectClass;
    }

    @Override
    public String getNestedMemberOfGroupAttributeName() {
        return this._nestedMemberOfGroupAttributeName;
    }

    public void setNestedMemberOfGroupAttributeName(String nestedMemberOfGroupAttributeName) {
        this._nestedMemberOfGroupAttributeName = nestedMemberOfGroupAttributeName;
    }

    public String getMemberOfGroupAttributeName() {
        return this._memberOfGroupAttributeName;
    }

    public LDAPUtil getLdapUtil() throws NamingException {
        LdapDataSource dataSource = this.getDataSource();
        return LDAPUtil.newInstance((DataSource)dataSource, (ServiceInformation)this);
    }
}

