/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.directory.spring;

import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.GuidFormatter;
import com.pingidentity.provisioner.directory.spring.RuntimeDirectoryException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.common.Util;

public class SpringLdapGuidFormatter
implements GuidFormatter {
    private String _guidAttributeName;
    private boolean _guidIsBinary;
    private Logger log = LogManager.getLogger(this.getClass());

    public void setGuidAttributeName(String guidAttributeName) {
        this._guidAttributeName = guidAttributeName;
    }

    public void setGuidIsBinary(boolean guidIsBinary) {
        this._guidIsBinary = guidIsBinary;
    }

    @Override
    public String format(Attribute guidAttribute) {
        if (guidAttribute == null) {
            this.log.error("guidAttribute is null. Please check your configuration.");
            throw new RuntimeDirectoryException("guidAttribute is null");
        }
        try {
            String guid = (String)guidAttribute.get();
            if (this._guidIsBinary) {
                byte[] guidDecoded = Base64.decodeBase64((byte[])guid.getBytes(Util.UTF8CS));
                if (guidDecoded.length == 0) {
                    this.log.error("Decoded binary guidAttribute is empty. Please check that the source datastore is configured with '" + this._guidAttributeName + "' as a binary attribute.");
                    throw new RuntimeDirectoryException("Decoded guidAttribute is empty.");
                }
                return this.hexEncode(guidDecoded);
            }
            return guid;
        }
        catch (NamingException e) {
            throw new RuntimeDirectoryException(e);
        }
    }

    @Override
    public String format(Attributes attributes) {
        return this.format(attributes.get(this._guidAttributeName));
    }

    @Override
    public String escape(String guid) throws DirectoryException {
        if (this._guidIsBinary) {
            if (guid.length() % 2 == 0) {
                StringBuilder escapedGuid = new StringBuilder();
                for (int i = 0; i < guid.length(); i += 2) {
                    escapedGuid.append('\\');
                    escapedGuid.append(guid.charAt(i));
                    escapedGuid.append(guid.charAt(i + 1));
                }
                return escapedGuid.toString();
            }
            throw new DirectoryException("Invalid DS GUID, expected even number of characters: " + guid);
        }
        return guid;
    }

    @Override
    public String getGuidAttributeName() {
        return this._guidAttributeName;
    }

    @Override
    public boolean isGuidIsBinary() {
        return this._guidIsBinary;
    }

    private String hexEncode(byte[] guidBytes) {
        StringBuilder guidHex = new StringBuilder(guidBytes.length * 2);
        for (byte guidByte : guidBytes) {
            int code = guidByte & 0xFF;
            if (code <= 15) {
                guidHex.append('0');
            }
            guidHex.append(Integer.toHexString(code));
        }
        return guidHex.toString();
    }

    public static String hexToAdString(String hex) {
        if (hex.length() != 32) {
            throw new IllegalArgumentException("Invalid length length of hex format, expected 32, " + hex);
        }
        StringBuilder dash = new StringBuilder(36);
        dash.append(hex.substring(6, 8));
        dash.append(hex.substring(4, 6));
        dash.append(hex.substring(2, 4));
        dash.append(hex.substring(0, 2));
        dash.append('-');
        dash.append(hex.substring(10, 12));
        dash.append(hex.substring(8, 10));
        dash.append('-');
        dash.append(hex.substring(14, 16));
        dash.append(hex.substring(12, 14));
        dash.append('-');
        dash.append(hex.substring(16, 20));
        dash.append('-');
        dash.append(hex.substring(20));
        return dash.toString().toUpperCase();
    }
}

