/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.directory.spring;

import com.pingidentity.common.util.ldap.LDAPUtilOptions;
import com.pingidentity.provisioner.directory.DirectoryDriver;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.spring.BaseChangedUsersAlgorithm;
import com.pingidentity.provisioner.directory.spring.SpringLdapDirectoryDriver;
import com.pingidentity.provisioner.directory.spring.TimestampChangedGroupsCallbackHandler;
import com.pingidentity.provisioner.resources.DirectoryResource;
import com.pingidentity.provisioner.store.Variable;
import com.pingidentity.provisioner.util.LDAPTimestamp;
import com.pingidentity.provisioner.util.UnboundIdProvisioningUtil;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.naming.directory.Attributes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.util.log.AttributeMap;

public class TimestampChangedUsersAlgorithm
extends BaseChangedUsersAlgorithm {
    private static Logger _logger = LogManager.getLogger(TimestampChangedUsersAlgorithm.class);
    private String _timestampAttributeName;
    private boolean _noNot = false;
    private Boolean isInGMT = null;
    private Date _maxTimestamp = new Date(0L);
    private Date _lastTimestamp;
    private SpringLdapDirectoryDriver driver;

    public TimestampChangedUsersAlgorithm(SpringLdapDirectoryDriver driver) {
        this.driver = driver;
    }

    public void setTimestampAttributeName(String timestampAttributeName) {
        this._timestampAttributeName = timestampAttributeName;
    }

    public void setNoNot(boolean noNot) {
        this._noNot = noNot;
    }

    @Override
    public String getChangeResourceAttribute() {
        return this._timestampAttributeName;
    }

    @Override
    public Filter getChangedResourceFilter(Variable checkpoint) {
        this._lastTimestamp = new Date(0L);
        boolean timestampFormatInGMT = this.isTimestampFormatInGMT();
        if (checkpoint.hasValue()) {
            this._lastTimestamp = checkpoint.getDateValue();
        }
        Filter timestampFilter = this._noNot ? Filter.createGreaterOrEqualFilter((String)this._timestampAttributeName, (String)LDAPTimestamp.toString(this._lastTimestamp, timestampFormatInGMT)) : Filter.createNOTFilter((Filter)Filter.createLessOrEqualFilter((String)this._timestampAttributeName, (String)LDAPTimestamp.toString(this._lastTimestamp, timestampFormatInGMT)));
        return timestampFilter;
    }

    @Override
    public boolean hasGroupMembershipChanged(Variable checkpoint) throws DirectoryException, LDAPException {
        if (checkpoint.hasValue()) {
            Date lastTimestamp = checkpoint.getDateValue();
            if (this.isCheckForChangedGroupMembership()) {
                boolean timestampFormatInGMT = this.isTimestampFormatInGMT();
                Filter timestampFilter = this._noNot ? Filter.createGreaterOrEqualFilter((String)this._timestampAttributeName, (String)LDAPTimestamp.toString(lastTimestamp, timestampFormatInGMT)) : Filter.createNOTFilter((Filter)Filter.createLessOrEqualFilter((String)this._timestampAttributeName, (String)LDAPTimestamp.toString(lastTimestamp, timestampFormatInGMT)));
                TimestampChangedGroupsCallbackHandler timestampChangedGroupsCallbackHandler = new TimestampChangedGroupsCallbackHandler(this._timestampAttributeName, lastTimestamp);
                this.runChangedGroupsSearch(timestampChangedGroupsCallbackHandler, timestampFilter, this.driver);
                if (timestampChangedGroupsCallbackHandler.isGroupMembershipChanged()) {
                    Date maxGroupTimestamp = timestampChangedGroupsCallbackHandler.getMaxTimestamp();
                    Date now = Calendar.getInstance().getTime();
                    if (maxGroupTimestamp.after(this._maxTimestamp) && now.after(maxGroupTimestamp)) {
                        this._maxTimestamp = maxGroupTimestamp;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean verifyResource(DirectoryResource resource) {
        Date timestamp;
        String tsStr = resource.getValue(this._timestampAttributeName);
        return tsStr == null || (timestamp = LDAPTimestamp.toDate(tsStr)) == null || !timestamp.equals(this._lastTimestamp);
    }

    @Override
    public void processResource(DirectoryResource resource) {
        String tsStr = resource.getValue(this._timestampAttributeName);
        if (tsStr != null) {
            Date timestamp = LDAPTimestamp.toDate(tsStr);
            Date now = Calendar.getInstance().getTime();
            if (timestamp != null && timestamp.after(this._maxTimestamp) && now.after(timestamp)) {
                this._maxTimestamp = timestamp;
            }
        }
    }

    @Override
    public void saveCheckpoint(Variable checkpoint) {
        Date lastTimestamp = null;
        if (checkpoint.hasValue()) {
            lastTimestamp = checkpoint.getDateValue();
        }
        Date now = Calendar.getInstance().getTime();
        if (lastTimestamp == null || this._maxTimestamp.after(lastTimestamp) && now.after(this._maxTimestamp)) {
            checkpoint.setDateValue(this._maxTimestamp);
        }
        this._maxTimestamp = new Date(0L);
    }

    private void runChangedGroupsSearch(TimestampChangedGroupsCallbackHandler timestampChangedGroupsCallbackHandler, Filter timestampFilter, DirectoryDriver directoryDriver) throws DirectoryException, LDAPException {
        String baseDN;
        Filter filter;
        Filter baseFilter = this.buildBaseGroupFilter();
        if (baseFilter == null) {
            filter = timestampFilter;
            baseDN = this._provisioningGroupDnForGroups;
        } else {
            filter = Filter.createANDFilter((Filter[])new Filter[]{baseFilter, timestampFilter});
            baseDN = this._usersBaseDn;
        }
        this.driver.pagedSearch(baseDN.toString(), filter, this.getSearchControls(new HashSet<String>(), this._timestampAttributeName), timestampChangedGroupsCallbackHandler);
    }

    private boolean isTimestampFormatInGMT() {
        if (this.isInGMT == null) {
            String ldapTimestamp = null;
            try {
                AttributeMap timeStamp;
                Attributes timeStampAtts;
                LDAPUtilOptions ldapOptionsSubTreeScope = new LDAPUtilOptions(this._usersBaseDn, null, 0);
                String[] attrNames = new String[]{this._timestampAttributeName};
                ldapOptionsSubTreeScope.setAttributes(attrNames);
                List timeStampMaps = this.driver.getLdapUtil().getAttributesOfMatchingObjects(ldapOptionsSubTreeScope);
                if (timeStampMaps != null && timeStampMaps.size() > 0 && (timeStampAtts = UnboundIdProvisioningUtil.loadAttrs(timeStamp = (AttributeMap)timeStampMaps.get(0))).get(this._timestampAttributeName) != null) {
                    ldapTimestamp = timeStampAtts.get(this._timestampAttributeName).get().toString();
                }
            }
            catch (Exception e) {
                _logger.error(this.getDefaultGMTError(), (Throwable)e);
                _logger.debug((Object)e.getStackTrace());
                this.isInGMT = Boolean.TRUE;
            }
            if (ldapTimestamp == null) {
                _logger.error(this.getDefaultGMTError());
                this.isInGMT = Boolean.TRUE;
            } else {
                this.isInGMT = ldapTimestamp.trim().endsWith("Z");
            }
        }
        return this.isInGMT;
    }

    private String getDefaultGMTError() {
        return "Cannot get timestamp (" + this._timestampAttributeName + ") for DN: " + this._usersBaseDn + ". Defaulting LDAP timestamp format to GMT.";
    }
}

