/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.directory.spring;

import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.spring.BaseChangedUsersAlgorithm;
import com.pingidentity.provisioner.directory.spring.SpringLdapDirectoryDriver;
import com.pingidentity.provisioner.directory.spring.UsnChangedGroupsCallbackHandler;
import com.pingidentity.provisioner.resources.DirectoryResource;
import com.pingidentity.provisioner.store.Variable;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.HashSet;

public class UsnChangedUsersAlgorithm
extends BaseChangedUsersAlgorithm {
    private String _usnAttributeName;
    private long _maxUsn = 0L;
    private SpringLdapDirectoryDriver driver;

    public UsnChangedUsersAlgorithm(SpringLdapDirectoryDriver driver) {
        this.driver = driver;
    }

    public void setUsnAttributeName(String usnAttributeName) {
        this._usnAttributeName = usnAttributeName;
    }

    @Override
    public String getChangeResourceAttribute() {
        return this._usnAttributeName;
    }

    @Override
    public Filter getChangedResourceFilter(Variable checkpoint) {
        long lastUsn = 0L;
        if (checkpoint.hasValue()) {
            lastUsn = checkpoint.getLongValue();
        }
        return Filter.createGreaterOrEqualFilter((String)this._usnAttributeName, (String)Long.toString(lastUsn));
    }

    @Override
    public boolean hasGroupMembershipChanged(Variable checkpoint) throws DirectoryException, LDAPException {
        long lastUsn = 0L;
        if (checkpoint.hasValue()) {
            lastUsn = checkpoint.getLongValue();
        }
        if (this.isCheckForChangedGroupMembership()) {
            Filter usnFilter = Filter.createGreaterOrEqualFilter((String)this._usnAttributeName, (String)Long.toString(lastUsn));
            UsnChangedGroupsCallbackHandler usnChangedGroupsCallbackHandler = new UsnChangedGroupsCallbackHandler(this._usnAttributeName);
            this.runChangedGroupsSearch(usnChangedGroupsCallbackHandler, usnFilter);
            if (usnChangedGroupsCallbackHandler.isGroupMembershipChanged()) {
                long maxGroupUsn = usnChangedGroupsCallbackHandler.getMaxUsn();
                if (maxGroupUsn > this._maxUsn) {
                    this._maxUsn = maxGroupUsn;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean verifyResource(DirectoryResource resource) {
        return true;
    }

    @Override
    public void processResource(DirectoryResource resource) {
        long usn;
        String usnStr = resource.getValue(this._usnAttributeName);
        if (usnStr != null && (usn = Long.parseLong(usnStr)) > this._maxUsn) {
            this._maxUsn = usn;
        }
    }

    @Override
    public void saveCheckpoint(Variable checkpoint) {
        long lastUsn = 0L;
        ++this._maxUsn;
        if (checkpoint.hasValue()) {
            lastUsn = checkpoint.getLongValue();
        }
        if (this._maxUsn > lastUsn) {
            checkpoint.setLongValue(this._maxUsn);
        }
        this._maxUsn = 0L;
    }

    private void runChangedGroupsSearch(UsnChangedGroupsCallbackHandler usnChangedGroupsCallbackHandler, Filter usnFilter) throws DirectoryException, LDAPException {
        String baseDN;
        Filter filter;
        Filter baseFilter = this.buildBaseGroupFilter();
        if (baseFilter == null) {
            filter = usnFilter;
            baseDN = this._provisioningGroupDnForGroups;
        } else {
            filter = Filter.createANDFilter((Filter[])new Filter[]{baseFilter, usnFilter});
            baseDN = this._usersBaseDn;
        }
        this.driver.pagedSearch(baseDN.toString(), filter, this.getSearchControls(new HashSet<String>(), this._usnAttributeName), usnChangedGroupsCallbackHandler);
    }
}

