/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.domain;

import com.pingidentity.provisioner.domain.IdentityMappingField;
import com.pingidentity.provisioner.domain.mgmt.FieldInfoManager;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.mapping.FieldConfig;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IdentityMapping {
    private static Logger log = LogManager.getLogger(IdentityMapping.class);

    public static List<IdentityMappingField> getDefaultIdentityMapping(String ldapType, SaasTarget saasTarget) throws SaasException {
        ArrayList<IdentityMappingField> identityMapping = new ArrayList<IdentityMappingField>();
        SaasPluginManager saasPluginManager = SaasPluginManager.getInstance();
        SaasProvisionerPlugin saasPlugin = saasPluginManager.getPluginInstance(saasTarget.getPluginId());
        try {
            List<FieldInfo> fieldInfoList = FieldInfoManager.getInstance().getFieldInfoList(saasTarget);
            Map<String, FieldConfig> fieldConfigMap = saasPlugin.createDefaultMapping(ldapType, fieldInfoList);
            for (FieldInfo fieldInfo : fieldInfoList) {
                IdentityMappingField idMapping = new IdentityMappingField(fieldInfo.getCode());
                idMapping.setFieldInfo(fieldInfo);
                FieldConfig fldConfig = fieldConfigMap.get(fieldInfo.getCode());
                if (fldConfig == null) {
                    fldConfig = new FieldConfig();
                }
                idMapping.setFieldConfig(fldConfig);
                identityMapping.add(idMapping);
            }
        }
        catch (IOException e1) {
            log.error("Unable to read default config. " + e1.getMessage());
            throw new SaasException(e1);
        }
        return identityMapping;
    }
}

