/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.domain;

import com.pingidentity.provisioner.mapping.FieldConfig;
import com.pingidentity.provisioner.mapping.FieldInfo;
import java.io.Serializable;
import java.util.ArrayList;

public class IdentityMappingField
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private String fieldName = null;
    private FieldInfo fieldInfo;
    private FieldConfig fieldConfig;

    public IdentityMappingField(String name) {
        this.fieldName = name;
    }

    public IdentityMappingField(IdentityMappingField toBeCopied) {
        this.fieldName = toBeCopied.getFieldName();
        this.fieldInfo = toBeCopied.getFieldInfo();
        this.fieldConfig = new FieldConfig(toBeCopied.getFieldConfig());
    }

    public IdentityMappingField(String name, String dfltValue, ArrayList<String> attrs, String exp) {
        this.fieldConfig = new FieldConfig();
        this.fieldName = name;
        this.fieldConfig.setDefault(dfltValue);
        if (attrs != null) {
            this.fieldConfig.getAttributeNames().addAll(attrs);
        }
        this.fieldConfig.setScript(exp);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public FIELD_CASE getFieldCase() {
        if (this.fieldConfig.isToLower()) {
            return FIELD_CASE.LOWER;
        }
        if (this.fieldConfig.isToUpper()) {
            return FIELD_CASE.UPPER;
        }
        return FIELD_CASE.NONE;
    }

    public void setFieldCase(FIELD_CASE fieldCase) {
        this.fieldConfig.setToLower(false);
        this.fieldConfig.setToUpper(false);
        if (fieldCase == FIELD_CASE.LOWER) {
            this.fieldConfig.setToLower(true);
        } else if (fieldCase == FIELD_CASE.UPPER) {
            this.fieldConfig.setToUpper(true);
        }
    }

    public TRANSFORM_OPTION getTransformOption() {
        if (this.fieldConfig.isExtractCnFromDn()) {
            return TRANSFORM_OPTION.EXTRACT_CN_FROM_DN;
        }
        if (this.fieldConfig.isExtractUserNameFromEmail()) {
            return TRANSFORM_OPTION.EXTRACT_USERNAME_FROM_EMAIL;
        }
        return TRANSFORM_OPTION.NONE;
    }

    public void setTransformOption(TRANSFORM_OPTION transformOption) {
        this.fieldConfig.setExtractCnFromDn(false);
        this.fieldConfig.setExtractUserNameFromEmail(false);
        if (transformOption == TRANSFORM_OPTION.EXTRACT_CN_FROM_DN) {
            this.fieldConfig.setExtractCnFromDn(true);
        } else if (transformOption == TRANSFORM_OPTION.EXTRACT_USERNAME_FROM_EMAIL) {
            this.fieldConfig.setExtractUserNameFromEmail(true);
        }
    }

    public FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public void setFieldInfo(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
    }

    public FieldConfig getFieldConfig() {
        return this.fieldConfig;
    }

    public void setFieldConfig(FieldConfig fieldConfig) {
        this.fieldConfig = fieldConfig;
    }

    public boolean isDefined() {
        return this.fieldConfig != null && this.fieldConfig.isDefined();
    }

    public static enum TRANSFORM_OPTION {
        EXTRACT_USERNAME_FROM_EMAIL,
        EXTRACT_CN_FROM_DN,
        NONE;

    }

    public static enum FIELD_CASE {
        UPPER,
        LOWER,
        NONE;

    }
}

