/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.domain.mgmt;

import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.provisioner.saas.BaseSaasPlugin;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.xml.util.SaasDriverUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FieldInfoManager {
    private static FieldInfoManager instance = new FieldInfoManager();
    private Map<String, InternalEntry> map = new HashMap<String, InternalEntry>();
    private static Logger log = LogManager.getLogger(FieldInfoManager.class);

    private FieldInfoManager() {
    }

    public static FieldInfoManager getInstance() {
        return instance;
    }

    public synchronized List<FieldInfo> getFieldInfoList(SaasTarget saasTarget) throws SaasException {
        InternalEntry entry;
        List<FieldInfo> list = null;
        if (saasTarget != null && (entry = this.getEntry(saasTarget, true)) != null) {
            list = entry.getFieldInfoList();
        }
        return list;
    }

    public synchronized String getSaasUsernameFieldCode(SaasTarget saasTarget) throws SaasException {
        InternalEntry entry;
        String code = null;
        if (saasTarget != null && (entry = this.getEntry(saasTarget, false)) != null) {
            code = entry.getSaasUsernameFieldCode();
        }
        return code;
    }

    private InternalEntry getEntry(SaasTarget saasTarget, boolean alwaysGetFromDriver) throws SaasException {
        String key = this.mkKey(saasTarget);
        InternalEntry entry = this.map.get(key);
        if (alwaysGetFromDriver || entry == null) {
            this.retrieveFieldInfoFromDriver(saasTarget);
            entry = this.map.get(key);
        }
        return entry;
    }

    private void retrieveFieldInfoFromDriver(SaasTarget saasTarget) throws SaasException {
        BaseSaasPlugin saasPlugin = SaasDriverUtil.constructSaasDriver(saasTarget);
        if (saasPlugin == null) {
            log.error("Unknown SaasDriver");
        } else {
            if (!saasPlugin.hasLocalFieldsInfo()) {
                saasPlugin.startSession();
            }
            List<FieldInfo> fieldInfoList = saasPlugin.getFieldsInfo();
            InternalEntry entry = new InternalEntry();
            entry.setSaasUsernameFieldCode(saasPlugin.getSaasUsernameFieldCode());
            entry.setFieldInfoList(fieldInfoList);
            this.map.put(this.mkKey(saasTarget), entry);
            if (!saasPlugin.hasLocalFieldsInfo()) {
                saasPlugin.stopSession();
            }
        }
    }

    private String mkKey(SaasTarget saasTarget) {
        return saasTarget.getPluginId();
    }

    private class InternalEntry {
        private String saasUsernameFieldCode;
        private List<FieldInfo> fieldInfoList;

        private InternalEntry() {
        }

        public String getSaasUsernameFieldCode() {
            return this.saasUsernameFieldCode;
        }

        public void setSaasUsernameFieldCode(String saasUsernameFieldCode) {
            this.saasUsernameFieldCode = saasUsernameFieldCode;
        }

        public List<FieldInfo> getFieldInfoList() {
            return this.fieldInfoList;
        }

        public void setFieldInfoList(List<FieldInfo> fieldInfoList) {
            this.fieldInfoList = fieldInfoList;
        }
    }
}

