/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.domain.mgmt;

import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.sourceid.saml20.domain.scim.model.Schema;

public class ProvisionerConfig
implements Serializable,
ConnectionModuleConfiguration {
    private static final long serialVersionUID = 20050515L;
    private String entityId;
    private SaasTarget target;
    private List<Channel> channels;
    private String pluginId;
    private Schema customScim;

    public ProvisionerConfig() {
        this.channels = new ArrayList<Channel>();
    }

    public ProvisionerConfig(String id) {
        this.entityId = id;
        this.channels = new ArrayList<Channel>();
    }

    public String getModuleId() {
        return "SaasProvisioner";
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    public void addChannel(Channel channel) {
        this.channels.add(channel);
    }

    public void deleteChannel(int channelToRemove) {
        for (Channel currentChannel : this.channels) {
            if (currentChannel.getId() != channelToRemove) continue;
            this.channels.remove(currentChannel);
            break;
        }
    }

    public boolean hasChannels() {
        return this.channels != null && this.channels.size() > 0;
    }

    public SaasTarget getTarget() {
        return this.target;
    }

    public void setTarget(SaasTarget target) {
        this.target = target;
    }

    public String getType() {
        return this.pluginId;
    }

    public void setType(String type) {
        this.pluginId = type;
    }

    public Schema getCustomScim() {
        if (this.customScim == null) {
            this.customScim = new Schema();
        }
        return this.customScim;
    }

    public void setCustomScim(Schema customScim) {
        this.customScim = customScim;
    }

    public List<String> getDataSourceIdsInUse() {
        LinkedList<String> dataSourceIds = new LinkedList<String>();
        for (Channel channel : this.getChannels()) {
            if (channel.getSource() == null) continue;
            dataSourceIds.add(channel.getSource().getDataSourceId());
        }
        return dataSourceIds;
    }
}

