/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.domain.source;

import com.pingidentity.provisioner.domain.source.LdapGuidFormatter;
import com.pingidentity.provisioner.domain.source.LdapTemplate;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;

public class ChannelSource
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String TEMPLATE_NAME = "template.name";
    public static final String GUID_ATTRIBUTE_NAME = "guid.attribute.name";
    public static final String TIME_STAMP_ATTRIBUTE_NAME = "time.stamp.attribute.name";
    public static final String USER_OBJECT_CLASS = "user.object.class";
    public static final String GROUP_OBJECT_CLASS = "group.object.class";
    public static final String USN_ATTRIBUTE_NAME = "usn.attribute.name";
    public static final String ACCOUNT_STATUS_ATTRIBUTE_NAME = "account.status.attribute.name";
    public static final String GROUP_MEMBER_ATTRIBUTE_NAME = "group.member.attribute.name";
    public static final String MEMBER_OF_GROUP_ATTRIBUTE_NAME = "member.of.group.attribute.name";
    public static final String CHANGED_USERS_ALGORITHM = "changed.users.algorithm";
    public static final String DEFAULT_STATUS = "default.status";
    public static final String ACCOUNT_STATUS_ALGORITHM = "account.status.algorithm";
    public static final String FLAG_COMPARISION_VALUE = "flag.comparision.value";
    public static final String FLAG_COMPARISION_STATUS = "flag.comparision.status";
    public static final String GUID_IS_BINARY = "guid.is.binary";
    public static final String CLASSNAME_ActiveDirectoryAccountStatusReader = "com.pingidentity.provisioner.directory.spring.ActiveDirectoryAccountStatusReader";
    public static final String CLASSNAME_FlagAccountStatusReader = "com.pingidentity.provisioner.directory.spring.FlagAccountStatusReader";
    public static final String ACCOUNT_STATUS_ALGORITHM_ActiveDirectoryAccountStatusReader = "Active Directory Bitmap";
    public static final String ACCOUNT_STATUS_ALGORITHM_FlagAccountStatusReader = "Flag";
    public static final String CLASSNAME_UsnChangedUsersAlgorithm = "com.pingidentity.provisioner.directory.spring.UsnChangedUsersAlgorithm";
    public static final String CLASSNAME_TimestampChangedUsersAlgorithm = "com.pingidentity.provisioner.directory.spring.TimestampChangedUsersAlgorithm";
    public static final String CHANGED_USERS_ALGORITHM_Usn = "Active Directory USN";
    public static final String CHANGED_USERS_ALGORITHM_Timestamp = "Timestamp";
    public static final String CHANGED_USERS_ALGORITHM_Timestamp_No_Negation = "Timestamp No Negation";
    private String id = null;
    private String usersBaseDN = null;
    private String filterForUsers = null;
    private String groupDNForUsers = null;
    private String groupFilterForGroups = null;
    private String groupDNForGroups = null;
    private String dataSourceId = null;
    private String memberOfGroupAttributeName = null;
    private String groupMemberAttributeName = null;
    private String changedUsersAlgorithm = null;
    private String timeStampAttributeName = null;
    private String usnAttributeName = null;
    private LdapGuidFormatter guidFormatter = null;
    private String userObjectClass = null;
    private String groupObjectClass = null;
    private String accountStatusAttributeName = null;
    private String accountStatusAlgorithm = null;
    private String flagComparisonValue = null;
    private boolean flagComparisonStatus = true;
    private boolean defaultStatus = true;
    private boolean userNestedSearch;
    private boolean groupNestedSearch;
    private LdapTemplate ldapTemplate;

    public ChannelSource() {
        this.guidFormatter = new LdapGuidFormatter();
        this.ldapTemplate = new LdapTemplate();
    }

    public ChannelSource(ChannelSource toBeCopied) {
        this.id = toBeCopied.getId();
        this.usersBaseDN = toBeCopied.getUserBaseDN();
        this.filterForUsers = toBeCopied.getFilterForUsers();
        this.groupDNForUsers = toBeCopied.getGroupDNForUsers();
        this.userNestedSearch = toBeCopied.isUserNestedSearch();
        this.groupFilterForGroups = toBeCopied.getGroupFilterForGroups();
        this.groupNestedSearch = toBeCopied.isGroupNestedSearch();
        this.groupDNForGroups = toBeCopied.getGroupDNForGroups();
        this.dataSourceId = toBeCopied.getDataSourceId();
        if (toBeCopied.getLdapTemplate() != null) {
            this.ldapTemplate = new LdapTemplate(toBeCopied.getLdapTemplate());
        }
        this.memberOfGroupAttributeName = toBeCopied.getMemberOfGroupAttributeName();
        this.groupMemberAttributeName = toBeCopied.getGroupMemberAttributeName();
        this.changedUsersAlgorithm = toBeCopied.getChangedUsersAlgorithm();
        this.timeStampAttributeName = toBeCopied.getTimeStampAttributeName();
        this.usnAttributeName = toBeCopied.getUsnAttributeName();
        if (toBeCopied.getGuidFormatter() != null) {
            this.guidFormatter = new LdapGuidFormatter(toBeCopied.getGuidFormatter());
        }
        this.userObjectClass = toBeCopied.getUserObjectClass();
        this.groupObjectClass = toBeCopied.getGroupObjectClass();
        this.accountStatusAttributeName = toBeCopied.getAccountStatusAttributeName();
        this.accountStatusAlgorithm = toBeCopied.getAccountStatusAlgorithm();
        this.flagComparisonValue = toBeCopied.getFlagComparisonValue();
        this.flagComparisonStatus = toBeCopied.isFlagComparisonStatus();
        this.defaultStatus = toBeCopied.isDefaultStatus();
    }

    public ChannelSource(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserBaseDN() {
        return this.usersBaseDN;
    }

    public void setUserBaseDN(String userBaseDN) {
        this.usersBaseDN = userBaseDN;
    }

    public String getFilterForUsers() {
        return this.filterForUsers;
    }

    public void setFilterForUsers(String filterForUsers) {
        this.filterForUsers = filterForUsers;
    }

    public String getGroupDNForUsers() {
        return this.groupDNForUsers;
    }

    public void setGroupDNForUsers(String groupDNForUsers) {
        this.groupDNForUsers = groupDNForUsers;
    }

    public String getGroupFilterForGroups() {
        return this.groupFilterForGroups;
    }

    public void setGroupFilterForGroups(String groupFilterForGroups) {
        this.groupFilterForGroups = groupFilterForGroups;
    }

    public String getGroupDNForGroups() {
        return this.groupDNForGroups;
    }

    public void setGroupDNForGroups(String groupDNForGroups) {
        this.groupDNForGroups = groupDNForGroups;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
        this.ldapTemplate.setDataSourceId(dataSourceId);
    }

    public String getMemberOfGroupAttributeName() {
        return this.memberOfGroupAttributeName;
    }

    public void setMemberOfGroupAttributeName(String memberOfGroupAttributeName) {
        this.memberOfGroupAttributeName = memberOfGroupAttributeName;
    }

    public String getGroupMemberAttributeName() {
        return this.groupMemberAttributeName;
    }

    public void setGroupMemberAttributeName(String groupMemberAttributeName) {
        this.groupMemberAttributeName = groupMemberAttributeName;
    }

    public String getChangedUsersAlgorithm() {
        return this.changedUsersAlgorithm;
    }

    public void setChangedUsersAlgorithm(String changedUsersAlgorithm) {
        this.changedUsersAlgorithm = changedUsersAlgorithm;
    }

    public String getTimeStampAttributeName() {
        return this.timeStampAttributeName;
    }

    public void setTimeStampAttributeName(String timeStampAttributeName) {
        this.timeStampAttributeName = timeStampAttributeName;
    }

    public String getUsnAttributeName() {
        return this.usnAttributeName;
    }

    public void setUsnAttributeName(String usnAttributeName) {
        this.usnAttributeName = usnAttributeName;
    }

    public LdapGuidFormatter getGuidFormatter() {
        return this.guidFormatter;
    }

    public void setGuidFormatter(LdapGuidFormatter guidFormatter) {
        this.guidFormatter = guidFormatter;
    }

    public String getUsersBaseDN() {
        return this.usersBaseDN;
    }

    public void setUsersBaseDN(String usersBaseDN) {
        this.usersBaseDN = usersBaseDN;
    }

    public String getUserObjectClass() {
        return this.userObjectClass;
    }

    public void setUserObjectClass(String userObjectClass) {
        this.userObjectClass = userObjectClass;
    }

    public String getGroupObjectClass() {
        return this.groupObjectClass;
    }

    public void setGroupObjectClass(String groupObjectClass) {
        this.groupObjectClass = groupObjectClass;
    }

    public String getAccountStatusAttributeName() {
        return this.accountStatusAttributeName;
    }

    public void setAccountStatusAttributeName(String accountStatusAttributeName) {
        this.accountStatusAttributeName = accountStatusAttributeName;
    }

    public String getAccountStatusAlgorithm() {
        return this.accountStatusAlgorithm;
    }

    public void setAccountStatusAlgorithm(String accountStatusAlgorithm) {
        this.accountStatusAlgorithm = accountStatusAlgorithm;
    }

    public String getFlagComparisonValue() {
        return this.flagComparisonValue;
    }

    public void setFlagComparisonValue(String flagComparisonValue) {
        this.flagComparisonValue = flagComparisonValue;
    }

    public boolean isFlagComparisonStatus() {
        return this.flagComparisonStatus;
    }

    public void setFlagComparisonStatus(boolean flagComparisonStatus) {
        this.flagComparisonStatus = flagComparisonStatus;
    }

    public boolean isDefaultStatus() {
        return this.defaultStatus;
    }

    public void setDefaultStatus(boolean defaultStatus) {
        this.defaultStatus = defaultStatus;
    }

    public static String[] getAccountStatusAlgorithmList(String srcDirectoryType) {
        if (LdapInfo.LdapType.ActiveDirectory.toString().equals(srcDirectoryType)) {
            String[] asa = new String[]{ACCOUNT_STATUS_ALGORITHM_ActiveDirectoryAccountStatusReader, ACCOUNT_STATUS_ALGORITHM_FlagAccountStatusReader};
            return asa;
        }
        String[] asa = new String[]{ACCOUNT_STATUS_ALGORITHM_FlagAccountStatusReader};
        return asa;
    }

    public static String[] getChangedUsersAlgorithmList(String srcDirectoryType) {
        if (LdapInfo.LdapType.ActiveDirectory.toString().equals(srcDirectoryType)) {
            String[] usa = new String[]{CHANGED_USERS_ALGORITHM_Usn, CHANGED_USERS_ALGORITHM_Timestamp, CHANGED_USERS_ALGORITHM_Timestamp_No_Negation};
            return usa;
        }
        String[] usa = new String[]{CHANGED_USERS_ALGORITHM_Timestamp, CHANGED_USERS_ALGORITHM_Timestamp_No_Negation};
        return usa;
    }

    private static void loadAccountStatusAlgorithm(ChannelSource src, Properties p) {
        String accountStatusAlgorithm = p.getProperty(ACCOUNT_STATUS_ALGORITHM);
        if (!StringUtils.isBlank((String)accountStatusAlgorithm) && ACCOUNT_STATUS_ALGORITHM_ActiveDirectoryAccountStatusReader.equalsIgnoreCase(accountStatusAlgorithm.trim())) {
            src.setAccountStatusAlgorithm(ACCOUNT_STATUS_ALGORITHM_ActiveDirectoryAccountStatusReader);
            return;
        }
        src.setAccountStatusAlgorithm(ACCOUNT_STATUS_ALGORITHM_FlagAccountStatusReader);
    }

    private static void loadChangedUsersAlgorithm(ChannelSource src, Properties p) {
        String changedUsersAlgorithm = p.getProperty(CHANGED_USERS_ALGORITHM);
        if (!StringUtils.isBlank((String)changedUsersAlgorithm)) {
            if (CHANGED_USERS_ALGORITHM_Usn.equalsIgnoreCase(changedUsersAlgorithm.trim())) {
                src.setChangedUsersAlgorithm(CHANGED_USERS_ALGORITHM_Usn);
                return;
            }
            if (CHANGED_USERS_ALGORITHM_Timestamp_No_Negation.equalsIgnoreCase(changedUsersAlgorithm.trim())) {
                src.setChangedUsersAlgorithm(CHANGED_USERS_ALGORITHM_Timestamp_No_Negation);
                return;
            }
        }
        src.setChangedUsersAlgorithm(CHANGED_USERS_ALGORITHM_Timestamp);
    }

    public boolean isUserNestedSearch() {
        return this.userNestedSearch;
    }

    public void setUserNestedSearch(boolean usersNestedSearch) {
        this.userNestedSearch = usersNestedSearch;
    }

    public boolean isGroupNestedSearch() {
        return this.groupNestedSearch;
    }

    public void setGroupNestedSearch(boolean groupNestedSearch) {
        this.groupNestedSearch = groupNestedSearch;
    }

    @Deprecated
    public LdapTemplate getLdapTemplate() {
        return this.ldapTemplate;
    }

    public static class Factory {
        public static ChannelSource newInstance(Properties p) {
            ChannelSource src = new ChannelSource();
            LdapGuidFormatter guidFormatter = new LdapGuidFormatter();
            src.setGuidFormatter(guidFormatter);
            if (p != null) {
                Factory.load(src, guidFormatter, p);
            }
            return src;
        }

        private static void load(ChannelSource src, LdapGuidFormatter guidFormatter, Properties p) {
            String guidAttributeName = p.getProperty(ChannelSource.GUID_ATTRIBUTE_NAME);
            guidFormatter.setGuidAttributeName(!StringUtils.isBlank((String)guidAttributeName) ? guidAttributeName.trim() : "");
            guidFormatter.setGuidIsBinary(new Boolean(p.getProperty(ChannelSource.GUID_IS_BINARY)));
            String memberOfGroupAttributeName = p.getProperty(ChannelSource.MEMBER_OF_GROUP_ATTRIBUTE_NAME);
            src.setMemberOfGroupAttributeName(!StringUtils.isBlank((String)memberOfGroupAttributeName) ? memberOfGroupAttributeName.trim() : "");
            String groupMemberAttributeName = p.getProperty(ChannelSource.GROUP_MEMBER_ATTRIBUTE_NAME);
            src.setGroupMemberAttributeName(!StringUtils.isBlank((String)groupMemberAttributeName) ? groupMemberAttributeName.trim() : "");
            String userObjectClass = p.getProperty(ChannelSource.USER_OBJECT_CLASS);
            src.setUserObjectClass(!StringUtils.isBlank((String)userObjectClass) ? userObjectClass.trim() : "");
            String groupObjectClass = p.getProperty(ChannelSource.GROUP_OBJECT_CLASS);
            src.setGroupObjectClass(!StringUtils.isBlank((String)groupObjectClass) ? groupObjectClass.trim() : "");
            ChannelSource.loadChangedUsersAlgorithm(src, p);
            String usnAttributeName = p.getProperty(ChannelSource.USN_ATTRIBUTE_NAME);
            src.setUsnAttributeName(!StringUtils.isBlank((String)usnAttributeName) ? usnAttributeName.trim() : "");
            String timeStampAttrName = p.getProperty(ChannelSource.TIME_STAMP_ATTRIBUTE_NAME);
            src.setTimeStampAttributeName(!StringUtils.isBlank((String)timeStampAttrName) ? timeStampAttrName.trim() : "");
            String accountStatusAttributeName = p.getProperty(ChannelSource.ACCOUNT_STATUS_ATTRIBUTE_NAME);
            src.setAccountStatusAttributeName(!StringUtils.isBlank((String)accountStatusAttributeName) ? accountStatusAttributeName.trim() : "");
            ChannelSource.loadAccountStatusAlgorithm(src, p);
            String flagComparisionValue = p.getProperty(ChannelSource.FLAG_COMPARISION_VALUE);
            src.setFlagComparisonValue(!StringUtils.isBlank((String)flagComparisionValue) ? flagComparisionValue.trim() : "");
            src.setFlagComparisonStatus(new Boolean(p.getProperty(ChannelSource.FLAG_COMPARISION_STATUS)));
            src.setDefaultStatus(new Boolean(p.getProperty(ChannelSource.DEFAULT_STATUS)));
        }
    }
}

