/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.handler;

import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.RuntimeClusteringException;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.DirectoryResourceCallback;
import com.pingidentity.provisioner.directory.GuidFormatter;
import com.pingidentity.provisioner.directory.spring.DirectoryResourceAttributesMapper;
import com.pingidentity.provisioner.directory.spring.RuntimeDirectoryException;
import com.pingidentity.provisioner.handler.BaseProvisioningAttributeHandler;
import com.pingidentity.provisioner.mapping.AttributesMapper;
import com.pingidentity.provisioner.resources.DirectoryResource;
import com.pingidentity.provisioner.util.UnboundIdProvisioningUtil;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.log.AttributeMap;

public class ResourceProvisionAttributeHandler
extends BaseProvisioningAttributeHandler {
    private final DirectoryResourceCallback _callback;
    private final GuidFormatter _guidFormatter;

    public ResourceProvisionAttributeHandler(DirectoryResourceCallback callback, GuidFormatter guidFormatter) {
        this._callback = callback;
        this._guidFormatter = guidFormatter;
    }

    @Override
    public Set<String> getAttributeNames() {
        return this._callback.getAttributeNames();
    }

    @Override
    public void handle(AttributeMap attributeMap) {
        String dn = ((AttributeValue)attributeMap.get((Object)"Subject DN")).getValue();
        try {
            AttributesMapper mapper = this._callback.getAttributeMapper();
            if (mapper == null) {
                DirectoryResourceAttributesMapper resourceMapper = new DirectoryResourceAttributesMapper();
                resourceMapper.setGuidFormatter(this._guidFormatter);
                mapper = resourceMapper;
            }
            Attributes attributes = UnboundIdProvisioningUtil.loadAttrs(attributeMap);
            DirectoryResource resource = (DirectoryResource)mapper.mapFromAttributes(attributes);
            this._callback.process(dn, resource);
        }
        catch (DirectoryException | NamingException e) {
            throw new RuntimeDirectoryException(e);
        }
        catch (ClusteringException e) {
            throw new RuntimeClusteringException(e);
        }
    }
}

