/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.mapping;

import com.pingidentity.provisioner.identity.DirectoryIdentity;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.mapping.DefaultMapper;
import com.pingidentity.provisioner.mapping.FieldConfig;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.provisioner.mapping.FieldMapper;
import com.pingidentity.provisioner.mapping.MappingException;
import com.pingidentity.provisioner.mapping.OgnlFieldMapper;
import com.pingidentity.provisioner.mapping.PostProcessorFieldMapper;
import com.pingidentity.provisioner.mapping.RawLdapAttributesFieldMapper;
import com.pingidentity.provisioner.mapping.SimpleFieldMapper;
import com.pingidentity.provisioner.mapping.ValueProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public class IdentityMapper {
    private static Logger _logger = LogManager.getLogger(IdentityMapper.class);
    private String _channelCode;
    private Map<String, FieldMapper> _fieldMappers = new HashMap<String, FieldMapper>();
    private Map<String, FieldInfo> _fieldInfos = new HashMap<String, FieldInfo>();
    private Set<String> _attributeNames = new HashSet<String>();
    private Set<String> _specialAttributeNames = new HashSet<String>();
    private Set<String> _createOnlyFields = Collections.emptySet();
    private Set<String> _maskedFields = new HashSet<String>();
    private String _saasUsernameFieldCode;

    private IdentityMapper(String channelCode) {
        this._channelCode = channelCode;
    }

    private void addFieldMapper(String fieldCode, FieldMapper fieldMapper) {
        this._fieldMappers.put(fieldCode, fieldMapper);
    }

    private void addFieldInfo(FieldInfo fieldInfo) {
        this._fieldInfos.put(fieldInfo.getCode(), fieldInfo);
    }

    private void addAttributeNames(Collection<String> attributeNames) {
        this._attributeNames.addAll(attributeNames);
    }

    public void setSpecialAttributeNames(Collection<String> specialAttributeNames) {
        this._specialAttributeNames = new HashSet<String>();
        this._specialAttributeNames.addAll(specialAttributeNames);
    }

    public void setSaasUsernameFieldCode(String saasUsernameFieldCode) {
        this._saasUsernameFieldCode = saasUsernameFieldCode;
    }

    public Set<String> getCreateOnlyFields() {
        return this._createOnlyFields;
    }

    private void setCreateOnlyFields(Set<String> createOnlyFields) {
        this._createOnlyFields = Collections.unmodifiableSet(createOnlyFields);
    }

    public Set<String> getMaskedFields() {
        return this._maskedFields;
    }

    private void setMaskedFields(Set<String> maskedFields) {
        this._maskedFields = Collections.unmodifiableSet(maskedFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IdentityMapper createIdentityMapper(String channelCode, String saasUsernameFieldCode, List<FieldInfo> fieldInfos, Map<String, FieldConfig> fieldConfigs) {
        try {
            ThreadContext.push((String)("Channel: " + channelCode));
            IdentityMapper identityMapper = new IdentityMapper(channelCode);
            identityMapper.setSaasUsernameFieldCode(saasUsernameFieldCode);
            HashSet<String> createOnlyFields = new HashSet<String>();
            HashSet<String> maskedFields = new HashSet<String>();
            for (FieldInfo fieldInfo : fieldInfos) {
                String fieldCode = fieldInfo.getCode();
                ThreadContext.push((String)("Field: " + fieldCode));
                if (fieldConfigs.containsKey(fieldCode)) {
                    FieldConfig fieldConfig = fieldConfigs.get(fieldCode);
                    if (fieldConfig.hasAttributeNames() || fieldConfig.hasScript() || fieldConfig.hasDefault()) {
                        void var11_20;
                        Object var11_12 = null;
                        List<String> attributeNames = fieldConfig.getAttributeNames();
                        if (fieldInfo.isLdapMap()) {
                            RawLdapAttributesFieldMapper rawLdapAttributesFieldMapper = new RawLdapAttributesFieldMapper(fieldConfig.getAttributeNames());
                        } else {
                            void var11_18;
                            block20: {
                                if (fieldConfig.hasScript()) {
                                    try {
                                        OgnlFieldMapper ognlFieldMapper = new OgnlFieldMapper(fieldConfig.getScript(), attributeNames);
                                        break block20;
                                    }
                                    catch (Exception e) {
                                        _logger.error("Cannot compile OGNL script: " + fieldConfig.getScript(), (Throwable)e);
                                        ThreadContext.pop();
                                        continue;
                                    }
                                }
                                if (fieldConfig.hasAttributeNames()) {
                                    if (attributeNames.size() > 1) {
                                        _logger.error("Configuration error, only one attribute name expected if no script specified.");
                                    }
                                    SimpleFieldMapper simpleFieldMapper = new SimpleFieldMapper(attributeNames.get(0));
                                }
                            }
                            if (fieldConfig.hasDefault()) {
                                void var11_16;
                                DefaultMapper defaultMapper = new DefaultMapper((FieldMapper)var11_16, fieldConfig.getDefault());
                            }
                            FieldMapper fieldMapper = IdentityMapper.wrapPostProcessing((FieldMapper)var11_18, fieldConfig);
                            if (fieldConfig.isCreateOnly()) {
                                createOnlyFields.add(fieldCode);
                            }
                            if (fieldConfig.isMasked()) {
                                maskedFields.add(fieldCode);
                            }
                        }
                        identityMapper.addFieldInfo(fieldInfo);
                        identityMapper.addFieldMapper(fieldCode, (FieldMapper)var11_20);
                        identityMapper.addAttributeNames(attributeNames);
                        continue;
                    }
                    _logger.info("Empty field, ignoring.");
                    continue;
                }
                _logger.info("No field config, ignoring.");
            }
            identityMapper.setCreateOnlyFields(createOnlyFields);
            identityMapper.setMaskedFields(maskedFields);
            return identityMapper;
        }
        finally {
            ThreadContext.pop();
        }
    }

    private static FieldMapper wrapPostProcessing(FieldMapper fieldMapper, FieldConfig fieldConfig) {
        ArrayList<ValueProcessor> processors = new ArrayList<ValueProcessor>();
        if (fieldConfig.isTrim()) {
            processors.add(ValueProcessor.TRIM);
        }
        if (fieldConfig.isToUpper()) {
            processors.add(ValueProcessor.TO_UPPER);
        }
        if (fieldConfig.isToLower()) {
            processors.add(ValueProcessor.TO_LOWER);
        }
        if (fieldConfig.isStripDomain()) {
            processors.add(ValueProcessor.STRIP_DOMAIN);
        }
        if (fieldConfig.isExtractCnFromDn()) {
            processors.add(ValueProcessor.EXTRACT_CN_FROM_DN);
        }
        if (fieldConfig.isExtractUserNameFromEmail()) {
            processors.add(ValueProcessor.EXTRACT_USERNAME_FROM_EMAIL);
        }
        return processors.size() == 0 ? fieldMapper : new PostProcessorFieldMapper(fieldMapper, processors);
    }

    public String getChannelCode() {
        return this._channelCode;
    }

    public SaasIdentity map(DirectoryIdentity directoryIdentity) throws MappingException {
        boolean valid = true;
        HashMap<String, List<String>> mappingErrors = new HashMap<String, List<String>>();
        SaasIdentity saasIdentity = new SaasIdentity(this._saasUsernameFieldCode);
        saasIdentity.setAccountEnabled(directoryIdentity.isAccountEnabled());
        saasIdentity.setInternalGuid(directoryIdentity.getGuid());
        for (String fieldCode : this._fieldMappers.keySet()) {
            List<String> values;
            FieldMapper fieldMapper = this._fieldMappers.get(fieldCode);
            FieldInfo fieldInfo = this._fieldInfos.get(fieldCode);
            if (fieldMapper.isMappingToMap()) {
                Map<String, List<String>> map;
                try {
                    map = fieldMapper.mapToMap(directoryIdentity);
                }
                catch (Exception e) {
                    throw new MappingException("Unable to map SaaS field '" + fieldInfo.getLabel() + "' for identity: " + directoryIdentity, e);
                }
                saasIdentity.putMap(fieldCode, map);
                continue;
            }
            try {
                values = fieldMapper.map(directoryIdentity);
            }
            catch (Exception e) {
                throw new MappingException("Unable to map SaaS field '" + fieldInfo.getLabel() + "' for identity: " + directoryIdentity, e);
            }
            ArrayList<String> fieldErrors = new ArrayList<String>();
            if (fieldInfo.validate(values, fieldErrors)) {
                saasIdentity.putValues(fieldCode, values);
                continue;
            }
            valid = false;
            mappingErrors.put(fieldCode, fieldErrors);
        }
        if (!valid) {
            MappingException mappingException = new MappingException();
            mappingException.setMappingErrors(mappingErrors);
            throw mappingException;
        }
        saasIdentity.setCreateOnlyFields(this._createOnlyFields);
        saasIdentity.setMaskedFields(this._maskedFields);
        return saasIdentity;
    }

    public Set<String> getAttributeNames() {
        HashSet<String> allAtributesNames = new HashSet<String>(this._attributeNames);
        allAtributesNames.addAll(this._specialAttributeNames);
        return allAtributesNames;
    }
}

