/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.mapping;

import com.pingidentity.provisioner.identity.DirectoryIdentity;
import com.pingidentity.provisioner.mapping.FieldMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class OgnlFieldMapper
implements FieldMapper {
    private Object _expression;
    private List<String> _attributeNames;
    private static ConfigStore config = ConfigStoreFarm.getConfig(OgnlFieldMapper.class);

    public OgnlFieldMapper(String expressionSource, List<String> attributeNames) throws OgnlException {
        this._expression = Ognl.parseExpression((String)expressionSource);
        this._attributeNames = new ArrayList<String>(attributeNames);
    }

    public OgnlFieldMapper(String expressionSource, String ... attributeNames) throws OgnlException {
        this._expression = Ognl.parseExpression((String)expressionSource);
        this._attributeNames = new ArrayList<String>(Arrays.asList(attributeNames));
    }

    @Override
    public List<String> map(DirectoryIdentity directoryIdentity) throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        OgnlContext context = new OgnlContext();
        for (String attributeName : this._attributeNames) {
            if (config.getBooleanValue("supportMultiValuesFromDirectory", true)) {
                AttributeValue attributeValues = new AttributeValue(directoryIdentity.getValues(attributeName));
                context.put((Object)attributeName, (Object)attributeValues);
                continue;
            }
            context.put((Object)attributeName, (Object)directoryIdentity.getValue(attributeName));
        }
        context.put((Object)"_entry", (Object)directoryIdentity);
        Object result = Ognl.getValue((Object)this._expression, (Map)context, (Object)context);
        if (result instanceof List) {
            for (Object resultListElement : (List)result) {
                values.add(resultListElement.toString());
            }
        } else {
            values.add(result.toString());
        }
        return values;
    }

    @Override
    public boolean isMappingToMap() {
        return false;
    }

    @Override
    public Map<String, List<String>> mapToMap(DirectoryIdentity directoryIdentity) throws Exception {
        throw new UnsupportedOperationException();
    }
}

