/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.mapping;

import com.pingidentity.provisioner.identity.DirectoryIdentity;
import com.pingidentity.provisioner.mapping.FieldMapper;
import com.pingidentity.provisioner.mapping.ValueProcessor;
import java.util.List;
import java.util.Map;

public class PostProcessorFieldMapper
implements FieldMapper {
    private FieldMapper _baseMapper;
    private List<ValueProcessor> _processors;

    public PostProcessorFieldMapper(FieldMapper baseMapper, List<ValueProcessor> processors) {
        this._baseMapper = baseMapper;
        this._processors = processors;
    }

    @Override
    public List<String> map(DirectoryIdentity directoryIdentity) throws Exception {
        List<String> values = this._baseMapper.map(directoryIdentity);
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                String value = values.get(i);
                if (value == null) continue;
                for (ValueProcessor processor : this._processors) {
                    value = processor.process(value);
                }
                values.set(i, value);
            }
        }
        return values;
    }

    @Override
    public boolean isMappingToMap() {
        return false;
    }

    @Override
    public Map<String, List<String>> mapToMap(DirectoryIdentity directoryIdentity) throws Exception {
        throw new UnsupportedOperationException();
    }
}

