/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.mapping;

import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ValueProcessor {
    public static final ValueProcessor TRIM = new ValueProcessor(){

        @Override
        public String process(String value) {
            return value == null ? null : value.trim();
        }
    };
    public static final ValueProcessor TO_LOWER = new ValueProcessor(){

        @Override
        public String process(String value) {
            return value == null ? null : value.toLowerCase();
        }
    };
    public static final ValueProcessor TO_UPPER = new ValueProcessor(){

        @Override
        public String process(String value) {
            return value == null ? null : value.toUpperCase();
        }
    };
    public static final ValueProcessor STRIP_DOMAIN = new ValueProcessor(){

        @Override
        public String process(String value) {
            if (value == null) {
                return value;
            }
            int idxAt = value.indexOf(64);
            return idxAt > -1 ? value.substring(0, idxAt) : value;
        }
    };
    public static final ValueProcessor EXTRACT_CN_FROM_DN = new ValueProcessor(){

        @Override
        public String process(String value) {
            if (value == null) {
                return value;
            }
            int cnIdLength = 3;
            int cnIdIndex = value.indexOf("CN=");
            if (cnIdIndex == -1) {
                cnIdIndex = value.indexOf("cn=");
            }
            int firstCommaIndex = value.indexOf(",");
            return cnIdIndex > -1 && firstCommaIndex > -1 ? value.substring(cnIdIndex + cnIdLength, firstCommaIndex).trim() : value;
        }
    };
    public static final ValueProcessor EXTRACT_USERNAME_FROM_EMAIL = new ValueProcessor(){
        private Logger log = LogManager.getLogger(ValueProcessor.class);

        @Override
        public String process(String value) {
            String valueToReturn = "";
            if (value != null) {
                int indexOfAT;
                String smtp;
                if ((value = value.toLowerCase().trim()).startsWith(smtp = "smtp:")) {
                    value = value.substring(smtp.length());
                }
                if ((indexOfAT = value.indexOf("@")) > 0) {
                    valueToReturn = value.substring(0, indexOfAT);
                    valueToReturn = StringUtils.trim((String)valueToReturn);
                } else {
                    this.log.warn("Value (" + value + ") does not contain a well formatted email address. Discarding value.");
                }
            }
            return valueToReturn;
        }
    };

    public String process(String var1);
}

