/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.monitor;

import com.pingidentity.provisioner.monitor.SaasProvisioningEventTracker;
import java.util.Date;

public class Event {
    private long cycleId;
    private Date timestamp;
    private String sourceId;
    private String targetId;
    private SaasProvisioningEventTracker.EventType type;
    private int channelId;
    private String failureCause;

    public Event(long cycleId, Date timestamp, String sourceId, String targetId, SaasProvisioningEventTracker.EventType type, int channelId, String failureCause) {
        this.cycleId = cycleId;
        this.timestamp = timestamp;
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.type = type;
        this.channelId = channelId;
        this.failureCause = failureCause;
    }

    public boolean isSuccess() {
        return this.failureCause == null;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public SaasProvisioningEventTracker.EventType getType() {
        return this.type;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public String getFailureCause() {
        return this.failureCause;
    }

    public long getCycleId() {
        return this.cycleId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("User provisioning event during cycle ").append(this.cycleId).append(" in channel ").append(this.channelId).append(" @ ").append(this.timestamp);
        sb.append(" type: '").append((Object)this.type);
        sb.append("' successful: '").append(this.isSuccess());
        sb.append("' source id: '").append(this.sourceId);
        sb.append("' target id: '").append(this.targetId).append("'");
        if (!this.isSuccess()) {
            sb.append(" cause: '").append(this.failureCause).append("'");
        }
        return sb.toString();
    }
}

