/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.monitor;

import com.pingidentity.provisioner.monitor.Event;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.util.license.LicenseMgrInfo;

public class ProvisionerAuditLogger {
    static final String COL_NAME_PF_VERSION = "pfversion";
    static final String COL_NAME_CYCLE_ID = "cycle_id";
    static final String COL_NAME_CHANNEL_ID = "channel_id";
    static final String COL_NAME_EVENT_TYPE = "event_type";
    static final String COL_NAME_SRC_ID = "source_id";
    static final String COL_NAME_TARGET_ID = "target_id";
    static final String COL_NAME_SUCCESS = "is_success";
    static final String COL_NAME_NONSUCCESS_CAUSE = "non_success_cause";
    private final Log provAuditLog;
    private Event event;

    public ProvisionerAuditLogger(Event event) {
        this.event = event;
        this.provAuditLog = LogFactory.getLog((String)"ProvisionerAuditLogger");
        LicenseMgrInfo licenseMgrInfo = (LicenseMgrInfo)GlobalRegistry.getService(LicenseMgrInfo.class);
        this.setLogAttribute(COL_NAME_PF_VERSION, licenseMgrInfo.getMajorVersion() + "." + licenseMgrInfo.getMinorVersion());
    }

    public void setAttributesToLog() {
        if (this.event != null) {
            this.setLogAttribute(COL_NAME_CYCLE_ID, String.valueOf(this.event.getCycleId()));
            this.setLogAttribute(COL_NAME_CHANNEL_ID, String.valueOf(this.event.getChannelId()));
            this.setLogAttribute(COL_NAME_EVENT_TYPE, String.valueOf((Object)this.event.getType()));
            this.setLogAttribute(COL_NAME_SRC_ID, this.event.getSourceId());
            this.setLogAttribute(COL_NAME_TARGET_ID, this.event.getTargetId());
            this.setLogAttribute(COL_NAME_SUCCESS, String.valueOf(this.event.isSuccess()));
            this.setLogAttribute(COL_NAME_NONSUCCESS_CAUSE, this.event.getFailureCause());
        }
    }

    public void clearThreadContext() {
        ThreadContext.clearAll();
    }

    public void log() {
        if (this.event != null) {
            this.provAuditLog.info((Object)this.event.getFailureCause());
        }
    }

    private void setLogAttribute(String key, String value) {
        if (value == null) {
            ThreadContext.remove((String)key);
        } else {
            ThreadContext.put((String)key, (String)value);
        }
    }
}

