/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.monitor;

import com.pingidentity.common.util.LogGuard;
import com.pingidentity.common.util.ldap.LDAPUtilOptions;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProvisioningEventTimer
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(ProvisioningEventTimer.class);
    private final long startTime;
    private final String eventType;
    private final Map<String, Object> attributes;
    private static final String LDAP_SEARCH_BASE = "Search Base";
    private static final String LDAP_SEARCH_FILTER = "Search Filter";
    private static final String LDAP_PAGE_SIZE = "Page Size";
    private static final String INTERNAL_DB_EVENT_NAME = "Event Name";

    private ProvisioningEventTimer(String eventType, Map<String, Object> attributes) {
        this.attributes = attributes;
        this.startTime = System.currentTimeMillis();
        this.eventType = eventType;
    }

    public static ProvisioningEventTimer getLDAPPagedSearchEventTimer(LDAPUtilOptions ldapOptions) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put(LDAP_SEARCH_BASE, ldapOptions.getSearchBase());
        attributes.put(LDAP_SEARCH_FILTER, ldapOptions.getSearchFilter());
        attributes.put(LDAP_PAGE_SIZE, ldapOptions.getResultsPerPage());
        return new ProvisioningEventTimer("LDAP Paged Search", attributes);
    }

    public static ProvisioningEventTimer getInternalUserStoreEventTimer(String eventName) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put(INTERNAL_DB_EVENT_NAME, eventName);
        String eventType = "Provisioning DB Query";
        log.info((Object)("Starting " + eventType + ": " + eventName));
        return new ProvisioningEventTimer(eventType, attributes);
    }

    @Override
    public void close() {
        long timeSpent = System.currentTimeMillis() - this.startTime;
        StringBuilder msgBuilder = new StringBuilder(LogGuard.encode((String)this.eventType)).append(" {");
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            msgBuilder.append(LogGuard.encode((String)entry.getKey())).append("='");
            if (entry.getValue() != null) {
                msgBuilder.append(LogGuard.encode((String)entry.getValue().toString()));
            }
            msgBuilder.append("', ");
        }
        msgBuilder.append("timeSpentMs='").append(timeSpent).append("'}");
        log.info((Object)msgBuilder.toString());
    }
}

