/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.resources;

import com.pingidentity.provisioner.resources.ProvisionableResource;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SaasProvisionableResource
extends ProvisionableResource {
    private String _internalGuid;
    private Map<String, Map<String, List<String>>> _attributeMapMap = new HashMap<String, Map<String, List<String>>>();
    private Set<String> _maskedFields = new HashSet<String>();

    protected SaasProvisionableResource(Map<String, List<String>> attributeMap) {
        super(attributeMap);
    }

    @Override
    public Set<String> getNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(super.getNames());
        names.addAll(this._attributeMapMap.keySet());
        return names;
    }

    @Override
    public boolean hasValue(String name) {
        return this.contains(name);
    }

    @Override
    public void putValues(String name, String first, String ... rest) {
        super.putValues(name, first, rest);
        this._attributeMapMap.remove(name);
    }

    @Override
    public void putValues(String name, Collection<String> valueColl) {
        super.putValues(name, valueColl);
        if (valueColl.size() > 0) {
            this._attributeMapMap.remove(name);
        }
    }

    @Override
    public void addValues(String name, String first, String ... rest) {
        super.addValues(name, first, rest);
        this._attributeMapMap.remove(name);
    }

    @Override
    public void removeAll(String name) {
        super.removeAll(name);
        this._attributeMapMap.remove(name);
    }

    @Override
    public void clear() {
        super.clear();
        this._attributeMapMap.clear();
    }

    @Override
    public boolean contains(String name) {
        return super.contains(name) || this._attributeMapMap.containsKey(name);
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("Attributes: ");
        boolean first = true;
        for (String name : this.getNames()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(name).append('=');
            if (this.isMapValue(name)) {
                builder.append(this.getMap(name));
                continue;
            }
            List<String> values = this.getValues(name);
            builder.append(values.toString());
        }
        builder.append("; ");
    }

    public Map<String, List<String>> getMap(String name) {
        return this._attributeMapMap.get(name);
    }

    public void putMap(String name, Map<String, List<String>> map) {
        this._attributeMapMap.put(name, map);
        super.removeAll(name);
    }

    public boolean isMapValue(String name) {
        return this._attributeMapMap.containsKey(name);
    }

    public String getInternalGuid() {
        return this._internalGuid;
    }

    public void setInternalGuid(String internalGuid) {
        this._internalGuid = internalGuid;
    }

    public boolean isFieldMasked(String fieldCode) {
        return this._maskedFields.contains(fieldCode);
    }

    public Set<String> getMaskedFields() {
        return this._maskedFields;
    }

    public void setMaskedFields(Set<String> maskedFields) {
        this._maskedFields = maskedFields;
    }

    public abstract String getName();

    public abstract String getGuid();

    public abstract boolean hasGuid();

    public abstract boolean isInProvisioningGroup();
}

