/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.saas;

import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.mapping.FieldConfig;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.provisioner.monitor.ProvisioningEventLogger;
import com.pingidentity.provisioner.monitor.SaasProvisioningEventTracker;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.provisioner.store.UserStoreUpdater;
import com.pingidentity.provisioner.store.UserUpdater;
import com.pingidentity.provisioner.util.UserActivityLogger;
import com.pingidentity.provisioner.validation.SaasParametersValidator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.domain.SpConnection;

public abstract class BaseSaasPlugin
implements SaasProvisionerPlugin {
    private SaasProvisioningEventTracker _saasProvisioningEventTracker;
    private static Logger _userLogger = UserActivityLogger.getLogger();
    boolean _sessionStarted = false;
    private List<FieldInfo> _fieldInfos = new ArrayList<FieldInfo>();
    private String _saasUsernameFieldCode;
    private int _channelId;
    protected FieldList _parameters = new SimpleFieldList();
    protected List<SaasParametersValidator> saasParametersValidators = new ArrayList<SaasParametersValidator>();
    private Set<String> persistForMembershipFields = new HashSet<String>();
    private SpConnection spConnection;
    private ProvisioningEventLogger _provisioningEventLogger;

    @Override
    public void setParameters(FieldList parameters) {
        this._parameters = new SimpleFieldList(parameters.getFields());
    }

    public SaasProvisioningEventTracker getSaasProvisioningEventTracker() {
        return this._saasProvisioningEventTracker;
    }

    public static Logger getUserLogger() {
        return _userLogger;
    }

    public int getChannelId() {
        return this._channelId;
    }

    public void setChannelId(int channelId) {
        this._channelId = channelId;
    }

    @Override
    public String getSaasUsernameFieldCode() throws SaasException {
        if (this._saasUsernameFieldCode == null) {
            this.doLoadFieldsInfo();
        }
        return this._saasUsernameFieldCode;
    }

    public void setSaasUsernameFieldCode(String usernameField) {
        this._saasUsernameFieldCode = usernameField;
    }

    public void setFieldInfos(List<FieldInfo> fieldInfos) {
        this._fieldInfos = fieldInfos;
    }

    public void addFieldInfo(FieldInfo fieldInfo) {
        this._fieldInfos.add(fieldInfo);
    }

    public void setFieldInfos(String propertiesFilename) throws IOException {
        this._fieldInfos = FieldInfo.parseFieldsInfo(propertiesFilename);
    }

    public void setFieldInfos(File propertiesFile) throws IOException {
        this._fieldInfos = FieldInfo.parseFieldsInfo(propertiesFile);
    }

    public boolean hasLocalFieldsInfo() {
        return false;
    }

    @Override
    public List<FieldInfo> getFieldsInfo() throws SaasException {
        if (this._fieldInfos.size() == 0) {
            this.doLoadFieldsInfo();
        }
        return this._fieldInfos;
    }

    @Override
    public void startSession() throws SaasException {
        this._sessionStarted = true;
    }

    @Override
    public void checkSession() throws SaasException {
    }

    @Override
    public void stopSession() throws SaasException {
        this._sessionStarted = false;
    }

    @Override
    public boolean isSessionStarted() {
        return this._sessionStarted;
    }

    public void setEventTracker(SaasProvisioningEventTracker et) {
        this._saasProvisioningEventTracker = et;
    }

    public void setProvisioningEventLogger(ProvisioningEventLogger provisioningEventLogger) {
        this._provisioningEventLogger = provisioningEventLogger;
    }

    @Override
    public void updateUser(SaasIdentity identity, UserStoreUpdater userUpdater, String sourceGuid) throws SaasException {
        String targetId;
        userUpdater.setSaasIdentity(identity);
        userUpdater.setPersistForMembershipFields(this.getPersistForMembershipFields());
        SaasException saasException = null;
        SaasProvisioningEventTracker.EventType eventType = null;
        SaasIdentity existingIdentity = this.doGetUser(identity);
        try {
            if (existingIdentity == null) {
                if (identity.isInProvisioningGroup()) {
                    eventType = SaasProvisioningEventTracker.EventType.CREATE;
                    this.doCreateUser(identity, userUpdater);
                    this._provisioningEventLogger.newUserPushedToTarget();
                } else {
                    userUpdater.clearDirtyFlag();
                    _userLogger.info((Object)("Dropped: " + identity.getName()));
                }
            } else if (!identity.isInProvisioningGroup()) {
                eventType = SaasProvisioningEventTracker.EventType.DEPROVISION;
                this.doDeprovisionUser(identity, existingIdentity, userUpdater);
                this._provisioningEventLogger.userDeprovisionedFromTarget();
            } else {
                boolean isActive = identity.isActive();
                boolean wasActive = existingIdentity.isActive();
                eventType = SaasProvisioningEventTracker.EventType.UPDATE;
                if (isActive != wasActive) {
                    eventType = isActive ? SaasProvisioningEventTracker.EventType.ENABLE : SaasProvisioningEventTracker.EventType.DISABLE;
                }
                this.doUpdateUser(identity, existingIdentity, userUpdater);
                this._provisioningEventLogger.userUpdatedAtTarget();
            }
            String string = identity.hasGuid() ? identity.getGuid() : (targetId = identity.isNameMasked() ? "*****" : identity.getName());
        }
        catch (SaasException e) {
            try {
                saasException = e;
                throw e;
            }
            catch (Throwable throwable) {
                String targetId2;
                String string = identity.hasGuid() ? identity.getGuid() : (targetId2 = identity.isNameMasked() ? "*****" : identity.getName());
                if (this._saasProvisioningEventTracker != null && eventType != null) {
                    this._saasProvisioningEventTracker.trackEvent(sourceGuid, targetId2, eventType, this._channelId, saasException);
                }
                throw throwable;
            }
        }
        if (this._saasProvisioningEventTracker != null && eventType != null) {
            this._saasProvisioningEventTracker.trackEvent(sourceGuid, targetId, eventType, this._channelId, saasException);
        }
    }

    public boolean isTestConnectionSupported() {
        return true;
    }

    public boolean isUserSelectable() {
        return true;
    }

    protected abstract void doLoadFieldsInfo() throws SaasException;

    protected abstract SaasIdentity doGetUser(SaasIdentity var1) throws SaasException;

    protected abstract void doUpdateUser(SaasIdentity var1, SaasIdentity var2, UserUpdater var3) throws SaasException;

    protected abstract void doCreateUser(SaasIdentity var1, UserUpdater var2) throws SaasException;

    protected abstract Properties loadDefaultMappings() throws IOException;

    protected void doDeprovisionUser(SaasIdentity updatedIdentity, SaasIdentity existingIdentity, UserUpdater userUpdater) throws SaasException {
        this.doUpdateUser(updatedIdentity, existingIdentity, userUpdater);
    }

    @Override
    public Map<String, FieldConfig> createDefaultMapping(String directoryServerType, List<FieldInfo> fieldInfos) throws IOException {
        String directoryPrefix = "directory." + directoryServerType.toLowerCase() + ".";
        String saasPrefix = "saas.";
        String fieldConfigPrefix = "fieldconfig.";
        HashMap<String, FieldConfig> fieldConfigs = new HashMap<String, FieldConfig>(fieldInfos.size());
        Properties defaultMappings = this.loadDefaultMappings();
        for (FieldInfo fieldInfo : fieldInfos) {
            FieldConfig fieldConfig;
            String fieldCode = fieldInfo.getCode();
            String internalCode = defaultMappings.getProperty(saasPrefix + fieldCode);
            if (internalCode != null) {
                String mask;
                String createOnly;
                fieldConfig = new FieldConfig();
                String attributeName = defaultMappings.getProperty(directoryPrefix + internalCode);
                if (attributeName == null) {
                    attributeName = defaultMappings.getProperty("directory.default." + internalCode);
                }
                if (attributeName != null) {
                    fieldConfig.addAttributeName(attributeName);
                    fieldConfig.setDefault(fieldInfo.getDefault());
                }
                if ((createOnly = defaultMappings.getProperty(fieldConfigPrefix + internalCode + ".createonly")) != null) {
                    fieldConfig.setCreateOnly(Boolean.valueOf(createOnly));
                }
                if ((mask = defaultMappings.getProperty(fieldConfigPrefix + internalCode + ".mask")) != null) {
                    fieldConfig.setMasked(Boolean.valueOf(mask));
                }
                fieldConfigs.put(fieldCode, fieldConfig);
                continue;
            }
            if (!fieldInfo.hasDefault()) continue;
            fieldConfig = new FieldConfig();
            fieldConfig.setDefault(fieldInfo.getDefault());
            fieldConfigs.put(fieldCode, fieldConfig);
        }
        return fieldConfigs;
    }

    @Override
    public String getSaasCode() {
        return this.getId();
    }

    @Deprecated
    public void setSaasCode(String saasCode) {
    }

    public Set<String> getPersistForMembershipFields() throws SaasException {
        if (this._fieldInfos.isEmpty()) {
            this.doLoadFieldsInfo();
        }
        return Collections.unmodifiableSet(this.persistForMembershipFields);
    }

    public void setPersistForMembershipFields(Set<String> persistForMembershipFields) {
        this.persistForMembershipFields = persistForMembershipFields;
    }

    public void setSpConnection(SpConnection spConnection) {
        this.spConnection = spConnection;
    }

    public SpConnection getSpConnection() {
        return this.spConnection;
    }

    @Override
    public int getDefaultTimeout() {
        return 60;
    }

    @Override
    public List<SaasParametersValidator> getSaasParametersValidators() {
        return Collections.unmodifiableList(this.saasParametersValidators);
    }

    public void addSaasParametersValidator(SaasParametersValidator saasParametersValidator) {
        this.saasParametersValidators.add(saasParametersValidator);
    }
}

