/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.store;

import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.store.ProvisionableResourceMeta;
import com.pingidentity.provisioner.store.UserStore;
import com.pingidentity.provisioner.store.UserUpdater;
import java.util.Set;

public class UserStoreUpdater
implements UserUpdater {
    private UserStore _userStore;
    private String _directoryServerGuid;
    private String _usernameToMask;
    private Set<String> _persistForMembershipFields;
    private SaasIdentity _saasIdentity;

    public UserStoreUpdater(UserStore userStore, String directoryServerGuid, String usernameToMask) {
        this._userStore = userStore;
        this._directoryServerGuid = directoryServerGuid;
        this._usernameToMask = usernameToMask;
    }

    @Override
    public void clearDirtyFlag() {
        this._userStore.clearDirtyFlag(this._directoryServerGuid);
        if (this._saasIdentity != null && this._persistForMembershipFields != null) {
            this._userStore.setSaasIdentity(this._directoryServerGuid, this._saasIdentity, this._persistForMembershipFields);
        }
    }

    @Override
    public void setSaasGuid(String saasGuid) {
        this._userStore.setSaasGuid(this._directoryServerGuid, saasGuid, this._usernameToMask != null && this._usernameToMask.equals(saasGuid));
    }

    @Override
    public ProvisionableResourceMeta getResourceMetaBySaasUsername(String saasUniqueName) {
        return this._userStore.getUserMetaBySaasUsername(saasUniqueName);
    }

    public void setPersistForMembershipFields(Set<String> persistForMembershipFields) {
        this._persistForMembershipFields = persistForMembershipFields;
    }

    public void setSaasIdentity(SaasIdentity _saasIdentity) {
        this._saasIdentity = _saasIdentity;
    }
}

