/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.store;

import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.mapping.IdentityMapper;
import com.pingidentity.provisioner.monitor.SaasProvisioningEventTracker;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.DuplicateKeyException;
import com.pingidentity.provisioner.store.InvalidProvisioningDataException;
import com.pingidentity.provisioner.store.ProvisionableResourceMeta;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.UserStore;
import java.util.Set;

public class UserStoreWithEventTracking
implements UserStore {
    private int _channelId;
    private UserStore userStore;
    private SaasProvisioningEventTracker _eventTracker;

    public UserStoreWithEventTracking(UserStore us, int chanId, SaasProvisioningEventTracker et) {
        this._channelId = chanId;
        this.userStore = us;
        this._eventTracker = et;
    }

    @Override
    public void clearDirtyFlag(String directoryServerGuid) {
        this.userStore.clearDirtyFlag(directoryServerGuid);
        this._eventTracker.trackEvent(directoryServerGuid, null, SaasProvisioningEventTracker.EventType.UPDATE_USER_INTERNAL, this._channelId, null);
    }

    @Override
    public void create(String directoryServerGuid, SaasIdentity saasIdentity, boolean inProvisioningGroup) throws InvalidProvisioningDataException {
        String targetId = saasIdentity.hasGuid() ? saasIdentity.getGuid() : (saasIdentity.isNameMasked() ? "*****" : saasIdentity.getName());
        try {
            this.userStore.create(directoryServerGuid, saasIdentity, inProvisioningGroup);
        }
        catch (DuplicateKeyException e) {
            this._eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.CREATE_USER_INTERNAL, this._channelId, e);
            throw e;
        }
        this._eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.CREATE_USER_INTERNAL, this._channelId, null);
    }

    @Override
    public int deleteAllUsers() {
        return this.userStore.deleteAllUsers();
    }

    @Override
    public int getDirtyUserCount() {
        return this.userStore.getDirtyUserCount();
    }

    @Override
    public String getSaasUsername(String directoryServerGuid) {
        return this.userStore.getSaasUsername(directoryServerGuid);
    }

    @Override
    public int getUserCount() {
        return this.userStore.getUserCount();
    }

    @Override
    public ProvisionableResourceMeta getUserMetaByDirectoryGuid(String directoryServerGuid) {
        return this.userStore.getUserMetaByDirectoryGuid(directoryServerGuid);
    }

    @Override
    public ProvisionableResourceMeta getUserMetaBySaasUsername(String saasUsername) {
        return this.userStore.getUserMetaBySaasUsername(saasUsername);
    }

    @Override
    public String getValuesHash(String directoryServerGuid) {
        return this.userStore.getValuesHash(directoryServerGuid);
    }

    @Override
    public void loadDirectoryServerGuids(Set<String> inside, Set<String> outside) {
        this.userStore.loadDirectoryServerGuids(inside, outside);
    }

    @Override
    public void processDirty(SaasProvisionableResourceCallback callback, IdentityMapper identityMapper) throws SaasException {
        this.userStore.processDirty(callback, identityMapper);
    }

    @Override
    public void processDirty(SaasProvisionableResourceCallback callback, IdentityMapper identityMapper, Set<String> usersToIgnore) throws SaasException {
        this.userStore.processDirty(callback, identityMapper, usersToIgnore);
    }

    @Override
    public boolean removeIfNotDirty(String directoryServerGuid) {
        boolean success = this.userStore.removeIfNotDirty(directoryServerGuid);
        if (success) {
            this._eventTracker.trackEvent(directoryServerGuid, null, SaasProvisioningEventTracker.EventType.DELETE_USER_INTERNAL, this._channelId, null);
        }
        return success;
    }

    @Override
    public boolean remove(String directoryServerGuid) {
        boolean success = this.userStore.remove(directoryServerGuid);
        if (success) {
            this._eventTracker.trackEvent(directoryServerGuid, null, SaasProvisioningEventTracker.EventType.DELETE_USER_INTERNAL, this._channelId, null);
        }
        return success;
    }

    @Override
    public void resetValuesHash() {
        this.userStore.resetValuesHash();
    }

    @Override
    public void setSaasGuid(String directoryServerGuid, String saasGuid, boolean maskGuid) {
        this.userStore.setSaasGuid(directoryServerGuid, saasGuid, maskGuid);
        String targetId = maskGuid ? "*****" : saasGuid;
        this._eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.UPDATE_USER_INTERNAL, this._channelId, null);
    }

    @Override
    public boolean update(String directoryServerGuid, SaasIdentity saasIdentity) throws InvalidProvisioningDataException {
        boolean success = false;
        String targetId = saasIdentity.hasGuid() ? saasIdentity.getGuid() : (saasIdentity.isNameMasked() ? "*****" : saasIdentity.getName());
        try {
            success = this.userStore.update(directoryServerGuid, saasIdentity);
        }
        catch (DuplicateKeyException e) {
            this._eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.UPDATE_USER_INTERNAL, this._channelId, e);
            throw e;
        }
        if (success) {
            this._eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.UPDATE_USER_INTERNAL, this._channelId, null);
        }
        return success;
    }

    @Override
    public boolean update(String directoryServerGuid, SaasIdentity saasIdentity, boolean inProvisioningGroup) throws InvalidProvisioningDataException {
        boolean success = false;
        String targetId = saasIdentity.hasGuid() ? saasIdentity.getGuid() : (saasIdentity.isNameMasked() ? "*****" : saasIdentity.getName());
        try {
            success = this.userStore.update(directoryServerGuid, saasIdentity, inProvisioningGroup);
        }
        catch (DuplicateKeyException e) {
            this._eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.UPDATE_USER_INTERNAL, this._channelId, e);
            throw e;
        }
        if (success) {
            this._eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.UPDATE_USER_INTERNAL, this._channelId, null);
        }
        return success;
    }

    @Override
    public boolean updateChannel(String directoryServerGuid, SaasIdentity saasIdentity, boolean inProvisioningGroup, int oldChannel) throws InvalidProvisioningDataException {
        boolean success = false;
        String targetId = saasIdentity.hasGuid() ? saasIdentity.getGuid() : (saasIdentity.isNameMasked() ? "*****" : saasIdentity.getName());
        try {
            this.userStore.updateChannel(directoryServerGuid, saasIdentity, inProvisioningGroup, oldChannel);
        }
        catch (DuplicateKeyException e) {
            this._eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.UPDATE_USER_INTERNAL, this._channelId, e);
            throw e;
        }
        if (success) {
            this._eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.UPDATE_USER_INTERNAL, this._channelId, null);
        }
        return success;
    }

    @Override
    public Set<String> getAllUserGuids() {
        return this.userStore.getAllUserGuids();
    }

    @Override
    public void setSaasIdentity(String directoryServerGuid, SaasIdentity saasIdentity, Set<String> fields) {
        this.userStore.setSaasIdentity(directoryServerGuid, saasIdentity, fields);
        String targetId = saasIdentity.hasGuid() ? saasIdentity.getGuid() : (saasIdentity.isNameMasked() ? "*****" : saasIdentity.getName());
        this._eventTracker.trackEvent(directoryServerGuid, targetId, SaasProvisioningEventTracker.EventType.UPDATE_USER_INTERNAL, this._channelId, null);
    }
}

