/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.store.jdbc;

import com.pingidentity.common.util.TinyHashSet;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.groups.GroupMembershipStore;
import com.pingidentity.provisioner.store.groups.GroupStoreException;
import com.pingidentity.provisioner.store.jdbc.JdbcGroupStore;
import com.pingidentity.provisioner.store.jdbc.JdbcUserStore;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class JdbcGroupMembershipStore
implements GroupMembershipStore {
    private static final Logger LOG = LogManager.getLogger(JdbcGroupMembershipStore.class);
    private static final String BATCH_INSERT_STMT = "INSERT INTO group_membership (channel,groupDsGuid,userDsGuid,subGroupDsGuid) VALUES (?,?,?,?)";
    private static final String BATCH_INSERT_STMT_NO_SUBGROUP = "INSERT INTO group_membership (channel,groupDsGuid,userDsGuid) VALUES (?,?,?)";
    private static final String DELETE_STMT = "DELETE FROM group_membership WHERE channel=? AND groupDsGuid=?";
    private static final ConfigStore CONFIG = ConfigStoreFarm.getConfig((String)"provisioner-jdbc-settings");
    private static final int COMMIT_THRESHOLD;
    private static final int BATCH_SIZE;
    public static final String TABLE_NAME = "group_membership";
    public static final String SUB_GROUP_COLUMN_NAME = "subGroupDsGuid";
    private final JdbcTemplate jdbcTpl;
    private final int channel;
    private final HashSet<MembershipMapping> cachedMappings = new HashSet();
    private final boolean hasSubGroupColumn;

    public JdbcGroupMembershipStore(DataSource dataSource, int channel, boolean hasSubGroupCol) {
        this.jdbcTpl = new JdbcTemplate(dataSource);
        this.channel = channel;
        this.hasSubGroupColumn = hasSubGroupCol;
    }

    @Override
    public void addUserMembership(String groupGuid, String userGuid) throws GroupStoreException {
        this.cachedMappings.add(new MembershipMapping(groupGuid, userGuid, null));
        if (this.cachedMappings.size() >= COMMIT_THRESHOLD) {
            this.commit();
        }
    }

    @Override
    public void addSubGroupMembership(String groupGuid, String subGroupGuid) throws GroupStoreException {
        if (!this.hasSubGroupColumn) {
            LOG.warn("Unable to add group '" + subGroupGuid + "' as a member of group '" + groupGuid + "'. Ensure your provisioner database has been updated to the latest schema.");
            return;
        }
        this.cachedMappings.add(new MembershipMapping(groupGuid, null, subGroupGuid));
        if (this.cachedMappings.size() >= COMMIT_THRESHOLD) {
            this.commit();
        }
    }

    @Override
    public void deleteMembership(String groupGuid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing group membership for: " + groupGuid);
        }
        this.jdbcTpl.update(DELETE_STMT, new Object[]{this.channel, groupGuid});
    }

    @Override
    public Iterator<SaasIdentity> getUserMembers(String groupDsGuid, Set<String> identityMaskedFields) {
        this.ensureEmptyCache();
        return new LazyUserMembersIterator(this.jdbcTpl, this.channel, groupDsGuid, identityMaskedFields);
    }

    @Override
    public Iterator<SaasGroup> getSubGroupMembers(String groupDsGuid) {
        this.ensureEmptyCache();
        if (!this.hasSubGroupColumn) {
            return Collections.emptyIterator();
        }
        return new LazySubGroupMembersIterator(this.jdbcTpl, this.channel, groupDsGuid);
    }

    @Override
    public Iterator<SaasGroup> getGroupsForUser(String userDsGuid) {
        this.ensureEmptyCache();
        return new LazyGroupsForUserIterator(this.jdbcTpl, this.channel, userDsGuid);
    }

    @Override
    public Iterator<SaasGroup> getGroupsForSubGroup(String subGroupDsGuid) {
        this.ensureEmptyCache();
        if (!this.hasSubGroupColumn) {
            return Collections.emptyIterator();
        }
        return new LazyGroupsForSubGroupIterator(this.jdbcTpl, this.channel, subGroupDsGuid);
    }

    @Override
    public void commit() throws GroupStoreException {
        if (this.cachedMappings.isEmpty()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting commit");
        }
        while (this.cachedMappings.size() > 0) {
            int batchSize = Math.min(BATCH_SIZE, this.cachedMappings.size());
            TinyHashSet availableUsers = new TinyHashSet(batchSize, 1.0f);
            TinyHashSet availableSubGroups = new TinyHashSet(256);
            this.queryMembers(batchSize, (TinyHashSet<String>)availableUsers, (TinyHashSet<String>)availableSubGroups);
            final ArrayList<Object[]> insertArgs = new ArrayList<Object[]>(batchSize);
            Iterator<MembershipMapping> mappingIterator = this.cachedMappings.iterator();
            while (mappingIterator.hasNext() && insertArgs.size() < batchSize) {
                MembershipMapping mapping = mappingIterator.next();
                boolean isUserMapping = mapping.isUserMembershipMapping();
                if (isUserMapping && availableUsers.contains((Object)mapping.getUserGuid())) {
                    insertArgs.add(new Object[]{this.channel, mapping.getGroupGuid(), mapping.getUserGuid(), null});
                }
                if (!isUserMapping && availableSubGroups.contains((Object)mapping.getSubGroupGuid())) {
                    insertArgs.add(new Object[]{this.channel, mapping.getGroupGuid(), null, mapping.getSubGroupGuid()});
                }
                mappingIterator.remove();
            }
            if (insertArgs.size() <= 0) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting batch insert of " + insertArgs.size() + " rows");
            }
            this.jdbcTpl.batchUpdate(this.hasSubGroupColumn ? BATCH_INSERT_STMT : BATCH_INSERT_STMT_NO_SUBGROUP, new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement stmt, int i) throws SQLException {
                    Object[] currentArgs = (Object[])insertArgs.get(i);
                    stmt.setInt(1, (Integer)currentArgs[0]);
                    stmt.setString(2, (String)currentArgs[1]);
                    stmt.setString(3, (String)currentArgs[2]);
                    if (JdbcGroupMembershipStore.this.hasSubGroupColumn) {
                        stmt.setString(4, (String)currentArgs[3]);
                    }
                }

                public int getBatchSize() {
                    return insertArgs.size();
                }
            });
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished commit");
        }
    }

    private void queryMembers(int batchSize, TinyHashSet<String> availableUsers, TinyHashSet<String> availableSubGroups) {
        RowCallbackHandler queryUserCallback = rs -> {
            String userGuid = rs.getString(1);
            availableUsers.add((Object)userGuid);
        };
        RowCallbackHandler queryGroupCallback = rs -> {
            String groupGuid = rs.getString(1);
            availableSubGroups.add((Object)groupGuid);
        };
        StringBuilder userSqlBuilder = new StringBuilder(batchSize * 32 * 2);
        StringBuilder subGroupSqlBuilder = new StringBuilder(16384);
        Iterator<MembershipMapping> mappingIterator = this.cachedMappings.iterator();
        boolean queryUsers = false;
        boolean querySubGroups = false;
        userSqlBuilder.append("SELECT dsGuid FROM channel_user where channel=? AND dsGuid IN (");
        subGroupSqlBuilder.append("SELECT dsGuid FROM channel_group where channel=? AND dsGuid IN (");
        for (int posIndex = 0; mappingIterator.hasNext() && posIndex < batchSize; ++posIndex) {
            MembershipMapping memberMapping = mappingIterator.next();
            if (memberMapping.isUserMembershipMapping()) {
                if (queryUsers) {
                    userSqlBuilder.append(',');
                }
                userSqlBuilder.append('\'');
                userSqlBuilder.append(memberMapping.getUserGuid());
                userSqlBuilder.append('\'');
                queryUsers = true;
                continue;
            }
            if (querySubGroups) {
                subGroupSqlBuilder.append(',');
            }
            subGroupSqlBuilder.append('\'');
            subGroupSqlBuilder.append(memberMapping.getSubGroupGuid());
            subGroupSqlBuilder.append('\'');
            querySubGroups = true;
        }
        userSqlBuilder.append(')');
        subGroupSqlBuilder.append(')');
        if (queryUsers) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Querying successful user members from channel_user");
            }
            this.jdbcTpl.query(userSqlBuilder.toString(), queryUserCallback, new Object[]{this.channel});
        }
        if (querySubGroups) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Querying successful sub group members from channel_group");
            }
            this.jdbcTpl.query(subGroupSqlBuilder.toString(), queryGroupCallback, new Object[]{this.channel});
        }
    }

    private void ensureEmptyCache() {
        if (!this.cachedMappings.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public Iterator<String> getMemberDsGuids(String groupDsGuid) {
        this.ensureEmptyCache();
        return new LazyMemberDsGuidsIterator(this.jdbcTpl, this.channel, groupDsGuid, this.hasSubGroupColumn);
    }

    @Override
    public boolean hasNewSubGroupMembers(String groupDsGuid) {
        this.ensureEmptyCache();
        if (!this.hasSubGroupColumn) {
            return false;
        }
        String selectNewSubGroups = "SELECT group_membership.subGroupDsGuid FROM group_membership INNER JOIN channel_group ON group_membership.channel = channel_group.channel AND group_membership.subGroupDsGuid = channel_group.dsGuid WHERE group_membership.channel=? AND group_membership.groupDsGuid=? AND group_membership.subGroupDsGuid IS NOT NULL AND channel_group.dirty=?";
        SqlRowSet rowSet = this.jdbcTpl.queryForRowSet(selectNewSubGroups, new Object[]{this.channel, groupDsGuid, 1});
        return rowSet.next();
    }

    @Override
    public Iterator<SaasGroup> getExistingSubGroupMembers(String groupDsGuid) {
        this.ensureEmptyCache();
        if (!this.hasSubGroupColumn) {
            return Collections.emptyIterator();
        }
        return new LazyExistingSubGroupMembersIterator(this.jdbcTpl, this.channel, groupDsGuid);
    }

    static {
        int tempCommitThreshold = 500;
        int tempBatchSize = 500;
        try {
            tempCommitThreshold = CONFIG.getIntValue("MembershipCommitThreshold");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tempBatchSize = CONFIG.getIntValue("MembershipBatchSize");
        }
        catch (Exception exception) {
            // empty catch block
        }
        COMMIT_THRESHOLD = tempCommitThreshold;
        BATCH_SIZE = tempBatchSize;
    }

    private static class MembershipMapping {
        private final String groupGuid;
        private final String userGuid;
        private final String subGroupGuid;

        public MembershipMapping(String groupGuid, String userGuid, String subGroupGuid) {
            this.groupGuid = groupGuid;
            this.userGuid = userGuid;
            this.subGroupGuid = subGroupGuid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.groupGuid == null ? 0 : this.groupGuid.hashCode());
            result = 31 * result + (this.subGroupGuid == null ? 0 : this.subGroupGuid.hashCode());
            result = 31 * result + (this.userGuid == null ? 0 : this.userGuid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MembershipMapping other = (MembershipMapping)obj;
            if (this.groupGuid == null ? other.groupGuid != null : !this.groupGuid.equals(other.groupGuid)) {
                return false;
            }
            if (this.subGroupGuid == null ? other.subGroupGuid != null : !this.subGroupGuid.equals(other.subGroupGuid)) {
                return false;
            }
            if (this.userGuid == null) {
                return other.userGuid == null;
            }
            return this.userGuid.equals(other.userGuid);
        }

        public String getUserGuid() {
            return this.userGuid;
        }

        public String getGroupGuid() {
            return this.groupGuid;
        }

        public String getSubGroupGuid() {
            return this.subGroupGuid;
        }

        public boolean isUserMembershipMapping() {
            return this.userGuid != null;
        }
    }

    private static class LazyGroupsForSubGroupIterator
    extends AbstractLazyQueryIterator<SaasGroup> {
        private static final String SELECT_STMT = "SELECT group_membership.groupDsGuid,channel_group.saasGuid,channel_group.saasGroup, channel_group.inGroup FROM group_membership INNER JOIN channel_group ON group_membership.channel = channel_group.channel AND group_membership.groupDsGuid = channel_group.dsGuid WHERE group_membership.channel=? AND group_membership.subGroupDsGuid=?";

        public LazyGroupsForSubGroupIterator(JdbcTemplate jdbcTemplate, int channel, String guid) {
            super(jdbcTemplate, channel, guid);
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public SaasGroup processResult(SqlRowSet rowSet) {
            String groupDsGuid = rowSet.getString(1);
            String saasGroupGuid = rowSet.getString(2);
            String saasGroupString = rowSet.getString(3);
            boolean inGroup = rowSet.getBoolean(4);
            return JdbcGroupStore.string2SaasGroup(saasGroupString, saasGroupGuid, groupDsGuid, inGroup);
        }

        @Override
        public String getSelectQuery() {
            return SELECT_STMT;
        }
    }

    private static class LazyGroupsForUserIterator
    extends AbstractLazyQueryIterator<SaasGroup> {
        private static final String SELECT_STMT = "SELECT group_membership.groupDsGuid,channel_group.saasGuid,channel_group.saasGroup, channel_group.inGroup FROM group_membership INNER JOIN channel_group ON group_membership.channel = channel_group.channel AND group_membership.groupDsGuid = channel_group.dsGuid WHERE group_membership.channel=? AND group_membership.userDsGuid=?";

        public LazyGroupsForUserIterator(JdbcTemplate jdbcTemplate, int channel, String guid) {
            super(jdbcTemplate, channel, guid);
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public SaasGroup processResult(SqlRowSet rowSet) {
            String groupDsGuid = rowSet.getString(1);
            String saasGroupGuid = rowSet.getString(2);
            String saasGroupString = rowSet.getString(3);
            boolean inGroup = rowSet.getBoolean(4);
            return JdbcGroupStore.string2SaasGroup(saasGroupString, saasGroupGuid, groupDsGuid, inGroup);
        }

        @Override
        public String getSelectQuery() {
            return SELECT_STMT;
        }
    }

    private static class LazyMemberDsGuidsIterator
    extends AbstractLazyQueryIterator<String> {
        private static final String SELECT_STMT = "SELECT userDsGuid,subGroupDsGuid FROM group_membership WHERE channel=? AND groupDsGuid=? ORDER BY userDsGuid,subGroupDsGuid";
        private static final String SELECT_STMT_NO_SUBGROUP = "SELECT userDsGuid FROM group_membership WHERE channel=? AND groupDsGuid=? ORDER BY userDsGuid";
        private final boolean hasSubGroupColumn;

        public LazyMemberDsGuidsIterator(JdbcTemplate jdbcTemplate, int channel, String guid, boolean hasSubGroupCol) {
            super(jdbcTemplate, channel, guid);
            this.hasSubGroupColumn = hasSubGroupCol;
        }

        @Override
        public String processResult(SqlRowSet rowSet) {
            String memberGuid = rowSet.getString(1);
            if (memberGuid == null && this.hasSubGroupColumn) {
                memberGuid = rowSet.getString(2);
            }
            return memberGuid;
        }

        @Override
        public String getSelectQuery() {
            if (this.hasSubGroupColumn) {
                return SELECT_STMT;
            }
            return SELECT_STMT_NO_SUBGROUP;
        }
    }

    private static class LazyExistingSubGroupMembersIterator
    extends AbstractLazyQueryIterator<SaasGroup> {
        private static final String SELECT_STMT = "SELECT group_membership.subGroupDsGuid,channel_group.saasGuid,channel_group.saasGroup, channel_group.inGroup FROM group_membership INNER JOIN channel_group ON group_membership.channel = channel_group.channel AND group_membership.subGroupDsGuid = channel_group.dsGuid WHERE group_membership.channel=? AND group_membership.groupDsGuid=? AND group_membership.subGroupDsGuid IS NOT NULL AND channel_group.dirty!=1";

        public LazyExistingSubGroupMembersIterator(JdbcTemplate jdbcTemplate, int channel, String guid) {
            super(jdbcTemplate, channel, guid);
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public SaasGroup processResult(SqlRowSet rowSet) throws SaasException {
            String subGroupDsGuid = rowSet.getString(1);
            String saasGroupGuid = rowSet.getString(2);
            String saasGroupString = rowSet.getString(3);
            boolean inGroup = rowSet.getBoolean(4);
            return JdbcGroupStore.string2SaasGroup(saasGroupString, saasGroupGuid, subGroupDsGuid, inGroup);
        }

        @Override
        public String getSelectQuery() {
            return SELECT_STMT;
        }
    }

    private static class LazySubGroupMembersIterator
    extends AbstractLazyQueryIterator<SaasGroup> {
        private static final String SELECT_STMT = "SELECT group_membership.subGroupDsGuid,channel_group.saasGuid,channel_group.saasGroup, channel_group.inGroup FROM group_membership INNER JOIN channel_group ON group_membership.channel = channel_group.channel AND group_membership.subGroupDsGuid = channel_group.dsGuid WHERE group_membership.channel=? AND group_membership.groupDsGuid=? AND group_membership.subGroupDsGuid IS NOT NULL";

        public LazySubGroupMembersIterator(JdbcTemplate jdbcTemplate, int channel, String guid) {
            super(jdbcTemplate, channel, guid);
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public SaasGroup processResult(SqlRowSet rowSet) throws SaasException {
            String subGroupDsGuid = rowSet.getString(1);
            String saasGroupGuid = rowSet.getString(2);
            String saasGroupString = rowSet.getString(3);
            boolean inGroup = rowSet.getBoolean(4);
            return JdbcGroupStore.string2SaasGroup(saasGroupString, saasGroupGuid, subGroupDsGuid, inGroup);
        }

        @Override
        public String getSelectQuery() {
            return SELECT_STMT;
        }
    }

    private static class LazyUserMembersIterator
    extends AbstractLazyQueryIterator<SaasIdentity> {
        private static final String SELECT_STMT = "SELECT group_membership.userDsGuid,channel_user.saasGuid,channel_user.saasIdentity, channel_user.inGroup FROM group_membership INNER JOIN channel_user ON group_membership.channel = channel_user.channel AND group_membership.userDsGuid = channel_user.dsGuid WHERE group_membership.channel=? AND group_membership.groupDsGuid=? AND group_membership.userDsGuid IS NOT NULL";
        private final Set<String> identityMaskedFields;

        public LazyUserMembersIterator(JdbcTemplate jdbcTemplate, int channel, String guid, Set<String> identityMaskedFields) {
            super(jdbcTemplate, channel, guid);
            this.identityMaskedFields = identityMaskedFields;
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public SaasIdentity processResult(SqlRowSet rowSet) throws SaasException {
            String userDsGuid = rowSet.getString(1);
            String saasUserGuid = rowSet.getString(2);
            String saasIdentityString = rowSet.getString(3);
            boolean inGroup = rowSet.getBoolean(4);
            return JdbcUserStore.string2SaasIdentity(saasIdentityString, saasUserGuid, userDsGuid, inGroup, this.identityMaskedFields);
        }

        @Override
        public String getSelectQuery() {
            return SELECT_STMT;
        }
    }

    private static abstract class AbstractLazyQueryIterator<E>
    implements Iterator<E> {
        private final Logger LOG = LogManager.getLogger(AbstractLazyQueryIterator.class);
        private final String guid;
        private final int channel;
        private final JdbcTemplate jdbcTpl;
        private SqlRowSet rowSet = null;
        private boolean hasNext = false;
        private boolean done = false;
        private E nextVal = null;

        public AbstractLazyQueryIterator(JdbcTemplate jdbcTemplate, int channel, String guid) {
            this.jdbcTpl = jdbcTemplate;
            this.channel = channel;
            this.guid = guid;
        }

        @Override
        public boolean hasNext() {
            if (this.rowSet == null) {
                this.initRowSet();
            }
            if (this.hasNext) {
                return true;
            }
            if (!this.done) {
                while (this.hasNext = this.rowSet.next()) {
                    try {
                        this.nextVal = this.processResult(this.rowSet);
                        break;
                    }
                    catch (SaasException e) {
                        this.LOG.error("Failed to read entry, moving on to next", (Throwable)e);
                    }
                }
                if (!this.hasNext) {
                    this.done = true;
                }
                return this.hasNext;
            }
            return false;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                this.hasNext = false;
                return this.nextVal;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void initRowSet() {
            this.rowSet = this.jdbcTpl.queryForRowSet(this.getSelectQuery(), new Object[]{this.channel, this.guid});
        }

        public abstract E processResult(SqlRowSet var1) throws SaasException;

        public abstract String getSelectQuery();
    }
}

