/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.store.jdbc;

import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.ProvisionerNodeRole;
import com.pingidentity.provisioner.cluster.ProvisionerNodeState;
import com.pingidentity.provisioner.store.jdbc.NodeStateException;
import com.pingidentity.provisioner.store.jdbc.ProvisionerNodeStateDataManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class JdbcProvisionerNodeStateDataManager
implements ProvisionerNodeStateDataManager {
    private JdbcTemplate _jdbcTemplate;
    private static Logger _logger = LogManager.getLogger(JdbcProvisionerNodeStateDataManager.class);

    public JdbcProvisionerNodeStateDataManager(DataSource dataSource) {
        try {
            this._jdbcTemplate = new JdbcTemplate(dataSource);
        }
        catch (Throwable e) {
            throw new NodeStateException("Cannot initialize provisioner node state data manager!", e);
        }
    }

    @Override
    public void registerNode(int nodeId) throws ClusteringException {
        String sql = "INSERT INTO node_state (nodeId, role, heartbeat) VALUES (?,?,?)";
        int rows = this._jdbcTemplate.update(sql, new Object[]{nodeId, ProvisionerNodeRole.backup.toString(), this.now()});
        if (rows != 1) {
            throw new ClusteringException("Insert failed: " + sql);
        }
    }

    @Override
    public void updateHeartBeat(int nodeId, ProvisionerNodeRole expectedRole) throws ClusteringException {
        int rows;
        String sql;
        if (ProvisionerNodeRole.active == expectedRole) {
            sql = "UPDATE node_state SET heartbeat=? WHERE nodeId=? AND role=?";
            rows = this._jdbcTemplate.update(sql, new Object[]{this.now(), nodeId, expectedRole.toString()});
        } else {
            sql = "UPDATE node_state SET role=?, heartbeat=? WHERE nodeId=?";
            rows = this._jdbcTemplate.update(sql, new Object[]{ProvisionerNodeRole.backup.toString(), this.now(), nodeId});
        }
        if (rows != 1) {
            ProvisionerNodeRole existingRole = (ProvisionerNodeRole)((Object)this._jdbcTemplate.queryForObject("SELECT role FROM node_state WHERE nodeId=?", (RowMapper)new RowMapper<ProvisionerNodeRole>(){

                public ProvisionerNodeRole mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return ProvisionerNodeRole.valueOf(rs.getString(1));
                }
            }, new Object[]{nodeId}));
            if (existingRole != expectedRole) {
                throw new ClusteringException("Bad node state! Expected: " + expectedRole + ", found: " + existingRole);
            }
            throw new ClusteringException("Update failed: " + sql);
        }
    }

    @Override
    public void updateHeartBeatConditionally(int nodeId, Instant expectedHeartbeat) throws ClusteringException {
        String sql = "UPDATE node_state SET heartbeat=? WHERE nodeId=? AND heartbeat=?";
        int rows = this._jdbcTemplate.update(sql, new Object[]{this.now(), nodeId, new Timestamp(expectedHeartbeat.toEpochMilli())});
        if (rows != 1) {
            throw new ClusteringException("Update failed: " + sql);
        }
    }

    @Override
    public void setActiveNode(int nodeId) throws ClusteringException {
        String sql = "UPDATE node_state SET role=? WHERE role=?";
        this._jdbcTemplate.update(sql, new Object[]{ProvisionerNodeRole.dead.toString(), ProvisionerNodeRole.active.toString()});
        sql = "UPDATE node_state SET role=?, heartbeat=? WHERE nodeId=?";
        int rows = this._jdbcTemplate.update(sql, new Object[]{ProvisionerNodeRole.active.toString(), this.now(), nodeId});
        if (rows != 1) {
            throw new ClusteringException("Update failed: " + sql);
        }
    }

    @Override
    public void setRole(int nodeId, ProvisionerNodeRole role) throws ClusteringException {
        String sql = "UPDATE node_state SET role=?, heartbeat=? WHERE nodeId=?";
        int rows = this._jdbcTemplate.update(sql, new Object[]{role.toString(), this.now(), nodeId});
        if (rows != 1) {
            throw new ClusteringException("Update failed: " + sql);
        }
    }

    @Override
    public List<ProvisionerNodeState> getAllServerStates() {
        List<ProvisionerNodeState> nodes = this.getProvisionerServerStateList();
        Collections.sort(nodes);
        return nodes;
    }

    @Override
    public ProvisionerNodeState getNodeState(int nodeId) {
        String sql = "SELECT nodeId, role, heartbeat FROM node_state WHERE nodeId=?";
        RowMapper rm = (resultSet, rowNum) -> this.buildProvisionerNodeStateFromResultSet(resultSet);
        try {
            return (ProvisionerNodeState)this._jdbcTemplate.queryForObject(sql, rm, new Object[]{nodeId});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public void deleteNodes(List<Integer> nodeIds) {
        String sql = "DELETE FROM node_state WHERE nodeId IN (%s)";
        String deleteStatement = String.format(sql, StringUtils.join((Object[])nodeIds.toArray(), (String)", "));
        try {
            this._jdbcTemplate.update(deleteStatement);
        }
        catch (DataAccessException e) {
            _logger.debug("There was an error deleting nodes: " + deleteStatement, (Throwable)e);
        }
    }

    private Timestamp now() {
        return new Timestamp(Instant.now().toEpochMilli());
    }

    private List<ProvisionerNodeState> getProvisionerServerStateList() {
        String sql = "SELECT nodeId, role, heartbeat FROM node_state ORDER BY nodeId";
        RowMapper rm = (resultSet, rowNum) -> {
            try {
                return this.buildProvisionerNodeStateFromResultSet(resultSet);
            }
            catch (SQLException e) {
                throw new NodeStateException("Cannot map note state row!", e);
            }
        };
        return this._jdbcTemplate.query(sql, rm);
    }

    private ProvisionerNodeState buildProvisionerNodeStateFromResultSet(ResultSet resultSet) throws SQLException {
        return new ProvisionerNodeState(resultSet.getInt(1), ProvisionerNodeRole.valueOf(resultSet.getString(2)), Instant.ofEpochMilli(resultSet.getTimestamp(3).getTime()));
    }
}

