/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.store.jdbc;

import com.pingidentity.provisioner.store.BaseVariableStore;
import com.pingidentity.provisioner.store.StoreError;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcVariableStore
extends BaseVariableStore {
    private int _channelId;
    private JdbcTemplate _jdbcTpl;

    public JdbcVariableStore(DataSource dataSource, int channelId) {
        this._channelId = channelId;
        this._jdbcTpl = new JdbcTemplate(dataSource);
    }

    @Override
    public boolean hasVariable(String name) {
        String sql = "SELECT COUNT(*) FROM channel_variable WHERE channel=? AND name=?";
        Object[] objects = new Object[]{this._channelId, name};
        Integer result = (Integer)this._jdbcTpl.queryForObject(sql, objects, Integer.TYPE);
        int cnt = 0;
        if (result != null) {
            cnt = result;
        }
        if (cnt > 1) {
            throw new StoreError("Multiple instances of variable: " + name + ", in channel: " + this._channelId);
        }
        return cnt == 1;
    }

    @Override
    public String getStringVariable(String name) {
        if (this.hasVariable(name)) {
            return (String)this._jdbcTpl.queryForObject("SELECT value FROM channel_variable WHERE channel=? AND name=?", String.class, new Object[]{this._channelId, name});
        }
        return null;
    }

    @Override
    public void setStringVariable(String name, String value) {
        if (this.hasVariable(name)) {
            this._jdbcTpl.update("UPDATE channel_variable SET value=? WHERE channel=? AND name=?", new Object[]{value, this._channelId, name});
        } else {
            this._jdbcTpl.update("INSERT INTO channel_variable (channel, name, value) VALUES (?, ?, ?)", new Object[]{this._channelId, name, value});
        }
    }

    @Override
    public int deleteVariable(String name) {
        return this._jdbcTpl.update("DELETE FROM channel_variable WHERE channel=? AND name=?", new Object[]{this._channelId, name});
    }

    @Override
    public int deleteAllVariables() {
        return this._jdbcTpl.update("DELETE FROM channel_variable WHERE channel=?", new Object[]{this._channelId});
    }
}

