/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LDAPTimestamp {
    private static Logger _logger = LogManager.getLogger(LDAPTimestamp.class);

    public static Date toDate(String ldapTimestampIn) {
        try {
            SimpleDateFormat dateFormat;
            String ldapTimestamp = ldapTimestampIn.trim();
            boolean zuluTimeZone = ldapTimestamp.endsWith("Z");
            if (zuluTimeZone) {
                ldapTimestamp = ldapTimestamp.substring(0, ldapTimestamp.length() - 1);
            }
            SimpleDateFormat simpleDateFormat = dateFormat = ldapTimestamp.indexOf(46) != -1 ? new SimpleDateFormat("yyyyMMddHHmmss.SSS") : new SimpleDateFormat("yyyyMMddHHmmss");
            if (zuluTimeZone) {
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
            return dateFormat.parse(ldapTimestamp);
        }
        catch (ParseException e) {
            _logger.error("Cannot parse LDAP timestamp: " + ldapTimestampIn, (Throwable)e);
            return null;
        }
    }

    public static String toString(Date timestamp, boolean gmtFormat) {
        SimpleDateFormat _ldapDateFormatMills = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        if (gmtFormat) {
            _ldapDateFormatMills.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        Object timestampString = _ldapDateFormatMills.format(timestamp);
        if (gmtFormat) {
            timestampString = (String)timestampString + "Z";
        }
        return timestampString;
    }
}

