/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.xml;

import com.pingidentity.common.util.DiffUtil;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.configservice.SysInfoHelper;
import com.pingidentity.provisioner.ProvisionerPluginNotFoundException;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.ProvisionerGlobalSettings;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.xml.util.ChannelUtil;
import com.pingidentity.provisioner.xml.util.SaasDriverUtil;
import com.pingidentity.provisioner.xml.util.ScimUtil;
import com.pingidentity.x2008.x06.saasProvisioner.ChannelType;
import com.pingidentity.x2008.x06.saasProvisioner.SaasProvisionerDocument;
import com.pingidentity.x2008.x06.saasProvisioner.SaasProvisionerEntityType;
import com.pingidentity.x2008.x06.saasProvisioner.SaasProvisionerType;
import com.pingidentity.x2008.x06.saasProvisioner.TargetType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.sourceid.config.ConfigurationException;
import org.sourceid.saml20.domain.scim.model.Schema;
import org.w3c.dom.Node;

public class ConfigHandler {
    private static final String CONFIG_VERSION = "1.0";
    private Logger log = LogManager.getLogger(this.getClass());
    private String CONFIG_LOCATION = SysInfoHelper.getSysDirInfo().getDataDirectory() + "/module";
    private static final String CONFIG_NAME = "saas-provisioner.xml";
    private SaasProvisionerDocument provisionerDoc = null;

    public ConfigHandler() {
        this(null);
    }

    public ConfigHandler(String configLocation) {
        if (configLocation != null) {
            this.CONFIG_LOCATION = configLocation;
        }
        this.provisionerDoc = this.loadProvisionerConfigDoc();
        XmlOptions validateOptions = new XmlOptions();
        ArrayList errors = new ArrayList();
        validateOptions.setErrorListener(errors);
        if (!this.provisionerDoc.validate(validateOptions)) {
            StringBuilder out = new StringBuilder("Config file failed schema validation: ");
            File configFile = new File(this.CONFIG_LOCATION, CONFIG_NAME);
            out.append(configFile.getAbsolutePath()).append('\n');
            for (XmlError error : errors) {
                out.append("\tMessage: ").append(error.getMessage()).append('\n');
                out.append("\tLocation: ").append(error.getCursorLocation().xmlText()).append('\n');
                out.append('\n');
            }
            this.log.error(out.toString());
        }
    }

    public SaasProvisionerDocument loadProvisionerConfigDoc() {
        File configFile = new File(this.CONFIG_LOCATION, CONFIG_NAME);
        if (configFile.exists()) {
            try {
                return SaasProvisionerDocument.Factory.parse((File)configFile);
            }
            catch (XmlException e) {
                throw new ConfigurationException("Invalid configuration file: " + configFile.getAbsolutePath(), (Throwable)e);
            }
            catch (IOException e) {
                throw new ConfigurationException("Invalid configuration file: " + configFile.getAbsolutePath(), (Throwable)e);
            }
        }
        throw new ConfigurationException("Missing configuration file: " + configFile.getAbsolutePath());
    }

    public ProvisionerConfig getProvisionerConfig(String entityId) throws SaasException {
        ProvisionerConfig provConfig = null;
        if (this.provisionerDoc != null) {
            provConfig = ConfigHandler.getProvisionerConfig(this.provisionerDoc, entityId);
        }
        return provConfig;
    }

    public ProvisionerConfig getProvisionerConfigFromXML(String xmlData) throws SaasException {
        ProvisionerConfig config = null;
        try {
            Node node = XmlBeansUtil.parseToNode((String)xmlData);
            SaasProvisionerDocument doc = SaasProvisionerDocument.Factory.parse((Node)node);
            if (doc.validate()) {
                SaasProvisionerType provisionerType = doc.getSaasProvisioner();
                String entityId = provisionerType.getSaasProvisionerEntityArray(0).getEntityId();
                config = ConfigHandler.getProvisionerConfig(doc, entityId);
            } else {
                this.log.error("Provisioner Config from xml was invalid. Configuration not created.");
            }
        }
        catch (XmlException e) {
            this.log.error("Error while parsing Provisioner Config from xml. Configuration not created. " + e.getMessage());
        }
        return config;
    }

    public static ProvisionerConfig getProvisionerConfig(SaasProvisionerDocument doc, String entityId) throws SaasException {
        ProvisionerConfig provConfig = new ProvisionerConfig(entityId);
        SaasProvisionerType provisionerType = doc.getSaasProvisioner();
        for (SaasProvisionerEntityType e : provisionerType.getSaasProvisionerEntityArray()) {
            if (e == null || e.getEntityId() == null || !e.getEntityId().equals(entityId)) continue;
            TargetType targetType = e.getTarget();
            SaasTarget target = SaasDriverUtil.constructSaasTarget(targetType);
            provConfig.setTarget(target);
            provConfig.setType(target.getPluginId());
            if (e.getScim() != null) {
                Schema domainSchema = ScimUtil.getDomainSchema(e.getScim());
                provConfig.setCustomScim(domainSchema);
            }
            for (ChannelType c : e.getChannelArray()) {
                Channel channel = ChannelUtil.constructChannel(c);
                channel.setActive(c.getActive());
                provConfig.addChannel(channel);
            }
        }
        if (provConfig.getChannels().size() == 0) {
            provConfig = null;
        }
        return provConfig;
    }

    public static String channelId2EntityId(SaasProvisionerDocument doc, int channelId) {
        SaasProvisionerType provisionerType = doc.getSaasProvisioner();
        for (SaasProvisionerEntityType e : provisionerType.getSaasProvisionerEntityArray()) {
            for (ChannelType c : e.getChannelArray()) {
                if (channelId != Integer.parseInt(c.getId())) continue;
                return e.getEntityId();
            }
        }
        return null;
    }

    public static List<String> getEntityIdList(SaasProvisionerDocument provisionerDoc) {
        ArrayList<String> entityIdList = new ArrayList<String>();
        if (provisionerDoc != null) {
            SaasProvisionerType provisionerType = provisionerDoc.getSaasProvisioner();
            for (SaasProvisionerEntityType e : provisionerType.getSaasProvisionerEntityArray()) {
                entityIdList.add(e.getEntityId());
            }
        }
        return entityIdList;
    }

    public Map<String, ProvisionerConfig> getProvisionerConfigMap() {
        HashMap<String, ProvisionerConfig> map = new HashMap<String, ProvisionerConfig>();
        try {
            for (String entityId : ConfigHandler.getEntityIdList(this.provisionerDoc)) {
                map.put(entityId, this.getProvisionerConfig(entityId));
            }
        }
        catch (SaasException e) {
            this.log.error("Error in loading provisioner config file.", (Throwable)e);
            map = new HashMap();
        }
        return map;
    }

    public SaasProvisionerDocument getProvisionerConfigAsDocument(ProvisionerConfig provisionerConfig) {
        SaasProvisionerDocument doc = SaasProvisionerDocument.Factory.newInstance();
        SaasProvisionerType provisionerType = doc.addNewSaasProvisioner();
        provisionerType.setVersion(CONFIG_VERSION);
        try {
            ConfigHandler.loadProvisionerType(provisionerConfig, provisionerType);
        }
        catch (ProvisionerPluginNotFoundException ex) {
            this.log.error("Unable to get provisioner config with entity ID: " + provisionerConfig.getEntityId(), (Throwable)ex);
        }
        return doc;
    }

    public void save(ProvisionerGlobalSettings globalSettings, Map<String, ProvisionerConfig> map) {
        try {
            this.writeOutXmlDocToDisk(ConfigHandler.convertToDocument(globalSettings, map));
        }
        catch (ProvisionerPluginNotFoundException ex) {
            this.log.error("Unable to save changes for provisioner", (Throwable)ex);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="introduced by java 11 language level change")
    public void touchConfig() {
        Date now = new Date();
        File configFile = new File(this.CONFIG_LOCATION, CONFIG_NAME);
        configFile.setLastModified(now.getTime());
    }

    public static SaasProvisionerDocument convertToDocument(ProvisionerGlobalSettings globalSettings, Map<String, ProvisionerConfig> map) throws ProvisionerPluginNotFoundException {
        SaasProvisionerDocument doc = SaasProvisionerDocument.Factory.newInstance();
        SaasProvisionerType provisionerType = doc.addNewSaasProvisioner();
        provisionerType.setVersion(CONFIG_VERSION);
        provisionerType.setEnableSaasProvisionerGUI(globalSettings.isEnabledInGui());
        if (globalSettings.getInternalDataSourceId() != null) {
            provisionerType.setInternalDataSourceId(globalSettings.getInternalDataSourceId());
        }
        provisionerType.setSyncInterval(globalSettings.getSyncInterval());
        provisionerType.setEncryptDBSaasIdentities(globalSettings.isEncryptSaasIdentities());
        for (ProvisionerConfig provisionerConfig : map.values()) {
            if (provisionerConfig == null) continue;
            ConfigHandler.loadProvisionerType(provisionerConfig, provisionerType);
        }
        return doc;
    }

    private static void loadProvisionerType(ProvisionerConfig provisionerConfig, SaasProvisionerType provisionerType) throws ProvisionerPluginNotFoundException {
        SaasProvisionerEntityType saasProvisionerEntity = provisionerType.addNewSaasProvisionerEntity();
        if (provisionerConfig != null) {
            saasProvisionerEntity.setEntityId(provisionerConfig.getEntityId());
            SaasTarget target = provisionerConfig.getTarget();
            if (target != null) {
                TargetType targetType = saasProvisionerEntity.addNewTarget();
                SaasDriverUtil.saveToBeanDoc(targetType, target);
            }
            saasProvisionerEntity.setScim(ScimUtil.getXmlSchema(provisionerConfig.getCustomScim()));
            for (Channel channel : provisionerConfig.getChannels()) {
                ChannelType channelType = saasProvisionerEntity.addNewChannel();
                ChannelUtil.saveToBeanDoc(channelType, channel);
            }
        }
    }

    private void writeOutXmlDocToDisk(SaasProvisionerDocument doc) {
        File outFile = new File(this.CONFIG_LOCATION, CONFIG_NAME);
        List origXml = DiffUtil.fileToLines((String)this.CONFIG_LOCATION, (String)CONFIG_NAME);
        try (FileOutputStream outStream = new FileOutputStream(outFile);){
            XmlOptions options = new XmlOptions();
            options.setSavePrettyPrint();
            options.setSavePrettyPrintIndent(4);
            options.setUseDefaultNamespace();
            outStream.write(doc.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing configuration stream: " + outFile.getPath(), (Throwable)e);
        }
        List savedXml = DiffUtil.fileToLines((String)this.CONFIG_LOCATION, (String)CONFIG_NAME);
        DiffUtil.generateDiff((String)CONFIG_NAME, (List)origXml, (List)savedXml);
    }

    public ProvisionerGlobalSettings getGlobalSettings() {
        ProvisionerGlobalSettings globalSettings = new ProvisionerGlobalSettings();
        if (this.provisionerDoc != null) {
            SaasProvisionerType saasProvType = this.provisionerDoc.getSaasProvisioner();
            if (saasProvType.isSetEnableSaasProvisionerGUI()) {
                globalSettings.setEnabledInGui(saasProvType.getEnableSaasProvisionerGUI());
            }
            if (saasProvType.isSetInternalDataSourceId()) {
                globalSettings.setInternalDataSourceId(saasProvType.getInternalDataSourceId());
            }
            if (saasProvType.isSetSyncInterval()) {
                globalSettings.setSyncInterval(saasProvType.getSyncInterval());
            }
            globalSettings.setEncryptSaasIdentities(saasProvType.getEncryptDBSaasIdentities());
        }
        return globalSettings;
    }
}

