/*
 * Decompiled with CFR 0.152.
 */
package scim.schemas.core.v1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import scim.schemas.core.v1.Meta;
import scim.schemas.core.v1.MultiValuedAttribute;
import scim.schemas.core.v1.Resource;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Group", propOrder={"displayName", "members"})
public class Group
extends Resource
implements Serializable {
    private static final long serialVersionUID = -989205125428164554L;
    protected String displayName;
    protected List<MultiValuedAttribute> members;

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String value) {
        this.displayName = value;
    }

    public String toString() {
        int maxLen = 20;
        return "Group [displayName=" + this.displayName + ", members=" + (this.members != null ? this.members.subList(0, Math.min(this.members.size(), 20)) : null) + ", meta=" + this.meta + ", id=" + this.id + ", externalId=" + this.externalId + ", any=" + (this.any != null ? this.any.subList(0, Math.min(this.any.size(), 20)) : null) + "]";
    }

    public List<MultiValuedAttribute> getMembers() {
        return this.members;
    }

    public void setMembers(List<MultiValuedAttribute> value) {
        this.members = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
            return false;
        }
        return super.equals(obj);
    }

    private Group(Builder builder) {
        this.displayName = builder.displayName;
        this.members = builder.members;
        this.meta = builder.meta;
        this.id = builder.id;
        this.externalId = builder.externalId;
        this.map = builder.map;
    }

    public Group() {
    }

    public Group(Group group) {
        this.displayName = group.displayName;
        this.members = group.members;
        this.meta = new Meta(group.meta);
        this.id = group.id;
        this.externalId = group.externalId;
        this.map = group.map;
    }

    public void addMetatAttribute(String attribute) {
        if (this.meta == null) {
            this.meta = new Meta();
        }
        if (this.meta.getAttributes() == null) {
            this.meta.setAttributes(new ArrayList<String>());
        }
        this.meta.getAttributes().add(attribute);
    }

    public static class Builder {
        private String displayName;
        private List<MultiValuedAttribute> members;
        private Meta meta;
        private String id;
        private String externalId;
        private Map<String, Object> map;

        public Builder meta(Meta meta) {
            this.meta = meta;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder map(Map<String, Object> map) {
            this.map = map;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder members(List<MultiValuedAttribute> members) {
            this.members = members;
            return this;
        }

        public Group build() {
            return new Group(this);
        }
    }
}

