/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.binding.ExpressionBinding;
import org.apache.tapestry.binding.StaticBinding;
import org.apache.tapestry.binding.StringBinding;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.engine.IPageSource;
import org.apache.tapestry.parse.AttributeType;
import org.apache.tapestry.parse.CloseToken;
import org.apache.tapestry.parse.ComponentTemplate;
import org.apache.tapestry.parse.LocalizationToken;
import org.apache.tapestry.parse.OpenToken;
import org.apache.tapestry.parse.TemplateAttribute;
import org.apache.tapestry.parse.TemplateToken;
import org.apache.tapestry.parse.TextToken;
import org.apache.tapestry.parse.TokenType;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IContainedComponent;

public class BaseComponentTemplateLoader {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$BaseComponentTemplateLoader == null ? (class$org$apache$tapestry$BaseComponentTemplateLoader = BaseComponentTemplateLoader.class$("org.apache.tapestry.BaseComponentTemplateLoader")) : class$org$apache$tapestry$BaseComponentTemplateLoader));
    private IPageLoader _pageLoader;
    private IRequestCycle _requestCycle;
    private BaseComponent _loadComponent;
    private IPageSource _pageSource;
    private ComponentTemplate _template;
    private IComponent[] _stack;
    private int _stackx = 0;
    private IComponent _activeComponent = null;
    private Set _seenIds = new HashSet();
    static /* synthetic */ Class class$org$apache$tapestry$BaseComponentTemplateLoader;

    public BaseComponentTemplateLoader(IRequestCycle requestCycle, IPageLoader pageLoader, BaseComponent loadComponent, ComponentTemplate template, IPageSource pageSource) {
        this._requestCycle = requestCycle;
        this._pageLoader = pageLoader;
        this._loadComponent = loadComponent;
        this._template = template;
        this._pageSource = pageSource;
        this._stack = new IComponent[template.getTokenCount()];
    }

    public void process() {
        int count = this._template.getTokenCount();
        for (int i = 0; i < count; ++i) {
            TemplateToken token = this._template.getToken(i);
            TokenType type = token.getType();
            if (type == TokenType.TEXT) {
                this.process((TextToken)token);
                continue;
            }
            if (type == TokenType.OPEN) {
                this.process((OpenToken)token);
                continue;
            }
            if (type == TokenType.CLOSE) {
                this.process((CloseToken)token);
                continue;
            }
            if (type != TokenType.LOCALIZATION) continue;
            this.process((LocalizationToken)token);
        }
        if (this._stackx != 0) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("BaseComponent.unbalance-open-tags"), this._loadComponent, null, null);
        }
        this.checkAllComponentsReferenced();
    }

    private void process(TextToken token) {
        if (this._activeComponent == null) {
            this._loadComponent.addOuter(token);
            return;
        }
        if (!this._activeComponent.getSpecification().getAllowBody()) {
            throw this.createBodylessComponentException(this._activeComponent);
        }
        this._activeComponent.addBody(token);
    }

    private void process(OpenToken token) {
        String id = token.getId();
        IComponent component = null;
        String componentType = token.getComponentType();
        if (componentType == null) {
            component = this.getEmbeddedComponent(id);
        } else {
            this.checkForDuplicateId(id, token.getLocation());
            component = this.createImplicitComponent(id, componentType, token.getLocation());
        }
        if (this._seenIds.contains(id)) {
            throw new ApplicationRuntimeException(Tapestry.format("BaseComponent.multiple-component-references", this._loadComponent.getExtendedId(), id), this._loadComponent, token.getLocation(), null);
        }
        this._seenIds.add(id);
        if (this._activeComponent == null) {
            this._loadComponent.addOuter(component);
        } else {
            if (!this._activeComponent.getSpecification().getAllowBody()) {
                throw this.createBodylessComponentException(this._activeComponent);
            }
            this._activeComponent.addBody(component);
        }
        this.addTemplateBindings(component, token);
        this._stack[this._stackx++] = this._activeComponent;
        this._activeComponent = component;
    }

    private void checkForDuplicateId(String id, ILocation location) {
        if (id == null) {
            return;
        }
        IContainedComponent cc = this._loadComponent.getSpecification().getComponent(id);
        if (cc != null) {
            throw new ApplicationRuntimeException(Tapestry.format("BaseComponentTemplateLoader.dupe-component-id", id, location, cc.getLocation()), this._loadComponent, location, null);
        }
    }

    private IComponent createImplicitComponent(String id, String componentType, ILocation location) {
        IComponent result = this._pageLoader.createImplicitComponent(this._requestCycle, this._loadComponent, id, componentType, location);
        return result;
    }

    private IComponent getEmbeddedComponent(String id) {
        return this._loadComponent.getComponent(id);
    }

    private void process(CloseToken token) {
        if (this._stackx <= 0) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("BaseComponent.unbalanced-close-tags"), this._loadComponent, token.getLocation(), null);
        }
        this._stack[this._stackx--] = null;
        this._activeComponent = this._stack[this._stackx];
    }

    private void process(LocalizationToken token) {
        LocalizedStringRender render = new LocalizedStringRender(this._loadComponent, token);
        if (this._activeComponent == null) {
            this._loadComponent.addOuter(render);
        } else {
            this._activeComponent.addBody(render);
        }
    }

    private void addTemplateBindings(IComponent component, OpenToken token) {
        IComponentSpecification spec = component.getSpecification();
        Map attributes = token.getAttributesMap();
        if (attributes != null) {
            Iterator i = attributes.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String name = (String)entry.getKey();
                TemplateAttribute attribute = (TemplateAttribute)entry.getValue();
                AttributeType type = attribute.getType();
                if (type == AttributeType.OGNL_EXPRESSION) {
                    this.addExpressionBinding(component, spec, name, attribute.getValue(), token.getLocation());
                    continue;
                }
                if (type == AttributeType.LOCALIZATION_KEY) {
                    this.addStringBinding(component, spec, name, attribute.getValue(), token.getLocation());
                    continue;
                }
                if (type != AttributeType.LITERAL) continue;
                this.addStaticBinding(component, spec, name, attribute.getValue(), token.getLocation());
            }
        }
        if (spec.getParameter("templateTag") != null && component.getBinding("templateTag") == null) {
            this.addStaticBinding(component, spec, "templateTag", token.getTag(), token.getLocation());
        }
    }

    private void addExpressionBinding(IComponent component, IComponentSpecification spec, String name, String expression, ILocation location) {
        boolean isFormal;
        boolean bl = isFormal = spec.getParameter(name) != null;
        if (isFormal) {
            if (component.getBinding(name) != null) {
                throw new ApplicationRuntimeException(Tapestry.format("BaseComponent.dupe-template-expression", name, component.getExtendedId(), this._loadComponent.getExtendedId()), component, location, null);
            }
        } else {
            if (!spec.getAllowInformalParameters()) {
                throw new ApplicationRuntimeException(Tapestry.format("BaseComponent.template-expression-for-informal-parameter", name, component.getExtendedId(), this._loadComponent.getExtendedId()), component, location, null);
            }
            if (spec.isReservedParameterName(name)) {
                throw new ApplicationRuntimeException(Tapestry.format("BaseComponent.template-expression-for-reserved-parameter", name, component.getExtendedId(), this._loadComponent.getExtendedId()), component, location, null);
            }
        }
        ExpressionBinding binding = new ExpressionBinding(this._pageSource.getResourceResolver(), this._loadComponent, expression, location);
        component.setBinding(name, binding);
    }

    private void addStringBinding(IComponent component, IComponentSpecification spec, String name, String localizationKey, ILocation location) {
        boolean isFormal;
        boolean bl = isFormal = spec.getParameter(name) != null;
        if (isFormal) {
            if (component.getBinding(name) != null) {
                throw new ApplicationRuntimeException(Tapestry.format("BaseComponent.dupe-string", name, component.getExtendedId(), this._loadComponent.getExtendedId()), component, location, null);
            }
        } else {
            if (!spec.getAllowInformalParameters()) {
                throw new ApplicationRuntimeException(Tapestry.format("BaseComponent.template-expression-for-informal-parameter", name, component.getExtendedId(), this._loadComponent.getExtendedId()), component, location, null);
            }
            if (spec.isReservedParameterName(name)) {
                throw new ApplicationRuntimeException(Tapestry.format("BaseComponent.template-expression-for-reserved-parameter", name, component.getExtendedId(), this._loadComponent.getExtendedId()), component, location, null);
            }
        }
        StringBinding binding = new StringBinding(this._loadComponent, localizationKey, location);
        component.setBinding(name, binding);
    }

    private void addStaticBinding(IComponent component, IComponentSpecification spec, String name, String staticValue, ILocation location) {
        boolean isFormal;
        if (component.getBinding(name) != null) {
            return;
        }
        boolean bl = isFormal = spec.getParameter(name) != null;
        if (!isFormal) {
            if (!spec.getAllowInformalParameters()) {
                return;
            }
            if (spec.isReservedParameterName(name)) {
                return;
            }
        }
        StaticBinding binding = new StaticBinding(staticValue, location);
        component.setBinding(name, binding);
    }

    private void checkAllComponentsReferenced() {
        Map components = this._loadComponent.getComponents();
        Set ids = components.keySet();
        if (this._seenIds.containsAll(ids)) {
            return;
        }
        ids = new HashSet(ids);
        ids.removeAll(this._seenIds);
        int count = ids.size();
        String key = count == 1 ? "BaseComponent.missing-component-spec-single" : "BaseComponent.missing-component-spec-multi";
        StringBuffer buffer = new StringBuffer(Tapestry.format(key, this._loadComponent.getExtendedId()));
        Iterator i = ids.iterator();
        int j = 1;
        while (i.hasNext()) {
            if (j == 1) {
                buffer.append(' ');
            } else if (j == count) {
                buffer.append(' ');
                buffer.append(Tapestry.getMessage("BaseComponent.and"));
                buffer.append(' ');
            } else {
                buffer.append(", ");
            }
            buffer.append(i.next());
            ++j;
        }
        buffer.append('.');
        LOG.error((Object)buffer.toString());
    }

    protected ApplicationRuntimeException createBodylessComponentException(IComponent component) {
        return new ApplicationRuntimeException(Tapestry.getMessage("BaseComponentTemplateLoader.bodyless-component"), component, null, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class LocalizedStringRender
    implements IRender {
        private IComponent _component;
        private String _key;
        private Map _attributes;
        private String _value;
        private boolean _raw;

        private LocalizedStringRender(IComponent component, LocalizationToken token) {
            this._component = component;
            this._key = token.getKey();
            this._raw = token.isRaw();
            this._attributes = token.getAttributes();
        }

        public void render(IMarkupWriter writer, IRequestCycle cycle) {
            if (cycle.isRewinding()) {
                return;
            }
            if (this._attributes != null) {
                writer.begin("span");
                Iterator i = this._attributes.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    String attributeName = (String)entry.getKey();
                    String attributeValue = (String)entry.getValue();
                    writer.attribute(attributeName, attributeValue);
                }
            }
            if (this._value == null) {
                this._value = this._component.getMessage(this._key);
            }
            if (this._raw) {
                writer.printRaw(this._value);
            } else {
                writer.print(this._value);
            }
            if (this._attributes != null) {
                writer.end();
            }
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("component", (Object)this._component);
            builder.append("key", (Object)this._key);
            builder.append("raw", this._raw);
            builder.append("attributes", (Object)this._attributes);
            return builder.toString();
        }
    }
}

