/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.BindingException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.ILocatable;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.event.ChangeObserver;
import org.apache.tapestry.event.ObservedChangeEvent;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.resource.ContextResourceLocation;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.util.AdaptorRegistry;
import org.apache.tapestry.util.StringSplitter;

public final class Tapestry {
    public static final String TAG_SUPPORT_SERVICE_ATTRIBUTE = "org.apache.tapestry.tagsupport.service";
    public static final String TAG_SUPPORT_SERVLET_PATH_ATTRIBUTE = "org.apache.tapestry.tagsupport.servlet-path";
    public static final String TAG_SUPPORT_PARAMETERS_ATTRIBUTE = "org.apache.tapestry.tagsupport.parameters";
    public static final String TAGSUPPORT_SERVICE = "tagsupport";
    public static final String ACTION_SERVICE = "action";
    public static final String DIRECT_SERVICE = "direct";
    public static final String EXTERNAL_SERVICE = "external";
    public static final String PAGE_SERVICE = "page";
    public static final String HOME_SERVICE = "home";
    public static final String RESTART_SERVICE = "restart";
    public static final String ASSET_SERVICE = "asset";
    public static final String RESET_SERVICE = "reset";
    public static final String SERVICE_QUERY_PARAMETER_NAME = "service";
    public static final String PARAMETERS_QUERY_PARAMETER_NAME = "sp";
    public static final String TEMPLATE_EXTENSION_PROPERTY = "org.apache.tapestry.template-extension";
    public static final String DEFAULT_TEMPLATE_EXTENSION = "html";
    public static final String LINK_COMPONENT_ATTRIBUTE_NAME = "org.apache.tapestry.active-link-component";
    public static final String PARAMETER_PROPERTY_NAME_SUFFIX = "Binding";
    public static final String SPECIFICATION_RESOLVER_DELEGATE_EXTENSION_NAME = "org.apache.tapestry.specification-resolver-delegate";
    public static final String TEMPLATE_SOURCE_DELEGATE_EXTENSION_NAME = "org.apache.tapestry.template-source-delegate";
    public static final String REQUEST_DECODER_EXTENSION_NAME = "org.apache.tapestry.request-decoder";
    public static final String MULTIPART_DECODER_EXTENSION_NAME = "org.apache.tapestry.multipart-decoder";
    public static final String ABSTRACTPAGE_VALIDATE_METHOD_ID = "AbstractPage.validate()";
    public static final String ABSTRACTPAGE_DETACH_METHOD_ID = "AbstractPage.detach()";
    public static final String SIMPLE_PROPERTY_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String MONITOR_FACTORY_EXTENSION_NAME = "org.apache.tapestry.monitor-factory";
    public static final String OGNL_TYPE_CONVERTER = "org.apache.tapestry.ognl-type-converter";
    public static final String VERSION = Tapestry.readVersion();
    private static ResourceBundle _strings;
    private static final Map _localeMap;
    private static final ThreadLocal _invokedMethodIds;
    private static final AdaptorRegistry _booleanAdaptors;
    private static AdaptorRegistry _iteratorAdaptors;
    private static final String UNKNOWN_VERSION = "Unknown";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class class$org$apache$tapestry$Tapestry;

    private Tapestry() {
    }

    public static void copyInformalBindings(IComponent source, IComponent destination) {
        Collection names = source.getBindingNames();
        if (names == null) {
            return;
        }
        IComponentSpecification specification = source.getSpecification();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (specification.getParameter(name) != null) continue;
            IBinding binding = source.getBinding(name);
            destination.setBinding(name, binding);
        }
    }

    public static boolean evaluateBoolean(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            Object[] array = (Object[])value;
            return array.length > 0;
        }
        BoolAdaptor adaptor = (BoolAdaptor)_booleanAdaptors.getAdaptor(valueClass);
        return adaptor.coerce(value);
    }

    public static Iterator coerceToIterator(Object value) {
        if (value == null) {
            return null;
        }
        IteratorAdaptor adaptor = (IteratorAdaptor)_iteratorAdaptors.getAdaptor(value.getClass());
        return adaptor.coerce(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale getLocale(String s) {
        Locale result = null;
        Map map = _localeMap;
        synchronized (map) {
            result = (Locale)_localeMap.get(s);
        }
        if (result == null) {
            StringSplitter splitter = new StringSplitter('_');
            String[] terms = splitter.splitToArray(s);
            switch (terms.length) {
                case 1: {
                    result = new Locale(terms[0], "");
                    break;
                }
                case 2: {
                    result = new Locale(terms[0], terms[1]);
                    break;
                }
                case 3: {
                    result = new Locale(terms[0], terms[1], terms[2]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to convert '" + s + "' to a Locale.");
                }
            }
            Map map2 = _localeMap;
            synchronized (map2) {
                _localeMap.put(s, result);
            }
        }
        return result;
    }

    public static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String format(String key, Object[] args) {
        if (_strings == null) {
            _strings = ResourceBundle.getBundle("org.apache.tapestry.TapestryStrings");
        }
        String pattern = _strings.getString(key);
        if (args == null) {
            return pattern;
        }
        return MessageFormat.format(pattern, args);
    }

    public static String getMessage(String key) {
        return Tapestry.format(key, null);
    }

    public static String format(String key, Object arg) {
        return Tapestry.format(key, new Object[]{arg});
    }

    public static String format(String key, Object arg1, Object arg2) {
        return Tapestry.format(key, new Object[]{arg1, arg2});
    }

    public static String format(String key, Object arg1, Object arg2, Object arg3) {
        return Tapestry.format(key, new Object[]{arg1, arg2, arg3});
    }

    private static final String readVersion() {
        Properties props = new Properties();
        try {
            InputStream in = (class$org$apache$tapestry$Tapestry == null ? (class$org$apache$tapestry$Tapestry = Tapestry.class$("org.apache.tapestry.Tapestry")) : class$org$apache$tapestry$Tapestry).getResourceAsStream("Version.properties");
            if (in == null) {
                return UNKNOWN_VERSION;
            }
            props.load(in);
            in.close();
            return props.getProperty("framework.version", UNKNOWN_VERSION);
        }
        catch (IOException ex) {
            return UNKNOWN_VERSION;
        }
    }

    public static int size(Collection c) {
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    public static int size(Object[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    public static Object[] convertMapToArray(Map map) {
        if (Tapestry.isEmpty(map)) {
            return null;
        }
        Set entries = map.entrySet();
        Object[] result = new Object[2 * entries.size()];
        int x = 0;
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            result[x++] = entry.getKey();
            result[x++] = entry.getValue();
        }
        return result;
    }

    public static Map convertArrayToMap(Object[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        if (array.length % 2 != 0) {
            throw new IllegalArgumentException(Tapestry.getMessage("Tapestry.even-sized-array"));
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        int x = 0;
        while (x < array.length) {
            Object key = array[x++];
            Object value = array[x++];
            result.put(key, value);
        }
        return result;
    }

    public static IResourceLocation getApplicationRootLocation(IRequestCycle cycle) {
        RequestContext context = cycle.getRequestContext();
        ServletContext servletContext = context.getServlet().getServletContext();
        String servletPath = context.getRequest().getServletPath();
        return new ContextResourceLocation(servletContext, servletPath);
    }

    public static String getClassName(Class subject) {
        if (subject.isArray()) {
            return Tapestry.getClassName(subject.getComponentType()) + "[]";
        }
        return subject.getName();
    }

    public static ILocation findLocation(Object[] locations) {
        for (int i = 0; i < locations.length; ++i) {
            ILocatable locatable;
            ILocation result;
            Object location = locations[i];
            if (location == null) continue;
            if (location instanceof ILocation) {
                return (ILocation)location;
            }
            if (!(location instanceof ILocatable) || (result = (locatable = (ILocatable)location).getLocation()) == null) continue;
            return result;
        }
        return null;
    }

    public static BindingException createNullBindingException(IBinding binding) {
        return new BindingException(Tapestry.getMessage("null-value-for-binding"), binding);
    }

    public static ApplicationRuntimeException createNoSuchComponentException(IComponent component, String id, ILocation location) {
        return new ApplicationRuntimeException(Tapestry.format("no-such-component", component.getExtendedId(), id), component, location, null);
    }

    public static BindingException createRequiredParameterException(IComponent component, String parameterName) {
        return new BindingException(Tapestry.format("required-parameter", parameterName, component.getExtendedId()), component, null, component.getBinding(parameterName), null);
    }

    public static ApplicationRuntimeException createRenderOnlyPropertyException(IComponent component, String propertyName) {
        return new ApplicationRuntimeException(Tapestry.format("render-only-property", propertyName, component.getExtendedId()), component, null, null);
    }

    public static void clearMethodInvocations() {
        _invokedMethodIds.set(null);
    }

    public static void addMethodInvocation(Object methodId) {
        ArrayList<Object> methodIds = (ArrayList<Object>)_invokedMethodIds.get();
        if (methodIds == null) {
            methodIds = new ArrayList<Object>();
            _invokedMethodIds.set(methodIds);
        }
        methodIds.add(methodId);
    }

    public static void checkMethodInvocation(Object methodId, String methodName, Object object) {
        List methodIds = (List)_invokedMethodIds.get();
        if (methodIds != null && methodIds.contains(methodId)) {
            return;
        }
        throw new ApplicationRuntimeException(Tapestry.format("Tapestry.missing-method-invocation", object.getClass().getName(), methodName));
    }

    public static void fireObservedChange(IComponent component, String propertyName, Object newValue) {
        ChangeObserver observer = component.getPage().getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent(component, propertyName, newValue);
        observer.observeChange(event);
    }

    public static void fireObservedChange(IComponent component, String propertyName, boolean newValue) {
        ChangeObserver observer = component.getPage().getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent(component, propertyName, newValue ? Boolean.TRUE : Boolean.FALSE);
        observer.observeChange(event);
    }

    public static void fireObservedChange(IComponent component, String propertyName, double newValue) {
        ChangeObserver observer = component.getPage().getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent(component, propertyName, new Double(newValue));
        observer.observeChange(event);
    }

    public static void fireObservedChange(IComponent component, String propertyName, float newValue) {
        ChangeObserver observer = component.getPage().getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent(component, propertyName, new Float(newValue));
        observer.observeChange(event);
    }

    public static void fireObservedChange(IComponent component, String propertyName, int newValue) {
        ChangeObserver observer = component.getPage().getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent(component, propertyName, new Integer(newValue));
        observer.observeChange(event);
    }

    public static void fireObservedChange(IComponent component, String propertyName, long newValue) {
        ChangeObserver observer = component.getPage().getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent(component, propertyName, new Long(newValue));
        observer.observeChange(event);
    }

    public static void fireObservedChange(IComponent component, String propertyName, char newValue) {
        ChangeObserver observer = component.getPage().getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent(component, propertyName, new Character(newValue));
        observer.observeChange(event);
    }

    public static void fireObservedChange(IComponent component, String propertyName, byte newValue) {
        ChangeObserver observer = component.getPage().getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent(component, propertyName, new Byte(newValue));
        observer.observeChange(event);
    }

    public static void fireObservedChange(IComponent component, String propertyName, short newValue) {
        ChangeObserver observer = component.getPage().getChangeObserver();
        if (observer == null) {
            return;
        }
        ObservedChangeEvent event = new ObservedChangeEvent(component, propertyName, new Short(newValue));
        observer.observeChange(event);
    }

    public static boolean isBlank(String input) {
        if (input == null || input.length() == 0) {
            return true;
        }
        return input.trim().length() == 0;
    }

    public static boolean isNonBlank(String input) {
        return !Tapestry.isBlank(input);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _localeMap = new HashMap();
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            _localeMap.put(locales[i].toString(), locales[i]);
        }
        _invokedMethodIds = new ThreadLocal();
        _booleanAdaptors = new AdaptorRegistry();
        _booleanAdaptors.register(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Tapestry.class$("java.lang.Boolean")) : class$java$lang$Boolean, new BooleanAdaptor());
        _booleanAdaptors.register(class$java$lang$Number == null ? (class$java$lang$Number = Tapestry.class$("java.lang.Number")) : class$java$lang$Number, new NumberAdaptor());
        _booleanAdaptors.register(class$java$util$Collection == null ? (class$java$util$Collection = Tapestry.class$("java.util.Collection")) : class$java$util$Collection, new CollectionAdaptor());
        _booleanAdaptors.register(class$java$lang$String == null ? (class$java$lang$String = Tapestry.class$("java.lang.String")) : class$java$lang$String, new StringAdaptor());
        _booleanAdaptors.register(class$java$lang$Object == null ? (class$java$lang$Object = Tapestry.class$("java.lang.Object")) : class$java$lang$Object, new BoolAdaptor(){

            public boolean coerce(Object value) {
                return true;
            }
        });
        _iteratorAdaptors = new AdaptorRegistry();
        _iteratorAdaptors.register(class$java$util$Iterator == null ? (class$java$util$Iterator = Tapestry.class$("java.util.Iterator")) : class$java$util$Iterator, new DefaultIteratorAdaptor());
        _iteratorAdaptors.register(class$java$util$Collection == null ? (class$java$util$Collection = Tapestry.class$("java.util.Collection")) : class$java$util$Collection, new CollectionIteratorAdaptor());
        _iteratorAdaptors.register(class$java$lang$Object == null ? (class$java$lang$Object = Tapestry.class$("java.lang.Object")) : class$java$lang$Object, new ObjectIteratorAdaptor());
        _iteratorAdaptors.register(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = Tapestry.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, new ObjectArrayIteratorAdaptor());
        _iteratorAdaptors.register(array$Z == null ? (array$Z = Tapestry.class$("[Z")) : array$Z, new BooleanArrayIteratorAdaptor());
        _iteratorAdaptors.register(array$B == null ? (array$B = Tapestry.class$("[B")) : array$B, new ByteArrayIteratorAdaptor());
        _iteratorAdaptors.register(array$C == null ? (array$C = Tapestry.class$("[C")) : array$C, new CharArrayIteratorAdaptor());
        _iteratorAdaptors.register(array$S == null ? (array$S = Tapestry.class$("[S")) : array$S, new ShortArrayIteratorAdaptor());
        _iteratorAdaptors.register(array$I == null ? (array$I = Tapestry.class$("[I")) : array$I, new IntArrayIteratorAdaptor());
        _iteratorAdaptors.register(array$J == null ? (array$J = Tapestry.class$("[J")) : array$J, new LongArrayIteratorAdaptor());
        _iteratorAdaptors.register(array$F == null ? (array$F = Tapestry.class$("[F")) : array$F, new FloatArrayIteratorAdaptor());
        _iteratorAdaptors.register(array$D == null ? (array$D = Tapestry.class$("[D")) : array$D, new DoubleArrayIteratorAdaptor());
    }

    private static class DoubleArrayIteratorAdaptor
    extends IteratorAdaptor {
        private DoubleArrayIteratorAdaptor() {
        }

        public Iterator coerce(Object value) {
            double[] array = (double[])value;
            if (array.length == 0) {
                return null;
            }
            ArrayList<Double> l = new ArrayList<Double>(array.length);
            for (int i = 0; i < array.length; ++i) {
                l.add(new Double(array[i]));
            }
            return l.iterator();
        }
    }

    private static class FloatArrayIteratorAdaptor
    extends IteratorAdaptor {
        private FloatArrayIteratorAdaptor() {
        }

        public Iterator coerce(Object value) {
            float[] array = (float[])value;
            if (array.length == 0) {
                return null;
            }
            ArrayList<Float> l = new ArrayList<Float>(array.length);
            for (int i = 0; i < array.length; ++i) {
                l.add(new Float(array[i]));
            }
            return l.iterator();
        }
    }

    private static class LongArrayIteratorAdaptor
    extends IteratorAdaptor {
        private LongArrayIteratorAdaptor() {
        }

        public Iterator coerce(Object value) {
            long[] array = (long[])value;
            if (array.length == 0) {
                return null;
            }
            ArrayList<Long> l = new ArrayList<Long>(array.length);
            for (int i = 0; i < array.length; ++i) {
                l.add(new Long(array[i]));
            }
            return l.iterator();
        }
    }

    private static class IntArrayIteratorAdaptor
    extends IteratorAdaptor {
        private IntArrayIteratorAdaptor() {
        }

        public Iterator coerce(Object value) {
            int[] array = (int[])value;
            if (array.length == 0) {
                return null;
            }
            ArrayList<Integer> l = new ArrayList<Integer>(array.length);
            for (int i = 0; i < array.length; ++i) {
                l.add(new Integer(array[i]));
            }
            return l.iterator();
        }
    }

    private static class ShortArrayIteratorAdaptor
    extends IteratorAdaptor {
        private ShortArrayIteratorAdaptor() {
        }

        public Iterator coerce(Object value) {
            short[] array = (short[])value;
            if (array.length == 0) {
                return null;
            }
            ArrayList<Short> l = new ArrayList<Short>(array.length);
            for (int i = 0; i < array.length; ++i) {
                l.add(new Short(array[i]));
            }
            return l.iterator();
        }
    }

    private static class CharArrayIteratorAdaptor
    extends IteratorAdaptor {
        private CharArrayIteratorAdaptor() {
        }

        public Iterator coerce(Object value) {
            char[] array = (char[])value;
            if (array.length == 0) {
                return null;
            }
            ArrayList<Character> l = new ArrayList<Character>(array.length);
            for (int i = 0; i < array.length; ++i) {
                l.add(new Character(array[i]));
            }
            return l.iterator();
        }
    }

    private static class ByteArrayIteratorAdaptor
    extends IteratorAdaptor {
        private ByteArrayIteratorAdaptor() {
        }

        public Iterator coerce(Object value) {
            byte[] array = (byte[])value;
            if (array.length == 0) {
                return null;
            }
            ArrayList<Byte> l = new ArrayList<Byte>(array.length);
            for (int i = 0; i < array.length; ++i) {
                l.add(new Byte(array[i]));
            }
            return l.iterator();
        }
    }

    private static class BooleanArrayIteratorAdaptor
    extends IteratorAdaptor {
        private BooleanArrayIteratorAdaptor() {
        }

        public Iterator coerce(Object value) {
            boolean[] array = (boolean[])value;
            if (array.length == 0) {
                return null;
            }
            ArrayList<Boolean> l = new ArrayList<Boolean>(array.length);
            for (int i = 0; i < array.length; ++i) {
                l.add(array[i] ? Boolean.TRUE : Boolean.FALSE);
            }
            return l.iterator();
        }
    }

    private static class ObjectArrayIteratorAdaptor
    extends IteratorAdaptor {
        private ObjectArrayIteratorAdaptor() {
        }

        public Iterator coerce(Object value) {
            Object[] array = (Object[])value;
            if (array.length == 0) {
                return null;
            }
            return Arrays.asList(array).iterator();
        }
    }

    private static class ObjectIteratorAdaptor
    extends IteratorAdaptor {
        private ObjectIteratorAdaptor() {
        }

        public Iterator coerce(Object value) {
            return Collections.singleton(value).iterator();
        }
    }

    private static class CollectionIteratorAdaptor
    extends IteratorAdaptor {
        private CollectionIteratorAdaptor() {
        }

        public Iterator coerce(Object value) {
            Collection c = (Collection)value;
            if (c.size() == 0) {
                return null;
            }
            return c.iterator();
        }
    }

    private static class DefaultIteratorAdaptor
    extends IteratorAdaptor {
        private DefaultIteratorAdaptor() {
        }

        public Iterator coerce(Object value) {
            return (Iterator)value;
        }
    }

    private static abstract class IteratorAdaptor {
        private IteratorAdaptor() {
        }

        public abstract Iterator coerce(Object var1);
    }

    private static class StringAdaptor
    extends BoolAdaptor {
        private StringAdaptor() {
        }

        public boolean coerce(Object value) {
            String s = (String)value;
            if (s.length() == 0) {
                return false;
            }
            String ts = s.trim();
            if (ts.length() == 0) {
                return false;
            }
            return !ts.equalsIgnoreCase("false");
        }
    }

    private static class CollectionAdaptor
    extends BoolAdaptor {
        private CollectionAdaptor() {
        }

        public boolean coerce(Object value) {
            Collection c = (Collection)value;
            return c.size() > 0;
        }
    }

    private static class NumberAdaptor
    extends BoolAdaptor {
        private NumberAdaptor() {
        }

        public boolean coerce(Object value) {
            Number n = (Number)value;
            return n.intValue() > 0;
        }
    }

    private static class BooleanAdaptor
    extends BoolAdaptor {
        private BooleanAdaptor() {
        }

        public boolean coerce(Object value) {
            Boolean b = (Boolean)value;
            return b;
        }
    }

    private static abstract class BoolAdaptor {
        private BoolAdaptor() {
        }

        public abstract boolean coerce(Object var1);
    }
}

