/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.asset;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.asset.ResourceChecksumSource;

public class ResourceChecksumSourceImpl
implements ResourceChecksumSource {
    private static final int BUFFER_SIZE = 4096;
    private Map _cache = new HashMap();
    private String _digestAlgorithm;
    private BinaryEncoder _encoder;

    public ResourceChecksumSourceImpl(String digestAlgorithm, BinaryEncoder encoder) {
        this._digestAlgorithm = digestAlgorithm;
        this._encoder = encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChecksum(URL resourceURL) {
        Map map = this._cache;
        synchronized (map) {
            String checksum = (String)this._cache.get(resourceURL);
            if (checksum == null) {
                checksum = this.computeChecksum(resourceURL);
                this._cache.put(resourceURL, checksum);
            }
            return checksum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map map = this._cache;
        synchronized (map) {
            this._cache.clear();
        }
    }

    protected String computeChecksum(URL resourceURL) {
        try {
            MessageDigest digest = MessageDigest.getInstance(this._digestAlgorithm);
            BufferedInputStream inputStream = new BufferedInputStream(resourceURL.openStream(), 4096);
            byte[] block = new byte[4096];
            int read = ((InputStream)inputStream).read(block);
            while (read >= 0) {
                digest.update(block, 0, read);
                read = ((InputStream)inputStream).read(block);
            }
            ((InputStream)inputStream).close();
            return new String(this._encoder.encode(digest.digest()));
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(Tapestry.format("AssetService.checksum-compute-failure", resourceURL), e);
        }
    }
}

