/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.RenderRewoundException;
import org.apache.tapestry.StaleLinkException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.IMonitor;
import org.apache.tapestry.engine.IPageRecorder;
import org.apache.tapestry.engine.IPageSource;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.event.ChangeObserver;
import org.apache.tapestry.event.ObservedChangeEvent;
import org.apache.tapestry.request.RequestContext;

public class RequestCycle
implements IRequestCycle,
ChangeObserver {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$engine$RequestCycle == null ? (class$org$apache$tapestry$engine$RequestCycle = RequestCycle.class$("org.apache.tapestry.engine.RequestCycle")) : class$org$apache$tapestry$engine$RequestCycle));
    private IPage _page;
    private IEngine _engine;
    private IEngineService _service;
    private RequestContext _requestContext;
    private IMonitor _monitor;
    private HttpServletResponse _response;
    private Map _loadedPages;
    private Map _loadedRecorders;
    private boolean _rewinding = false;
    private Map _attributes;
    private int _actionId;
    private int _targetActionId;
    private IComponent _targetComponent;
    private Object[] _serviceParameters;
    static /* synthetic */ Class class$org$apache$tapestry$engine$RequestCycle;

    public RequestCycle(IEngine engine, RequestContext requestContext, IEngineService service, IMonitor monitor) {
        this._engine = engine;
        this._requestContext = requestContext;
        this._service = service;
        this._monitor = monitor;
    }

    public void cleanup() {
        if (this._loadedPages == null) {
            return;
        }
        IPageSource source = this._engine.getPageSource();
        Iterator i = this._loadedPages.values().iterator();
        while (i.hasNext()) {
            IPage page = (IPage)i.next();
            source.releasePage(page);
        }
        this._loadedPages = null;
        this._loadedRecorders = null;
    }

    public IEngineService getService() {
        return this._service;
    }

    public String encodeURL(String URL2) {
        if (this._response == null) {
            this._response = this._requestContext.getResponse();
        }
        return this._response.encodeURL(URL2);
    }

    public IEngine getEngine() {
        return this._engine;
    }

    public Object getAttribute(String name) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(name);
    }

    public IMonitor getMonitor() {
        return this._monitor;
    }

    public String getNextActionId() {
        return Integer.toHexString(++this._actionId);
    }

    public IPage getPage() {
        return this._page;
    }

    public IPage getPage(String name) {
        IPage result = null;
        if (name == null) {
            throw new NullPointerException(Tapestry.getMessage("RequestCycle.invalid-null-name"));
        }
        if (this._loadedPages != null) {
            result = (IPage)this._loadedPages.get(name);
        }
        if (result == null) {
            this._monitor.pageLoadBegin(name);
            IPageSource pageSource = this._engine.getPageSource();
            result = pageSource.getPage(this, name, this._monitor);
            IPageRecorder recorder = this.getPageRecorder(name);
            if (recorder != null) {
                recorder.rollback(result);
                result.setChangeObserver(recorder);
                recorder.setLocked(false);
            } else {
                result.setChangeObserver(this);
            }
            this._monitor.pageLoadEnd(name);
            if (this._loadedPages == null) {
                this._loadedPages = new HashMap();
            }
            this._loadedPages.put(name, result);
        }
        return result;
    }

    protected IPageRecorder getPageRecorder(String name) {
        IPageRecorder result = null;
        if (this._loadedRecorders != null) {
            result = (IPageRecorder)this._loadedRecorders.get(name);
        }
        if (result != null) {
            return result;
        }
        result = this._engine.getPageRecorder(name, this);
        if (result == null) {
            return null;
        }
        if (this._loadedRecorders == null) {
            this._loadedRecorders = new HashMap();
        }
        this._loadedRecorders.put(name, result);
        return result;
    }

    private IPageRecorder createPageRecorder(String name) {
        IPageRecorder result = this.getPageRecorder(name);
        if (result == null) {
            result = this._engine.createPageRecorder(name, this);
            if (this._loadedRecorders == null) {
                this._loadedRecorders = new HashMap();
            }
            this._loadedRecorders.put(name, result);
        }
        return result;
    }

    public RequestContext getRequestContext() {
        return this._requestContext;
    }

    public boolean isRewinding() {
        return this._rewinding;
    }

    public boolean isRewound(IComponent component) throws StaleLinkException {
        if (!this._rewinding) {
            return false;
        }
        if (this._actionId != this._targetActionId) {
            return false;
        }
        if (component == this._targetComponent) {
            return true;
        }
        throw new StaleLinkException(component, Integer.toHexString(this._targetActionId), this._targetComponent.getExtendedId());
    }

    public void removeAttribute(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing attribute " + name));
        }
        if (this._attributes == null) {
            return;
        }
        this._attributes.remove(name);
    }

    public void renderPage(IMarkupWriter writer) {
        String pageName = this._page.getPageName();
        this._monitor.pageRenderBegin(pageName);
        this._rewinding = false;
        this._actionId = -1;
        this._targetActionId = 0;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        try {
            try {
                this._page.renderPage(writer, this);
            }
            catch (ApplicationRuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ApplicationRuntimeException(ex.getMessage(), this._page, null, ex);
            }
            Object var5_3 = null;
            this._actionId = 0;
            this._targetActionId = 0;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this._actionId = 0;
            this._targetActionId = 0;
            throw throwable;
        }
        this._monitor.pageRenderEnd(pageName);
    }

    public void rewindForm(IForm form, String targetActionId) {
        IPage page = form.getPage();
        String pageName = page.getPageName();
        this._rewinding = true;
        this._monitor.pageRewindBegin(pageName);
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this._targetActionId = Integer.parseInt(targetActionId, 16);
        this._actionId = this._targetActionId - 1;
        this._targetComponent = form;
        try {
            try {
                page.beginPageRender();
                form.rewind(NullWriter.getSharedInstance(), this);
                throw new StaleLinkException(Tapestry.format("RequestCycle.form-rewind-failure", form.getExtendedId()), form);
            }
            catch (RenderRewoundException renderRewoundException) {
                Object var7_8 = null;
                this._actionId = 0;
                this._targetActionId = 0;
                this._targetComponent = null;
                page.endPageRender();
                this._monitor.pageRewindEnd(pageName);
                this._rewinding = false;
            }
            catch (ApplicationRuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ApplicationRuntimeException(ex.getMessage(), page, null, ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this._actionId = 0;
            this._targetActionId = 0;
            this._targetComponent = null;
            page.endPageRender();
            this._monitor.pageRewindEnd(pageName);
            this._rewinding = false;
            throw throwable;
        }
    }

    public void rewindPage(String targetActionId, IComponent targetComponent) {
        String pageName = this._page.getPageName();
        this._rewinding = true;
        this._monitor.pageRewindBegin(pageName);
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this._actionId = -1;
        this._targetActionId = Integer.parseInt(targetActionId, 16);
        this._targetComponent = targetComponent;
        try {
            try {
                this._page.renderPage(NullWriter.getSharedInstance(), this);
                throw new StaleLinkException(this._page, targetActionId, targetComponent.getExtendedId());
            }
            catch (RenderRewoundException renderRewoundException) {
                Object var6_7 = null;
                this._actionId = 0;
                this._targetActionId = 0;
                this._targetComponent = null;
                this._monitor.pageRewindEnd(pageName);
                this._rewinding = false;
            }
            catch (ApplicationRuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ApplicationRuntimeException(ex.getMessage(), this._page, null, ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this._actionId = 0;
            this._targetActionId = 0;
            this._targetComponent = null;
            this._monitor.pageRewindEnd(pageName);
            this._rewinding = false;
            throw throwable;
        }
    }

    public void setAttribute(String name, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set attribute " + name + " to " + value));
        }
        if (this._attributes == null) {
            this._attributes = new HashMap();
        }
        this._attributes.put(name, value);
    }

    public void setPage(IPage value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set page to " + value));
        }
        this._page = value;
    }

    public void setPage(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set page to " + name));
        }
        this._page = this.getPage(name);
    }

    public void commitPageChanges() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Committing page changes");
        }
        if (this._loadedRecorders == null || this._loadedRecorders.isEmpty()) {
            return;
        }
        Iterator i = this._loadedRecorders.values().iterator();
        while (i.hasNext()) {
            IPageRecorder recorder = (IPageRecorder)i.next();
            recorder.commit();
        }
    }

    public void observeChange(ObservedChangeEvent event) {
        IPage page = event.getComponent().getPage();
        String pageName = page.getPageName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Observed change in page " + pageName + "; creating page recorder."));
        }
        IPageRecorder recorder = this.createPageRecorder(pageName);
        page.setChangeObserver(recorder);
        recorder.observeChange(event);
    }

    public void discardPage(String name) {
        IPageRecorder recorder;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Discarding page " + name));
        }
        if ((recorder = this._engine.getPageRecorder(name, this)) == null) {
            this._page = this.getPage(name);
            recorder = this.createPageRecorder(name);
            this._page.setChangeObserver(recorder);
        }
        recorder.markForDiscard();
    }

    public Object[] getServiceParameters() {
        return this._serviceParameters;
    }

    public void setServiceParameters(Object[] serviceParameters) {
        this._serviceParameters = serviceParameters;
    }

    public void activate(String name) {
        IPage page = this.getPage(name);
        this.activate(page);
    }

    public void activate(IPage page) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Activating page " + page));
        }
        Tapestry.clearMethodInvocations();
        page.validate(this);
        Tapestry.checkMethodInvocation("AbstractPage.validate()", "validate()", page);
        this.setPage(page);
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.append("rewinding", this._rewinding);
        if (this._service != null) {
            b.append("service", (Object)this._service.getName());
        }
        b.append("serviceParameters", this._serviceParameters);
        if (this._loadedPages != null) {
            b.append("loadedPages", this._loadedPages.keySet());
        }
        b.append("attributes", (Object)this._attributes);
        b.append("targetActionId", this._targetActionId);
        b.append("targetComponent", (Object)this._targetComponent);
        return b.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

