/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.multipart;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.multipart.IMultipartDecoder;
import org.apache.tapestry.multipart.IPart;
import org.apache.tapestry.multipart.UploadPart;
import org.apache.tapestry.multipart.ValuePart;
import org.apache.tapestry.request.IUploadFile;

public class DefaultMultipartDecoder
implements IMultipartDecoder {
    public static final String PART_MAP_ATTRIBUTE_NAME = "org.apache.tapestry.multipart.part-map";
    private int _maxSize = 10000000;
    private int _thresholdSize = 1024;
    private String _repositoryPath = System.getProperty("java.io.tmpdir");
    private static DefaultMultipartDecoder _shared;

    public static DefaultMultipartDecoder getSharedInstance() {
        if (_shared == null) {
            _shared = new DefaultMultipartDecoder();
        }
        return _shared;
    }

    public void setMaxSize(int maxSize) {
        this._maxSize = maxSize;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public void setThresholdSize(int thresholdSize) {
        this._thresholdSize = thresholdSize;
    }

    public int getThresholdSize() {
        return this._thresholdSize;
    }

    public void setRepositoryPath(String repositoryPath) {
        this._repositoryPath = repositoryPath;
    }

    public String getRepositoryPath() {
        return this._repositoryPath;
    }

    public static boolean isMultipartRequest(HttpServletRequest request) {
        return FileUploadBase.isMultipartContent((HttpServletRequest)request);
    }

    public void cleanup(HttpServletRequest request) {
        Map partMap = this.getPartMap(request);
        Iterator i = partMap.values().iterator();
        while (i.hasNext()) {
            IPart part = (IPart)i.next();
            part.cleanup();
        }
    }

    public void decode(HttpServletRequest request) {
        HashMap<String, IPart> partMap = new HashMap<String, IPart>();
        request.setAttribute(PART_MAP_ATTRIBUTE_NAME, partMap);
        String encoding = request.getCharacterEncoding();
        DiskFileUpload upload = new DiskFileUpload();
        List parts = null;
        try {
            if (encoding != null) {
                upload.setHeaderEncoding(encoding);
            }
            parts = upload.parseRequest(request, this._thresholdSize, (long)this._maxSize, this._repositoryPath);
        }
        catch (FileUploadException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("DefaultMultipartDecoder.unable-to-decode", ex.getMessage()), ex);
        }
        int count = Tapestry.size(parts);
        for (int i = 0; i < count; ++i) {
            FileItem uploadItem = (FileItem)parts.get(i);
            if (uploadItem.isFormField()) {
                try {
                    String name = uploadItem.getFieldName();
                    String value = encoding == null ? uploadItem.getString() : uploadItem.getString(encoding);
                    ValuePart valuePart = (ValuePart)partMap.get(name);
                    if (valuePart != null) {
                        valuePart.add(value);
                        continue;
                    }
                    valuePart = new ValuePart(value);
                    partMap.put(name, valuePart);
                    continue;
                }
                catch (UnsupportedEncodingException ex) {
                    throw new ApplicationRuntimeException(Tapestry.format("illegal-encoding", encoding), ex);
                }
            }
            UploadPart uploadPart = new UploadPart(uploadItem);
            partMap.put(uploadItem.getFieldName(), uploadPart);
        }
    }

    public String getString(HttpServletRequest request, String name) {
        Map partMap = this.getPartMap(request);
        ValuePart part = (ValuePart)partMap.get(name);
        if (part != null) {
            return part.getValue();
        }
        return null;
    }

    public String[] getStrings(HttpServletRequest request, String name) {
        Map partMap = this.getPartMap(request);
        ValuePart part = (ValuePart)partMap.get(name);
        if (part != null) {
            return part.getValues();
        }
        return null;
    }

    public IUploadFile getUploadFile(HttpServletRequest request, String name) {
        Map partMap = this.getPartMap(request);
        return (IUploadFile)partMap.get(name);
    }

    private Map getPartMap(HttpServletRequest request) {
        return (Map)request.getAttribute(PART_MAP_ATTRIBUTE_NAME);
    }
}

