/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.param;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BindingException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.param.BooleanParameterConnector;
import org.apache.tapestry.param.ConnectedParameterException;
import org.apache.tapestry.param.DoubleParameterConnector;
import org.apache.tapestry.param.IParameterConnector;
import org.apache.tapestry.param.IntParameterConnector;
import org.apache.tapestry.param.ObjectParameterConnector;
import org.apache.tapestry.param.StringParameterConnector;
import org.apache.tapestry.spec.Direction;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IParameterSpecification;
import org.apache.tapestry.util.prop.PropertyFinder;
import org.apache.tapestry.util.prop.PropertyInfo;

public class ParameterManager {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$param$ParameterManager == null ? (class$org$apache$tapestry$param$ParameterManager = ParameterManager.class$("org.apache.tapestry.param.ParameterManager")) : class$org$apache$tapestry$param$ParameterManager));
    private static final Map SPECIAL_TYPE_MAP = new HashMap();
    private IComponent _component;
    private IParameterConnector[] _connectors;
    static /* synthetic */ Class class$org$apache$tapestry$param$ParameterManager;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$String;

    public ParameterManager(IComponent component) {
        this._component = component;
    }

    public void setParameters(IRequestCycle cycle) {
        if (this._connectors == null) {
            this.setup(cycle);
        }
        for (int i = 0; i < this._connectors.length; ++i) {
            this._connectors[i].setParameter(cycle);
        }
    }

    public void resetParameters(IRequestCycle cycle) {
        if (this._connectors == null) {
            return;
        }
        for (int i = 0; i < this._connectors.length; ++i) {
            this._connectors[i].resetParameter(cycle);
        }
    }

    private void setup(IRequestCycle cycle) {
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug((Object)(this._component + ": connecting parameters and properties"));
        }
        ArrayList<IParameterConnector> list = new ArrayList<IParameterConnector>();
        IComponentSpecification spec = this._component.getSpecification();
        IResourceResolver resolver = this._component.getPage().getEngine().getResourceResolver();
        IParameterConnector disabledConnector = null;
        List names = spec.getParameterNames();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            PropertyInfo propertyInfo;
            IBinding binding;
            String name = (String)i.next();
            if (debug) {
                LOG.debug((Object)("Connecting parameter " + name + "."));
            }
            if ((binding = this._component.getBinding(name)) == null) {
                if (!debug) continue;
                LOG.debug((Object)"Not bound.");
                continue;
            }
            IParameterSpecification pspec = spec.getParameter(name);
            Direction direction = pspec.getDirection();
            if (direction != Direction.IN && direction != Direction.FORM) {
                if (!debug) continue;
                LOG.debug((Object)("Parameter is " + pspec.getDirection().getName() + "."));
                continue;
            }
            if (!direction.getAllowInvariant() && binding.isInvariant()) {
                throw new ConnectedParameterException(Tapestry.format("ParameterManager.incompatible-direction-and-binding", new Object[]{name, this._component.getExtendedId(), direction.getDisplayName(), binding}), this._component, name, null, binding.getLocation(), null);
            }
            String propertyName = pspec.getPropertyName();
            if (debug && !name.equals(propertyName)) {
                LOG.debug((Object)("Connecting to property " + propertyName + "."));
            }
            if ((propertyInfo = PropertyFinder.getPropertyInfo(this._component.getClass(), propertyName)) == null) {
                throw new ConnectedParameterException(Tapestry.format("ParameterManager.no-accessor", this._component.getExtendedId(), propertyName), this._component, name, propertyName, binding.getLocation(), null);
            }
            if (!propertyInfo.isReadWrite()) {
                throw new ConnectedParameterException(Tapestry.format("ParameterManager.property-not-read-write", this._component.getExtendedId(), propertyName), this._component, name, propertyName, binding.getLocation(), null);
            }
            Class propertyType = propertyInfo.getType();
            Class parameterType = this.getType(pspec.getType(), resolver);
            if (parameterType == null) {
                throw new ConnectedParameterException(Tapestry.format("ParameterManager.java-type-not-specified", name, this._component.getExtendedId()), this._component, name, propertyName, binding.getLocation(), null);
            }
            if (!propertyType.equals(parameterType)) {
                throw new ConnectedParameterException(Tapestry.format("ParameterManager.type-mismatch", new String[]{name, this._component.getExtendedId(), parameterType.toString(), propertyType.toString()}), this._component, name, propertyName, binding.getLocation(), null);
            }
            IParameterConnector connector = this.createConnector(this._component, name, binding, propertyType, parameterType);
            if (binding.isInvariant()) {
                if (debug) {
                    LOG.debug((Object)("Setting invariant value using " + connector + "."));
                }
                try {
                    connector.setParameter(cycle);
                    continue;
                }
                catch (BindingException ex) {
                    throw new ConnectedParameterException(Tapestry.format("ParameterManager.static-initialization-failure", propertyName, this._component.getExtendedId(), binding.toString()), this._component, name, propertyName, ex);
                }
            }
            if (debug) {
                LOG.debug((Object)("Adding " + connector + "."));
            }
            if (name.equals("disabled")) {
                disabledConnector = connector;
                continue;
            }
            list.add(connector);
        }
        if (disabledConnector != null) {
            list.add(disabledConnector);
        }
        this._connectors = list.toArray(new IParameterConnector[list.size()]);
    }

    private IParameterConnector createConnector(IComponent component, String parameterName, IBinding binding, Class propertyType, Class requiredType) {
        if (propertyType.equals(Boolean.TYPE)) {
            return new BooleanParameterConnector(component, parameterName, binding);
        }
        if (propertyType.equals(Integer.TYPE)) {
            return new IntParameterConnector(component, parameterName, binding);
        }
        if (propertyType.equals(Double.TYPE)) {
            return new DoubleParameterConnector(component, parameterName, binding);
        }
        if (propertyType.equals(class$java$lang$String == null ? (class$java$lang$String = ParameterManager.class$("java.lang.String")) : class$java$lang$String)) {
            return new StringParameterConnector(component, parameterName, binding);
        }
        return new ObjectParameterConnector(component, parameterName, binding, requiredType);
    }

    private Class getType(String name, IResourceResolver resolver) {
        if (Tapestry.isBlank(name)) {
            return null;
        }
        Class result = (Class)SPECIAL_TYPE_MAP.get(name);
        if (result != null) {
            return result;
        }
        return resolver.findClass(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SPECIAL_TYPE_MAP.put("boolean", Boolean.TYPE);
        SPECIAL_TYPE_MAP.put("boolean[]", array$Z == null ? (array$Z = ParameterManager.class$("[Z")) : array$Z);
        SPECIAL_TYPE_MAP.put("byte", Byte.TYPE);
        SPECIAL_TYPE_MAP.put("byte[]", array$B == null ? (array$B = ParameterManager.class$("[B")) : array$B);
        SPECIAL_TYPE_MAP.put("char", Character.TYPE);
        SPECIAL_TYPE_MAP.put("char[]", array$C == null ? (array$C = ParameterManager.class$("[C")) : array$C);
        SPECIAL_TYPE_MAP.put("short", Short.TYPE);
        SPECIAL_TYPE_MAP.put("short[]", array$S == null ? (array$S = ParameterManager.class$("[S")) : array$S);
        SPECIAL_TYPE_MAP.put("int", Integer.TYPE);
        SPECIAL_TYPE_MAP.put("int[]", array$I == null ? (array$I = ParameterManager.class$("[I")) : array$I);
        SPECIAL_TYPE_MAP.put("long", Long.TYPE);
        SPECIAL_TYPE_MAP.put("long[]", array$J == null ? (array$J = ParameterManager.class$("[J")) : array$J);
        SPECIAL_TYPE_MAP.put("float", Float.TYPE);
        SPECIAL_TYPE_MAP.put("float[]", array$F == null ? (array$F = ParameterManager.class$("[F")) : array$F);
        SPECIAL_TYPE_MAP.put("double", Double.TYPE);
        SPECIAL_TYPE_MAP.put("double[]", array$D == null ? (array$D = ParameterManager.class$("[D")) : array$D);
        SPECIAL_TYPE_MAP.put("java.lang.Object[]", array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = ParameterManager.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
        SPECIAL_TYPE_MAP.put("java.lang.String[]", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ParameterManager.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
    }
}

