/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.io;

import java.io.IOException;
import org.apache.commons.lang.enum.Enum;
import org.apache.commons.lang.enum.EnumUtils;
import org.apache.tapestry.util.io.DataSqueezer;
import org.apache.tapestry.util.io.ISqueezeAdaptor;
import org.apache.tapestry.util.io.Utils;

public class EnumAdaptor
implements ISqueezeAdaptor {
    private static final String PREFIX = "E";
    private static final char SEPARATOR = '@';
    private static final char COLON_SEPARATOR = ':';
    static /* synthetic */ Class class$org$apache$commons$lang$enum$Enum;

    public String squeeze(DataSqueezer squeezer, Object o) throws IOException {
        Enum e = (Enum)o;
        String data = e.getClass().getName() + '@' + e.getName();
        byte[] byteData = data.getBytes();
        byte[] hmac = Utils.getHmac(byteData);
        return PREFIX + Utils.encode(hmac) + ':' + Utils.encode(byteData);
    }

    public Object unsqueeze(DataSqueezer squeezer, String str) throws IOException {
        int colonIndex = str.indexOf(58, 2);
        if (colonIndex == -1) {
            throw new IOException("Input string has missing or misplaced colon separator");
        }
        if (colonIndex == str.length() - 1) {
            throw new IOException("Input string contains no serialized data");
        }
        byte[] expectedHmac = Utils.decode(str.substring(1, colonIndex));
        byte[] byteData = Utils.decode(str.substring(colonIndex + 1));
        byte[] actualHmac = Utils.getHmac(byteData);
        if (!Utils.secureEquals(actualHmac, expectedHmac)) {
            throw new IOException("Input string has invalid signature");
        }
        int pos = new String(byteData).indexOf(64);
        String className = str.substring(1, pos);
        String name = str.substring(pos + 1, str.length());
        Class enumClass = squeezer.getResolver().findClass(className);
        try {
            return EnumUtils.getEnum((Class)enumClass, (String)name);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void register(DataSqueezer squeezer) {
        squeezer.register(PREFIX, class$org$apache$commons$lang$enum$Enum == null ? (class$org$apache$commons$lang$enum$Enum = EnumAdaptor.class$("org.apache.commons.lang.enum.Enum")) : class$org$apache$commons$lang$enum$Enum, this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

