/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.util.io.DataSqueezer;
import org.apache.tapestry.util.io.ISqueezeAdaptor;
import org.apache.tapestry.util.io.ResolvingObjectInputStream;
import org.apache.tapestry.util.io.Utils;

class SerializableAdaptor
implements ISqueezeAdaptor {
    private static final String SEPARATOR = ":";
    private static final String PREFIX = "O";
    static /* synthetic */ Class class$java$io$Serializable;

    SerializableAdaptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String squeeze(DataSqueezer squeezer, Object data) throws IOException {
        ByteArrayOutputStream bos = null;
        GZIPOutputStream gos = null;
        ObjectOutputStream oos = null;
        byte[] byteData = null;
        try {
            bos = new ByteArrayOutputStream();
            gos = new GZIPOutputStream(bos);
            oos = new ObjectOutputStream(gos);
            oos.writeObject(data);
            oos.close();
            Object var8_7 = null;
            this.close(oos);
            this.close(gos);
            this.close(bos);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.close(oos);
            this.close(gos);
            this.close(bos);
            throw throwable;
        }
        byteData = bos.toByteArray();
        byte[] hmac = Utils.getHmac(byteData);
        StringBuffer encoded = new StringBuffer();
        encoded.append(PREFIX);
        encoded.append(Utils.encode(hmac));
        encoded.append(SEPARATOR);
        encoded.append(Utils.encode(byteData));
        return encoded.toString();
    }

    private void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Object unsqueeze(DataSqueezer squeezer, String string) throws IOException {
        int colonIndex = string.indexOf(SEPARATOR, 2);
        if (colonIndex == -1) {
            throw new IOException("Input string has missing or misplaced colon separator");
        }
        if (colonIndex == string.length() - 1) {
            throw new IOException("Input string contains no serialized data");
        }
        byte[] expectedHmac = Utils.decode(string.substring(1, colonIndex));
        byte[] byteData = Utils.decode(string.substring(colonIndex + 1));
        byte[] actualHmac = Utils.getHmac(byteData);
        if (!Utils.secureEquals(actualHmac, expectedHmac)) {
            throw new IOException("Input string has invalid signature");
        }
        ByteArrayInputStream bis = null;
        GZIPInputStream gis = null;
        ResolvingObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(byteData);
            gis = new GZIPInputStream(bis);
            ois = new ResolvingObjectInputStream(squeezer.getResolver(), gis);
            Object object = ois.readObject();
            Object var12_12 = null;
            this.close(ois);
            this.close(gis);
            this.close(bis);
            return object;
        }
        catch (ClassNotFoundException ex) {
            try {
                throw new IOException(Tapestry.format("SerializableAdaptor.class-not-found", ex.getMessage()));
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                this.close(ois);
                this.close(gis);
                this.close(bis);
                throw throwable;
            }
        }
    }

    public void register(DataSqueezer squeezer) {
        squeezer.register(PREFIX, class$java$io$Serializable == null ? (class$java$io$Serializable = SerializableAdaptor.class$("java.io.Serializable")) : class$java$io$Serializable, this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

