/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.io;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import org.apache.tapestry.Tapestry;

final class Utils {
    private static final String HMACSHA = "HMACSHA256";
    private static Key hmacKey;
    private static final byte[] EMPTY_BYTES;
    private static final char PAD = '.';
    private static final char CH_62 = '-';
    private static final char CH_63 = '_';

    private Utils() {
    }

    public static boolean secureEquals(byte[] bytes1, byte[] bytes2) {
        bytes1 = bytes1 == null ? EMPTY_BYTES : bytes1;
        bytes2 = bytes2 == null ? EMPTY_BYTES : bytes2;
        int shortest = Math.min(bytes1.length, bytes2.length);
        int longest = Math.max(bytes1.length, bytes2.length);
        int result = 0;
        for (int i = 0; i < shortest; ++i) {
            result |= bytes1[i] ^ bytes2[i];
        }
        return result == 0 && shortest == longest;
    }

    public static String encode(byte[] raw) throws IOException {
        StringBuffer encoded = new StringBuffer(2 * raw.length);
        char[] base64 = new char[4];
        for (int i = 0; i < raw.length; i += 3) {
            Utils.encodeBlock(raw, i, base64);
            encoded.append(base64);
        }
        return encoded.toString();
    }

    private static void encodeBlock(byte[] raw, int offset, char[] base64) throws IOException {
        int i;
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        for (i = 0; i <= end; ++i) {
            int b = raw[offset + i];
            int neuter = b < 0 ? b + 256 : b;
            block += neuter << 8 * (2 - i);
        }
        for (i = 0; i < 4; ++i) {
            int sixbit = block >>> 6 * (3 - i) & 0x3F;
            base64[i] = Utils.getChar(sixbit);
        }
        if (slack < 1) {
            base64[2] = 46;
        }
        if (slack < 2) {
            base64[3] = 46;
        }
    }

    private static char getChar(int sixBit) throws IOException {
        if (sixBit >= 0 && sixBit <= 25) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit <= 51) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit <= 61) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '-';
        }
        if (sixBit == 63) {
            return '_';
        }
        throw new IOException(Tapestry.format("SerializableAdaptor.unable-to-convert", Integer.toString(sixBit)));
    }

    public static byte[] decode(String string) throws IOException {
        int pad = 0;
        char[] base64 = string.toCharArray();
        int i = base64.length - 1;
        while (base64[i] == '.') {
            ++pad;
            --i;
        }
        int length = base64.length * 6 / 8 - pad;
        byte[] raw = new byte[length];
        int rawIndex = 0;
        for (int i2 = 0; i2 < base64.length; i2 += 4) {
            int block = (Utils.getValue(base64[i2]) << 18) + (Utils.getValue(base64[i2 + 1]) << 12) + (Utils.getValue(base64[i2 + 2]) << 6) + Utils.getValue(base64[i2 + 3]);
            for (int j = 0; j < 3 && rawIndex + j < raw.length; ++j) {
                raw[rawIndex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
            }
            rawIndex += 3;
        }
        return raw;
    }

    private static int getValue(char c) throws IOException {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '-') {
            return 62;
        }
        if (c == '_') {
            return 63;
        }
        if (c == '.') {
            return 0;
        }
        throw new IOException(Tapestry.format("SerializableAdaptor.unable-to-interpret-char", new String(new char[]{c})));
    }

    private static synchronized Key getHmacKey() throws NoSuchAlgorithmException {
        if (hmacKey == null) {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(HMACSHA);
            keyGenerator.init(256);
            hmacKey = keyGenerator.generateKey();
        }
        return hmacKey;
    }

    public static byte[] getHmac(byte[] input) throws IOException {
        try {
            Mac mac = Mac.getInstance(HMACSHA);
            mac.init(Utils.getHmacKey());
            return mac.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Unexpecter error calculating HMAC", e);
        }
    }

    static {
        EMPTY_BYTES = new byte[0];
    }
}

