/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.util.AdaptorRegistry;
import org.apache.tapestry.valid.BaseValidator;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class NumberValidator
extends BaseValidator {
    private static final Map TYPES = new HashMap();
    private static final Set INT_TYPES;
    private Class _valueTypeClass = Integer.TYPE;
    private boolean _zeroIsNull;
    private Number _minimum;
    private Number _maximum;
    private String _scriptPath = "/org/apache/tapestry/valid/NumberValidator.script";
    private String _invalidNumericFormatMessage;
    private String _invalidIntegerFormatMessage;
    private String _numberTooSmallMessage;
    private String _numberTooLargeMessage;
    private String _numberRangeMessage;
    private static AdaptorRegistry _numberAdaptors;
    public static final int NUMBER_TYPE_INTEGER = 0;
    public static final int NUMBER_TYPE_REAL = 1;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public String toString(IFormComponent field, Object value) {
        Number number;
        if (value == null) {
            return null;
        }
        if (this._zeroIsNull && (number = (Number)value).doubleValue() == 0.0) {
            return null;
        }
        return value.toString();
    }

    private NumberAdaptor getAdaptor(IFormComponent field) {
        NumberAdaptor result = NumberValidator.getAdaptor(this._valueTypeClass);
        if (result == null) {
            throw new ApplicationRuntimeException(Tapestry.format("NumberValidator.no-adaptor-for-field", field, this._valueTypeClass.getName()));
        }
        return result;
    }

    public static NumberAdaptor getAdaptor(Class type) {
        return (NumberAdaptor)_numberAdaptors.getAdaptor(type);
    }

    public Object toObject(IFormComponent field, String value) throws ValidatorException {
        if (this.checkRequired(field, value)) {
            return null;
        }
        NumberAdaptor adaptor = this.getAdaptor(field);
        Number result = null;
        try {
            result = adaptor.parse(value);
        }
        catch (NumberFormatException ex) {
            throw new ValidatorException(this.buildInvalidNumericFormatMessage(field), ValidationConstraint.NUMBER_FORMAT);
        }
        if (this._minimum != null && adaptor.compare(result, this._minimum) < 0) {
            throw new ValidatorException(this.buildNumberTooSmallMessage(field), ValidationConstraint.TOO_SMALL);
        }
        if (this._maximum != null && adaptor.compare(result, this._maximum) > 0) {
            throw new ValidatorException(this.buildNumberTooLargeMessage(field), ValidationConstraint.TOO_LARGE);
        }
        return result;
    }

    public Number getMaximum() {
        return this._maximum;
    }

    public boolean getHasMaximum() {
        return this._maximum != null;
    }

    public void setMaximum(Number maximum) {
        this._maximum = maximum;
    }

    public Number getMinimum() {
        return this._minimum;
    }

    public boolean getHasMinimum() {
        return this._minimum != null;
    }

    public void setMinimum(Number minimum) {
        this._minimum = minimum;
    }

    public boolean getZeroIsNull() {
        return this._zeroIsNull;
    }

    public void setZeroIsNull(boolean zeroIsNull) {
        this._zeroIsNull = zeroIsNull;
    }

    public void renderValidatorContribution(IFormComponent field, IMarkupWriter writer, IRequestCycle cycle) {
        if (!this.isClientScriptingEnabled()) {
            return;
        }
        if (!this.isRequired() && this._minimum == null && this._maximum == null) {
            return;
        }
        HashMap<String, String> symbols = new HashMap<String, String>();
        if (this.isRequired()) {
            symbols.put("requiredMessage", this.buildRequiredMessage(field));
        }
        if (this.isIntegerNumber()) {
            symbols.put("formatMessage", this.buildInvalidIntegerFormatMessage(field));
        } else {
            symbols.put("formatMessage", this.buildInvalidNumericFormatMessage(field));
        }
        if (this._minimum != null || this._maximum != null) {
            symbols.put("rangeMessage", this.buildRangeMessage(field));
        }
        this.processValidatorScript(this._scriptPath, cycle, field, symbols);
    }

    private String buildRangeMessage(IFormComponent field) {
        if (this._minimum != null && this._maximum != null) {
            return this.buildNumberRangeMessage(field);
        }
        if (this._maximum != null) {
            return this.buildNumberTooLargeMessage(field);
        }
        return this.buildNumberTooSmallMessage(field);
    }

    public String getScriptPath() {
        return this._scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this._scriptPath = scriptPath;
    }

    public void setValueType(String typeName) {
        Class typeClass = (Class)TYPES.get(typeName);
        if (typeClass == null) {
            throw new ApplicationRuntimeException(Tapestry.format("NumberValidator.unknown-type", typeName));
        }
        this._valueTypeClass = typeClass;
    }

    public void setValueTypeClass(Class valueTypeClass) {
        this._valueTypeClass = valueTypeClass;
    }

    public Class getValueTypeClass() {
        return this._valueTypeClass;
    }

    public String getInvalidNumericFormatMessage() {
        return this._invalidNumericFormatMessage;
    }

    public String getInvalidIntegerFormatMessage() {
        return this._invalidIntegerFormatMessage;
    }

    public String getNumberRangeMessage() {
        return this._numberRangeMessage;
    }

    public String getNumberTooLargeMessage() {
        return this._numberTooLargeMessage;
    }

    public String getNumberTooSmallMessage() {
        return this._numberTooSmallMessage;
    }

    public void setInvalidNumericFormatMessage(String string) {
        this._invalidNumericFormatMessage = string;
    }

    public void setInvalidIntegerFormatMessage(String string) {
        this._invalidIntegerFormatMessage = string;
    }

    protected String buildInvalidNumericFormatMessage(IFormComponent field) {
        String pattern = this.getPattern(this.getInvalidNumericFormatMessage(), "invalid-numeric-format", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName());
    }

    protected String buildInvalidIntegerFormatMessage(IFormComponent field) {
        String pattern = this.getPattern(this.getInvalidIntegerFormatMessage(), "invalid-int-format", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName());
    }

    public void setNumberRangeMessage(String string) {
        this._numberRangeMessage = string;
    }

    protected String buildNumberRangeMessage(IFormComponent field) {
        String pattern = this.getPattern(this._numberRangeMessage, "number-range", field.getPage().getLocale());
        return this.formatString(pattern, new Object[]{field.getDisplayName(), this._minimum, this._maximum});
    }

    public void setNumberTooLargeMessage(String string) {
        this._numberTooLargeMessage = string;
    }

    protected String buildNumberTooLargeMessage(IFormComponent field) {
        String pattern = this.getPattern(this._numberTooLargeMessage, "number-too-large", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName(), this._maximum);
    }

    public void setNumberTooSmallMessage(String string) {
        this._numberTooSmallMessage = string;
    }

    protected String buildNumberTooSmallMessage(IFormComponent field) {
        String pattern = this.getPattern(this._numberTooSmallMessage, "number-too-small", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName(), this._minimum);
    }

    public boolean isIntegerNumber() {
        NumberAdaptor result = (NumberAdaptor)_numberAdaptors.getAdaptor(this._valueTypeClass);
        if (result == null) {
            return false;
        }
        return result.getNumberType() == 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        TYPES.put("boolean", Boolean.TYPE);
        TYPES.put("Boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = NumberValidator.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        TYPES.put("java.lang.Boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = NumberValidator.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        TYPES.put("char", Character.TYPE);
        TYPES.put("Character", class$java$lang$Character == null ? (class$java$lang$Character = NumberValidator.class$("java.lang.Character")) : class$java$lang$Character);
        TYPES.put("java.lang.Character", class$java$lang$Character == null ? (class$java$lang$Character = NumberValidator.class$("java.lang.Character")) : class$java$lang$Character);
        TYPES.put("short", Short.TYPE);
        TYPES.put("Short", class$java$lang$Short == null ? (class$java$lang$Short = NumberValidator.class$("java.lang.Short")) : class$java$lang$Short);
        TYPES.put("java.lang.Short", class$java$lang$Short == null ? (class$java$lang$Short = NumberValidator.class$("java.lang.Short")) : class$java$lang$Short);
        TYPES.put("int", Integer.TYPE);
        TYPES.put("Integer", class$java$lang$Integer == null ? (class$java$lang$Integer = NumberValidator.class$("java.lang.Integer")) : class$java$lang$Integer);
        TYPES.put("java.lang.Integer", class$java$lang$Integer == null ? (class$java$lang$Integer = NumberValidator.class$("java.lang.Integer")) : class$java$lang$Integer);
        TYPES.put("long", Long.TYPE);
        TYPES.put("Long", class$java$lang$Long == null ? (class$java$lang$Long = NumberValidator.class$("java.lang.Long")) : class$java$lang$Long);
        TYPES.put("java.lang.Long", class$java$lang$Long == null ? (class$java$lang$Long = NumberValidator.class$("java.lang.Long")) : class$java$lang$Long);
        TYPES.put("float", Float.TYPE);
        TYPES.put("Float", class$java$lang$Float == null ? (class$java$lang$Float = NumberValidator.class$("java.lang.Float")) : class$java$lang$Float);
        TYPES.put("java.lang.Float", class$java$lang$Float == null ? (class$java$lang$Float = NumberValidator.class$("java.lang.Float")) : class$java$lang$Float);
        TYPES.put("byte", Byte.TYPE);
        TYPES.put("Byte", class$java$lang$Byte == null ? (class$java$lang$Byte = NumberValidator.class$("java.lang.Byte")) : class$java$lang$Byte);
        TYPES.put("java.lang.Byte", class$java$lang$Byte == null ? (class$java$lang$Byte = NumberValidator.class$("java.lang.Byte")) : class$java$lang$Byte);
        TYPES.put("double", Double.TYPE);
        TYPES.put("Double", class$java$lang$Double == null ? (class$java$lang$Double = NumberValidator.class$("java.lang.Double")) : class$java$lang$Double);
        TYPES.put("java.lang.Double", class$java$lang$Double == null ? (class$java$lang$Double = NumberValidator.class$("java.lang.Double")) : class$java$lang$Double);
        TYPES.put("java.math.BigInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberValidator.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        TYPES.put("java.math.BigDecimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberValidator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        INT_TYPES = new HashSet();
        _numberAdaptors = new AdaptorRegistry();
        ByteAdaptor byteAdaptor = new ByteAdaptor();
        ShortAdaptor shortAdaptor = new ShortAdaptor();
        IntAdaptor intAdaptor = new IntAdaptor();
        LongAdaptor longAdaptor = new LongAdaptor();
        FloatAdaptor floatAdaptor = new FloatAdaptor();
        DoubleAdaptor doubleAdaptor = new DoubleAdaptor();
        _numberAdaptors.register(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberValidator.class$("java.lang.Byte")) : class$java$lang$Byte, byteAdaptor);
        _numberAdaptors.register(Byte.TYPE, byteAdaptor);
        _numberAdaptors.register(class$java$lang$Short == null ? (class$java$lang$Short = NumberValidator.class$("java.lang.Short")) : class$java$lang$Short, shortAdaptor);
        _numberAdaptors.register(Short.TYPE, shortAdaptor);
        _numberAdaptors.register(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberValidator.class$("java.lang.Integer")) : class$java$lang$Integer, intAdaptor);
        _numberAdaptors.register(Integer.TYPE, intAdaptor);
        _numberAdaptors.register(class$java$lang$Long == null ? (class$java$lang$Long = NumberValidator.class$("java.lang.Long")) : class$java$lang$Long, longAdaptor);
        _numberAdaptors.register(Long.TYPE, longAdaptor);
        _numberAdaptors.register(class$java$lang$Float == null ? (class$java$lang$Float = NumberValidator.class$("java.lang.Float")) : class$java$lang$Float, floatAdaptor);
        _numberAdaptors.register(Float.TYPE, floatAdaptor);
        _numberAdaptors.register(class$java$lang$Double == null ? (class$java$lang$Double = NumberValidator.class$("java.lang.Double")) : class$java$lang$Double, doubleAdaptor);
        _numberAdaptors.register(Double.TYPE, doubleAdaptor);
        _numberAdaptors.register(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberValidator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimalAdaptor());
        _numberAdaptors.register(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberValidator.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigIntegerAdaptor());
    }

    private static class BigIntegerAdaptor
    extends IntegerNumberAdaptor {
        private BigIntegerAdaptor() {
        }

        public Number parse(String value) {
            return new BigInteger(value);
        }

        protected Number coerce(Number number) {
            return new BigInteger(number.toString());
        }
    }

    private static class BigDecimalAdaptor
    extends RealNumberAdaptor {
        private BigDecimalAdaptor() {
        }

        public Number parse(String value) {
            return new BigDecimal(value);
        }

        protected Number coerce(Number number) {
            return new BigDecimal(number.doubleValue());
        }
    }

    private static class DoubleAdaptor
    extends RealNumberAdaptor {
        private DoubleAdaptor() {
        }

        public Number parse(String value) {
            return new Double(value);
        }

        protected Number coerce(Number number) {
            return new Double(number.doubleValue());
        }
    }

    private static class FloatAdaptor
    extends RealNumberAdaptor {
        private FloatAdaptor() {
        }

        public Number parse(String value) {
            return new Float(value);
        }

        protected Number coerce(Number number) {
            return new Float(number.floatValue());
        }
    }

    private static class LongAdaptor
    extends IntegerNumberAdaptor {
        private LongAdaptor() {
        }

        public Number parse(String value) {
            return new Long(value);
        }

        protected Number coerce(Number number) {
            return new Long(number.longValue());
        }
    }

    private static class IntAdaptor
    extends IntegerNumberAdaptor {
        private IntAdaptor() {
        }

        public Number parse(String value) {
            return new Integer(value);
        }

        protected Number coerce(Number number) {
            return new Integer(number.intValue());
        }
    }

    private static class ShortAdaptor
    extends IntegerNumberAdaptor {
        private ShortAdaptor() {
        }

        public Number parse(String value) {
            return new Short(value);
        }

        protected Number coerce(Number number) {
            return new Short(number.shortValue());
        }
    }

    private static class ByteAdaptor
    extends IntegerNumberAdaptor {
        private ByteAdaptor() {
        }

        public Number parse(String value) {
            return new Byte(value);
        }

        protected Number coerce(Number number) {
            return new Byte(number.byteValue());
        }
    }

    private static abstract class RealNumberAdaptor
    extends NumberAdaptor {
        private RealNumberAdaptor() {
        }

        public int getNumberType() {
            return 1;
        }
    }

    private static abstract class IntegerNumberAdaptor
    extends NumberAdaptor {
        private IntegerNumberAdaptor() {
        }

        public int getNumberType() {
            return 0;
        }
    }

    public static abstract class NumberAdaptor {
        public abstract Number parse(String var1);

        public abstract int getNumberType();

        public int compare(Number left, Number right) {
            if (!left.getClass().equals(right.getClass())) {
                right = this.coerce(right);
            }
            Comparable lc = (Comparable)((Object)left);
            return lc.compareTo(right);
        }

        protected abstract Number coerce(Number var1);
    }
}

