/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.twilio.http.HttpClient;
import com.twilio.http.NetworkHttpClient;
import com.twilio.http.Request;
import com.twilio.http.Response;

public class TwilioRestClient {
    public static final int HTTP_STATUS_CODE_CREATED = 201;
    public static final int HTTP_STATUS_CODE_NO_CONTENT = 204;
    public static final int HTTP_STATUS_CODE_OK = 200;
    public static final Predicate<Integer> SUCCESS = new Predicate<Integer>(){

        public boolean apply(Integer i) {
            return i != null && i >= 200 && i < 300;
        }
    };
    private final ObjectMapper objectMapper;
    private final String username;
    private final String password;
    private final String accountSid;
    private final String region;
    private final HttpClient httpClient;

    private TwilioRestClient(Builder b) {
        this.username = b.username;
        this.password = b.password;
        this.accountSid = b.accountSid;
        this.region = b.region;
        this.httpClient = b.httpClient;
        this.objectMapper = new ObjectMapper();
    }

    public Response request(Request request) {
        request.setAuth(this.username, this.password);
        return this.httpClient.reliableRequest(request);
    }

    public String getAccountSid() {
        return this.accountSid;
    }

    public String getRegion() {
        return this.region;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public static class Builder {
        private String username;
        private String password;
        private String accountSid;
        private String region;
        private HttpClient httpClient = new NetworkHttpClient();

        public Builder(String username, String password) {
            this.username = username;
            this.password = password;
            this.accountSid = username;
        }

        public Builder accountSid(String accountSid) {
            this.accountSid = accountSid;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public TwilioRestClient build() {
            return new TwilioRestClient(this);
        }
    }
}

