/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.jwt.taskrouter;

import com.google.common.collect.Lists;
import com.twilio.jwt.Jwt;
import com.twilio.jwt.taskrouter.Policy;
import com.twilio.jwt.taskrouter.PolicyUtils;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskRouterCapability
extends Jwt {
    private final String accountSid;
    private final String workspaceSid;
    private final String friendlyName;
    private final String channelId;
    private final List<Policy> policies;

    private TaskRouterCapability(Builder b) {
        super(SignatureAlgorithm.HS256, b.authToken, b.accountSid, new Date(new Date().getTime() + (long)(b.ttl * 1000)));
        this.accountSid = b.accountSid;
        this.workspaceSid = b.workspaceSid;
        this.channelId = b.channelId;
        this.friendlyName = b.friendlyName;
        this.policies = b.policies;
    }

    @Override
    public Map<String, Object> getHeaders() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("alg", "HS256");
        return headers;
    }

    @Override
    public Map<String, Object> getClaims() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("version", "v1");
        payload.put("account_sid", this.accountSid);
        payload.put("friendly_name", this.friendlyName);
        payload.put("workspace_sid", this.workspaceSid);
        payload.put("channel", this.channelId);
        if (this.channelId.startsWith("WK")) {
            payload.put("worker_sid", this.channelId);
        } else if (this.channelId.startsWith("WQ")) {
            payload.put("taskqueue_sid", this.channelId);
        }
        ArrayList payloadPolicies = Lists.newArrayList(this.policies);
        payloadPolicies.addAll(PolicyUtils.defaultEventBridgePolicies(this.accountSid, this.channelId));
        payload.put("policies", payloadPolicies);
        return payload;
    }

    public static class Builder {
        private String accountSid;
        private String authToken;
        private String workspaceSid;
        private String channelId;
        private String friendlyName;
        private int ttl = 3600;
        private List<Policy> policies = Lists.newArrayList();

        public Builder(String accountSid, String authToken, String workspaceSid, String channelId) {
            this.accountSid = accountSid;
            this.authToken = authToken;
            this.workspaceSid = workspaceSid;
            this.channelId = channelId;
        }

        public Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder policies(List<Policy> policies) {
            this.policies = policies;
            return this;
        }

        public TaskRouterCapability build() {
            return new TaskRouterCapability(this);
        }
    }
}

