/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.ConferenceFetcher;
import com.twilio.rest.api.v2010.account.ConferenceReader;
import com.twilio.rest.api.v2010.account.ConferenceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Conference
extends Resource {
    private static final long serialVersionUID = 150944769427087L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String apiVersion;
    private final String friendlyName;
    private final String region;
    private final String sid;
    private final Status status;
    private final String uri;
    private final Map<String, String> subresourceUris;

    public static ConferenceFetcher fetcher(String accountSid, String sid) {
        return new ConferenceFetcher(accountSid, sid);
    }

    public static ConferenceFetcher fetcher(String sid) {
        return new ConferenceFetcher(sid);
    }

    public static ConferenceReader reader(String accountSid) {
        return new ConferenceReader(accountSid);
    }

    public static ConferenceReader reader() {
        return new ConferenceReader();
    }

    public static ConferenceUpdater updater(String accountSid, String sid) {
        return new ConferenceUpdater(accountSid, sid);
    }

    public static ConferenceUpdater updater(String sid) {
        return new ConferenceUpdater(sid);
    }

    public static Conference fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Conference)objectMapper.readValue(json, Conference.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Conference fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Conference)objectMapper.readValue(json, Conference.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Conference(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="region") String region, @JsonProperty(value="sid") String sid, @JsonProperty(value="status") Status status, @JsonProperty(value="uri") String uri, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.apiVersion = apiVersion;
        this.friendlyName = friendlyName;
        this.region = region;
        this.sid = sid;
        this.status = status;
        this.uri = uri;
        this.subresourceUris = subresourceUris;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getRegion() {
        return this.region;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getUri() {
        return this.uri;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conference other = (Conference)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.region, other.region) && Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.uri, other.uri) && Objects.equals(this.subresourceUris, other.subresourceUris);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.dateCreated, this.dateUpdated, this.apiVersion, this.friendlyName, this.region, this.sid, this.status, this.uri, this.subresourceUris});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("apiVersion", (Object)this.apiVersion).add("friendlyName", (Object)this.friendlyName).add("region", (Object)this.region).add("sid", (Object)this.sid).add("status", (Object)this.status).add("uri", (Object)this.uri).add("subresourceUris", this.subresourceUris).toString();
    }

    public static enum UpdateStatus {
        COMPLETED("completed");

        private final String value;

        private UpdateStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static UpdateStatus forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return UpdateStatus.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }

    public static enum Status {
        INIT("init"),
        IN_PROGRESS("in-progress"),
        COMPLETED("completed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Status.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

