/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.NewSigningKeyCreator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NewSigningKey
extends Resource {
    private static final long serialVersionUID = 61650791237409L;
    private final String sid;
    private final String friendlyName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String secret;

    public static NewSigningKeyCreator creator(String accountSid) {
        return new NewSigningKeyCreator(accountSid);
    }

    public static NewSigningKeyCreator creator() {
        return new NewSigningKeyCreator();
    }

    public static NewSigningKey fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (NewSigningKey)objectMapper.readValue(json, NewSigningKey.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static NewSigningKey fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (NewSigningKey)objectMapper.readValue(json, NewSigningKey.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private NewSigningKey(@JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="secret") String secret) {
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.secret = secret;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getSecret() {
        return this.secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewSigningKey other = (NewSigningKey)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.secret, other.secret);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.friendlyName, this.dateCreated, this.dateUpdated, this.secret);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("friendlyName", (Object)this.friendlyName).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("secret", (Object)this.secret).toString();
    }
}

