/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.api.v2010.account.NotificationDeleter;
import com.twilio.rest.api.v2010.account.NotificationFetcher;
import com.twilio.rest.api.v2010.account.NotificationReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Notification
extends Resource {
    private static final long serialVersionUID = 203437902819777L;
    private final String accountSid;
    private final String apiVersion;
    private final String callSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String errorCode;
    private final String log;
    private final DateTime messageDate;
    private final String messageText;
    private final URI moreInfo;
    private final HttpMethod requestMethod;
    private final URI requestUrl;
    private final String requestVariables;
    private final String responseBody;
    private final String responseHeaders;
    private final String sid;
    private final String uri;

    public static NotificationFetcher fetcher(String accountSid, String sid) {
        return new NotificationFetcher(accountSid, sid);
    }

    public static NotificationFetcher fetcher(String sid) {
        return new NotificationFetcher(sid);
    }

    public static NotificationDeleter deleter(String accountSid, String sid) {
        return new NotificationDeleter(accountSid, sid);
    }

    public static NotificationDeleter deleter(String sid) {
        return new NotificationDeleter(sid);
    }

    public static NotificationReader reader(String accountSid) {
        return new NotificationReader(accountSid);
    }

    public static NotificationReader reader() {
        return new NotificationReader();
    }

    public static Notification fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Notification)objectMapper.readValue(json, Notification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Notification fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Notification)objectMapper.readValue(json, Notification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Notification(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="error_code") String errorCode, @JsonProperty(value="log") String log, @JsonProperty(value="message_date") String messageDate, @JsonProperty(value="message_text") String messageText, @JsonProperty(value="more_info") URI moreInfo, @JsonProperty(value="request_method") HttpMethod requestMethod, @JsonProperty(value="request_url") URI requestUrl, @JsonProperty(value="request_variables") String requestVariables, @JsonProperty(value="response_body") String responseBody, @JsonProperty(value="response_headers") String responseHeaders, @JsonProperty(value="sid") String sid, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.callSid = callSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.errorCode = errorCode;
        this.log = log;
        this.messageDate = DateConverter.rfc2822DateTimeFromString(messageDate);
        this.messageText = messageText;
        this.moreInfo = moreInfo;
        this.requestMethod = requestMethod;
        this.requestUrl = requestUrl;
        this.requestVariables = requestVariables;
        this.responseBody = responseBody;
        this.responseHeaders = responseHeaders;
        this.sid = sid;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getErrorCode() {
        return this.errorCode;
    }

    public final String getLog() {
        return this.log;
    }

    public final DateTime getMessageDate() {
        return this.messageDate;
    }

    public final String getMessageText() {
        return this.messageText;
    }

    public final URI getMoreInfo() {
        return this.moreInfo;
    }

    public final HttpMethod getRequestMethod() {
        return this.requestMethod;
    }

    public final URI getRequestUrl() {
        return this.requestUrl;
    }

    public final String getRequestVariables() {
        return this.requestVariables;
    }

    public final String getResponseBody() {
        return this.responseBody;
    }

    public final String getResponseHeaders() {
        return this.responseHeaders;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification other = (Notification)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.log, other.log) && Objects.equals(this.messageDate, other.messageDate) && Objects.equals(this.messageText, other.messageText) && Objects.equals(this.moreInfo, other.moreInfo) && Objects.equals((Object)this.requestMethod, (Object)other.requestMethod) && Objects.equals(this.requestUrl, other.requestUrl) && Objects.equals(this.requestVariables, other.requestVariables) && Objects.equals(this.responseBody, other.responseBody) && Objects.equals(this.responseHeaders, other.responseHeaders) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.callSid, this.dateCreated, this.dateUpdated, this.errorCode, this.log, this.messageDate, this.messageText, this.moreInfo, this.requestMethod, this.requestUrl, this.requestVariables, this.responseBody, this.responseHeaders, this.sid, this.uri});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("apiVersion", (Object)this.apiVersion).add("callSid", (Object)this.callSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("errorCode", (Object)this.errorCode).add("log", (Object)this.log).add("messageDate", (Object)this.messageDate).add("messageText", (Object)this.messageText).add("moreInfo", (Object)this.moreInfo).add("requestMethod", (Object)this.requestMethod).add("requestUrl", (Object)this.requestUrl).add("requestVariables", (Object)this.requestVariables).add("responseBody", (Object)this.responseBody).add("responseHeaders", (Object)this.responseHeaders).add("sid", (Object)this.sid).add("uri", (Object)this.uri).toString();
    }
}

