/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.api.v2010.account.SandboxFetcher;
import com.twilio.rest.api.v2010.account.SandboxUpdater;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Sandbox
extends Resource {
    private static final long serialVersionUID = 227479628535986L;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Integer pin;
    private final String accountSid;
    private final PhoneNumber phoneNumber;
    private final String applicationSid;
    private final String apiVersion;
    private final URI voiceUrl;
    private final HttpMethod voiceMethod;
    private final URI smsUrl;
    private final HttpMethod smsMethod;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final URI uri;

    public static SandboxFetcher fetcher(String accountSid) {
        return new SandboxFetcher(accountSid);
    }

    public static SandboxFetcher fetcher() {
        return new SandboxFetcher();
    }

    public static SandboxUpdater updater(String accountSid) {
        return new SandboxUpdater(accountSid);
    }

    public static SandboxUpdater updater() {
        return new SandboxUpdater();
    }

    public static Sandbox fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Sandbox)objectMapper.readValue(json, Sandbox.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Sandbox fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Sandbox)objectMapper.readValue(json, Sandbox.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Sandbox(@JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="pin") Integer pin, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="application_sid") String applicationSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="voice_url") URI voiceUrl, @JsonProperty(value="voice_method") HttpMethod voiceMethod, @JsonProperty(value="sms_url") URI smsUrl, @JsonProperty(value="sms_method") HttpMethod smsMethod, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="status_callback_method") HttpMethod statusCallbackMethod, @JsonProperty(value="uri") URI uri) {
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.pin = pin;
        this.accountSid = accountSid;
        this.phoneNumber = phoneNumber;
        this.applicationSid = applicationSid;
        this.apiVersion = apiVersion;
        this.voiceUrl = voiceUrl;
        this.voiceMethod = voiceMethod;
        this.smsUrl = smsUrl;
        this.smsMethod = smsMethod;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.uri = uri;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Integer getPin() {
        return this.pin;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getApplicationSid() {
        return this.applicationSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final URI getVoiceUrl() {
        return this.voiceUrl;
    }

    public final HttpMethod getVoiceMethod() {
        return this.voiceMethod;
    }

    public final URI getSmsUrl() {
        return this.smsUrl;
    }

    public final HttpMethod getSmsMethod() {
        return this.smsMethod;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public final URI getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sandbox other = (Sandbox)o;
        return Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.pin, other.pin) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.applicationSid, other.applicationSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.voiceUrl, other.voiceUrl) && Objects.equals((Object)this.voiceMethod, (Object)other.voiceMethod) && Objects.equals(this.smsUrl, other.smsUrl) && Objects.equals((Object)this.smsMethod, (Object)other.smsMethod) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals((Object)this.statusCallbackMethod, (Object)other.statusCallbackMethod) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateCreated, this.dateUpdated, this.pin, this.accountSid, this.phoneNumber, this.applicationSid, this.apiVersion, this.voiceUrl, this.voiceMethod, this.smsUrl, this.smsMethod, this.statusCallback, this.statusCallbackMethod, this.uri});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("pin", (Object)this.pin).add("accountSid", (Object)this.accountSid).add("phoneNumber", (Object)this.phoneNumber).add("applicationSid", (Object)this.applicationSid).add("apiVersion", (Object)this.apiVersion).add("voiceUrl", (Object)this.voiceUrl).add("voiceMethod", (Object)this.voiceMethod).add("smsUrl", (Object)this.smsUrl).add("smsMethod", (Object)this.smsMethod).add("statusCallback", (Object)this.statusCallback).add("statusCallbackMethod", (Object)this.statusCallbackMethod).add("uri", (Object)this.uri).toString();
    }
}

