/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.ShortCode;
import java.net.URI;

public class ShortCodeUpdater
extends Updater<ShortCode> {
    private String accountSid;
    private final String sid;
    private String friendlyName;
    private String apiVersion;
    private URI smsUrl;
    private HttpMethod smsMethod;
    private URI smsFallbackUrl;
    private HttpMethod smsFallbackMethod;

    public ShortCodeUpdater(String sid) {
        this.sid = sid;
    }

    public ShortCodeUpdater(String accountSid, String sid) {
        this.accountSid = accountSid;
        this.sid = sid;
    }

    public ShortCodeUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ShortCodeUpdater setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public ShortCodeUpdater setSmsUrl(URI smsUrl) {
        this.smsUrl = smsUrl;
        return this;
    }

    public ShortCodeUpdater setSmsUrl(String smsUrl) {
        return this.setSmsUrl(Promoter.uriFromString(smsUrl));
    }

    public ShortCodeUpdater setSmsMethod(HttpMethod smsMethod) {
        this.smsMethod = smsMethod;
        return this;
    }

    public ShortCodeUpdater setSmsFallbackUrl(URI smsFallbackUrl) {
        this.smsFallbackUrl = smsFallbackUrl;
        return this;
    }

    public ShortCodeUpdater setSmsFallbackUrl(String smsFallbackUrl) {
        return this.setSmsFallbackUrl(Promoter.uriFromString(smsFallbackUrl));
    }

    public ShortCodeUpdater setSmsFallbackMethod(HttpMethod smsFallbackMethod) {
        this.smsFallbackMethod = smsFallbackMethod;
        return this;
    }

    @Override
    public ShortCode update(TwilioRestClient client) {
        this.accountSid = this.accountSid == null ? client.getAccountSid() : this.accountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.accountSid + "/SMS/ShortCodes/" + this.sid + ".json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ShortCode update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return ShortCode.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.apiVersion != null) {
            request.addPostParam("ApiVersion", this.apiVersion);
        }
        if (this.smsUrl != null) {
            request.addPostParam("SmsUrl", this.smsUrl.toString());
        }
        if (this.smsMethod != null) {
            request.addPostParam("SmsMethod", this.smsMethod.toString());
        }
        if (this.smsFallbackUrl != null) {
            request.addPostParam("SmsFallbackUrl", this.smsFallbackUrl.toString());
        }
        if (this.smsFallbackMethod != null) {
            request.addPostParam("SmsFallbackMethod", this.smsFallbackMethod.toString());
        }
    }
}

