/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.TokenCreator;
import com.twilio.type.IceServer;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Token
extends Resource {
    private static final long serialVersionUID = 281090396283982L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final List<IceServer> iceServers;
    private final String password;
    private final String ttl;
    private final String username;

    public static TokenCreator creator(String accountSid) {
        return new TokenCreator(accountSid);
    }

    public static TokenCreator creator() {
        return new TokenCreator();
    }

    public static Token fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Token)objectMapper.readValue(json, Token.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Token fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Token)objectMapper.readValue(json, Token.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Token(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="ice_servers") List<IceServer> iceServers, @JsonProperty(value="password") String password, @JsonProperty(value="ttl") String ttl, @JsonProperty(value="username") String username) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.iceServers = iceServers;
        this.password = password;
        this.ttl = ttl;
        this.username = username;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final List<IceServer> getIceServers() {
        return this.iceServers;
    }

    public final String getPassword() {
        return this.password;
    }

    public final String getTtl() {
        return this.ttl;
    }

    public final String getUsername() {
        return this.username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token other = (Token)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.iceServers, other.iceServers) && Objects.equals(this.password, other.password) && Objects.equals(this.ttl, other.ttl) && Objects.equals(this.username, other.username);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.iceServers, this.password, this.ttl, this.username);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("iceServers", this.iceServers).add("password", (Object)this.password).add("ttl", (Object)this.ttl).add("username", (Object)this.username).toString();
    }
}

